/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.exp10;

import java.util.EnumSet;
import java.util.List;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WitherWave
extends Goal {
    private final Mob mob;
    private final UniformInt cooldownProvider;
    private int cooldown;

    public WitherWave(Mob mob, UniformInt cooldownProvider) {
        this.mob = mob;
        this.cooldownProvider = cooldownProvider;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        return this.mob.m_5448_() != null && this.mob.m_20280_((Entity)this.mob.m_5448_()) >= 16.0;
    }

    public void m_8056_() {
        super.m_8056_();
        double radius = 1.0;
        double angle = 25.0;
        for (double theta = 0.0; theta < 360.0; theta += angle) {
            double angleTheta = Math.toRadians(theta);
            for (double phi = 0.0; phi <= 180.0; phi += angle) {
                double anglePhi = Math.toRadians(phi);
                double x = this.mob.m_20185_() + Math.sin(anglePhi) * Math.cos(angleTheta) * radius;
                double y = this.mob.m_20186_() + Math.cos(anglePhi) * radius;
                double z = this.mob.m_20189_() + Math.sin(anglePhi) * Math.sin(angleTheta) * radius;
                Vec3 pos = new Vec3(x, y, z);
                ParticlesUtil.sendParticlesWithMotion(this.mob.m_183503_(), (ParticleOptions)ParticleTypes.f_123798_, pos, Vec3.f_82478_, this.mob.m_20182_().m_82546_(pos), 1, 1.0f);
            }
        }
    }

    public void m_8037_() {
        Level level = this.mob.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List nearby = serverLevel.m_6443_(LivingEntity.class, this.mob.m_142469_().m_82400_(16.0), EntitySelector.f_20403_);
            for (LivingEntity entity : nearby) {
                if (entity == this.mob || entity.m_21023_(MobEffects.f_19615_)) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 1));
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 8, 0.5, 0.5, 0.5, 0.1);
            }
        }
        this.cooldown = this.cooldownProvider.m_142270_(this.mob.m_21187_());
    }
}

