/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.exp9;

import com.google.common.collect.Iterables;
import java.util.Random;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;

public class InductionCoilGoal
extends Goal {
    protected final PathfinderMob holder;
    protected final IntProvider cooldownProvider;
    protected final float tooFarSqr;
    protected final IntProvider durationProvider;
    protected final FloatProvider damageProvider;
    protected LivingEntity target;
    protected int cooldown;
    protected int duration;
    protected Iterable<ItemStack> items;

    public InductionCoilGoal(PathfinderMob holder, IntProvider cooldown, float tooFar, IntProvider duration, FloatProvider damage) {
        this.holder = holder;
        this.cooldownProvider = cooldown;
        this.tooFarSqr = tooFar * tooFar;
        this.durationProvider = duration;
        this.damageProvider = damage;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_8036_() {
        boolean stuck;
        this.target = this.holder.m_5448_();
        if (this.target == null || !this.target.m_6084_()) {
            return false;
        }
        Path path = this.holder.m_21573_().m_26570_();
        boolean bl = stuck = path != null && !path.m_77403_() || this.holder.m_20280_((Entity)this.target) > (double)this.tooFarSqr;
        if (this.cooldown > 0) {
            --this.cooldown;
            if (stuck) {
                --this.cooldown;
            }
            return false;
        }
        return stuck;
    }

    public boolean m_8045_() {
        return this.target.m_6084_() && this.duration > 0;
    }

    public void m_8056_() {
        this.duration = this.durationProvider.m_142270_(this.holder.m_21187_());
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.items = Iterables.concat((Iterable)this.target.m_6167_(), (Iterable)this.target.m_6168_(), (Iterable)Iterables.limit((Iterable)player.m_150109_().f_35974_, (int)9));
        } else {
            this.items = Iterables.concat((Iterable)this.target.m_6167_(), (Iterable)this.target.m_6168_());
        }
        this.holder.f_19853_.m_6269_(null, (Entity)this.holder, SoundEvents.f_12521_, SoundSource.MASTER, 10000.0f, 0.8f + this.holder.m_21187_().nextFloat(0.2f));
    }

    public void m_8037_() {
        if (this.duration <= 0) {
            return;
        }
        Path path = this.holder.m_21573_().m_26570_();
        if ((path == null || path.m_77403_()) && this.holder.m_20280_((Entity)this.target) < (double)this.tooFarSqr) {
            --this.duration;
        }
        this.spawnParticles();
        if (this.holder.f_19797_ % 20 != 0) {
            return;
        }
        Random random = this.holder.m_21187_();
        int metal = 0;
        int slots = 0;
        for (ItemStack stack : this.items) {
            ++slots;
            if (stack.m_204117_(ChangedAddonTags.Items.METAL)) {
                this.hurtAndBreak(stack, (int)Math.max(2.0f, (float)stack.m_41776_() * 0.02f), random);
                ++metal;
            }
            if (!stack.m_204117_(ChangedAddonTags.Items.PARTIAL_METAL)) continue;
            this.hurtAndBreak(stack, (int)Math.max(1.0f, (float)stack.m_41776_() * 0.01f), random);
            ++metal;
        }
        float metalPercentage = Math.max((float)metal / (float)slots, 0.1f);
        this.target.m_6469_(DamageSource.f_19305_, this.damageProvider.m_142269_(random) * metalPercentage);
        this.target.m_20254_(5);
    }

    protected void spawnParticles() {
        float radius = 2.0f;
        float ringHeight = this.target.m_20206_() / 4.0f + 0.1f;
        for (int ring = 0; ring < 4; ++ring) {
            for (int i = 0; i < 10; ++i) {
                float rad = (float)(i * 36) * ((float)Math.PI / 180);
                float x = Mth.m_14089_((float)rad) * 2.0f;
                float z = Mth.m_14031_((float)rad) * 2.0f;
                ((ServerLevel)this.holder.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.target.m_20185_() + (double)x - 0.05, this.target.m_20186_() + (double)(ringHeight * (float)ring) - 0.05, this.target.m_20189_() + (double)z - 0.05, 5, 0.1, 0.1, 0.1, 0.0);
            }
        }
    }

    protected void hurtAndBreak(ItemStack stack, int damage, Random random) {
        if (!stack.m_41763_() || !stack.m_41629_(damage, random, null)) {
            return;
        }
        stack.m_41774_(1);
        stack.m_41721_(0);
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36246_(Stats.f_12983_.m_12902_((Object)stack.m_41720_()));
        }
    }

    public void m_8041_() {
        this.target = null;
        this.cooldown = this.cooldownProvider.m_142270_(this.holder.m_21187_());
        this.duration = 0;
        this.items = null;
    }
}

