/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.exp9;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.foxyas.changedaddon.entity.goals.exp9.SummonLightningGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LightningComboAttackGoal
extends Goal {
    protected final PathfinderMob holder;
    protected final Random random;
    protected final IntProvider cooldownProvider;
    protected final IntProvider attackCountProvider;
    protected final IntProvider castDurationProvider;
    protected final FloatProvider damageProvider;
    protected final DamageSource source;
    protected LivingEntity target;
    protected int cooldown;
    protected int attacks;
    protected Vec3 attackPos;
    protected int aboveWaterY;
    protected int castDuration;
    protected int wasBlocked;

    public LightningComboAttackGoal(PathfinderMob holder, IntProvider cooldown, IntProvider attackCount, IntProvider castDuration, FloatProvider damage) {
        this.holder = holder;
        this.random = holder.m_21187_();
        this.cooldownProvider = cooldown;
        this.attackCountProvider = attackCount;
        this.castDurationProvider = castDuration;
        this.damageProvider = damage;
        this.source = new EntityDamageSource("lightningBolt", (Entity)holder){

            @Nullable
            public Vec3 m_7270_() {
                return LightningComboAttackGoal.this.attackPos;
            }
        };
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.target = this.holder.m_5448_();
        return this.target != null && this.target.m_6084_();
    }

    public boolean m_8045_() {
        return this.target.m_6084_() && this.attacks > 0;
    }

    public void m_8056_() {
        this.attacks = this.attackCountProvider.m_142270_(this.random);
        this.castDuration = this.castDurationProvider.m_142270_(this.random);
        this.pickAttackPos();
        this.holder.m_21573_().m_26573_();
        this.holder.m_21563_().m_148051_((Entity)this.target);
    }

    protected void pickAttackPos() {
        this.attackPos = this.target.m_20182_();
        Level level = this.holder.f_19853_;
        BlockPos pos = new BlockPos(this.attackPos);
        if (level.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
            while (level.m_8055_(pos = pos.m_7494_()).m_60713_(Blocks.f_49990_)) {
            }
            this.aboveWaterY = pos.m_123342_();
        } else {
            this.aboveWaterY = Integer.MAX_VALUE;
        }
    }

    public void m_8037_() {
        if (this.attacks <= 0) {
            return;
        }
        Level level = this.holder.f_19853_;
        if (this.target != null) {
            this.holder.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        }
        if (this.wasBlocked > 0) {
            --this.wasBlocked;
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.holder.m_20185_() - 1.5, this.holder.m_20186_() - 1.5 + (double)(this.holder.m_20206_() / 2.0f), this.holder.m_20189_() - 1.5, 50 * this.wasBlocked / 30, 3.0, 3.0, 3.0, 0.5);
            if (this.wasBlocked == 0) {
                this.pickAttackPos();
            }
            return;
        }
        if (this.castDuration > 0) {
            --this.castDuration;
            if (this.holder.f_19797_ % 2 == 0) {
                if (this.aboveWaterY != Integer.MAX_VALUE) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.attackPos.f_82479_ - 1.0, (double)this.aboveWaterY, this.attackPos.f_82481_ - 1.0, 50, 2.0, 0.2, 2.0, 0.5);
                }
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.attackPos.f_82479_ - 1.0, this.attackPos.f_82480_, this.attackPos.f_82481_ - 1.0, 50, 2.0, 0.2, 2.0, 0.5);
            }
            return;
        }
        --this.attacks;
        this.holder.m_6021_(this.attackPos.f_82479_, this.attackPos.f_82480_, this.attackPos.f_82481_);
        this.holder.m_6674_(InteractionHand.MAIN_HAND);
        SummonLightningGoal.lightning(this.holder.f_19853_, this.attackPos.f_82479_, this.attackPos.f_82480_, this.attackPos.f_82481_, 1.0f);
        if (this.attacks == 0) {
            SummonLightningGoal.lightning(level, this.attackPos.f_82479_ + 0.75, this.attackPos.f_82480_, this.attackPos.f_82481_ + 0.75, 0.0f);
            SummonLightningGoal.lightning(level, this.attackPos.f_82479_ + 0.75, this.attackPos.f_82480_, this.attackPos.f_82481_ - 0.75, 0.0f);
            SummonLightningGoal.lightning(level, this.attackPos.f_82479_ - 0.75, this.attackPos.f_82480_, this.attackPos.f_82481_ - 0.75, 0.0f);
            SummonLightningGoal.lightning(level, this.attackPos.f_82479_ - 0.75, this.attackPos.f_82480_, this.attackPos.f_82481_ + 0.75, 0.0f);
            this.applyKnockbackAndHurt(6.0f, 2.0f, 3.0f);
        } else {
            this.castDuration = this.castDurationProvider.m_142270_(this.random);
            if (this.applyKnockbackAndHurt(4.0f, 1.0f, 1.0f)) {
                this.wasBlocked = 60;
            } else {
                this.pickAttackPos();
            }
        }
    }

    protected boolean applyKnockbackAndHurt(float radius, float damageMul, float knockbackMul) {
        float knockback;
        Vec3 direction;
        Level level = this.holder.f_19853_;
        float diameter = radius * 2.0f;
        float radiusSqr = radius * radius;
        List list = level.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26888_(target -> !target.m_7306_((Entity)this.holder)), (LivingEntity)this.holder, AABB.m_165882_((Vec3)this.attackPos, (double)diameter, (double)diameter, (double)diameter));
        boolean anyBlocked = false;
        for (LivingEntity livingEntity : list) {
            float dist = (float)livingEntity.m_20238_(this.attackPos);
            if (dist > radiusSqr) continue;
            dist = Mth.m_14116_((float)dist);
            boolean blocked = livingEntity.m_21275_(this.source);
            livingEntity.m_6469_(this.source, this.damageProvider.m_142269_(this.random) * damageMul);
            direction = livingEntity.m_20182_().m_82546_(this.attackPos).m_82541_();
            knockback = radius / dist * knockbackMul;
            if (blocked) {
                knockback *= 0.25f;
                anyBlocked = true;
            }
            livingEntity.m_5997_(direction.f_82479_ * (double)knockback, direction.f_82480_ * (double)knockback, direction.f_82481_ * (double)knockback);
        }
        if (anyBlocked) {
            level.m_6269_(null, (Entity)this.holder, SoundEvents.f_12513_, SoundSource.MASTER, 10.0f, 1.0f);
            knockback = knockbackMul * 0.5f;
            direction = this.holder.m_20154_().m_82548_();
            this.holder.m_5997_(direction.f_82479_ * (double)knockback, direction.f_82480_ * (double)knockback, direction.f_82481_ * (double)knockback);
        }
        return anyBlocked;
    }

    public void m_8041_() {
        this.target = null;
        this.cooldown = this.cooldownProvider.m_142270_(this.random);
        this.attacks = 0;
        this.attackPos = null;
        this.castDuration = 0;
        this.wasBlocked = 0;
    }
}

