/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.exp9;

import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
public class SummonLightningGoal
extends Goal {
    protected final PathfinderMob holder;
    protected final IntProvider cooldownProvider;
    protected final IntProvider lightningCountProvider;
    protected final IntProvider castDurationProvider;
    protected final IntProvider lightningDelayProvider;
    protected final FloatProvider damageProvider;
    protected LivingEntity target;
    protected int cooldown;
    protected int lightnings;
    protected int castDuration;
    protected int lightningDelay;
    protected Vec3 strikePos;
    protected BlockPos aboveWaterPos;

    public SummonLightningGoal(PathfinderMob holder, IntProvider cooldown, IntProvider lightningCount, IntProvider castDuration, IntProvider lightningDelay, FloatProvider damage) {
        this.holder = holder;
        this.cooldownProvider = cooldown;
        assert (lightningCount.m_142739_() >= 1);
        this.lightningCountProvider = lightningCount;
        this.castDurationProvider = castDuration;
        this.lightningDelayProvider = lightningDelay;
        this.damageProvider = damage;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.target = this.holder.m_5448_();
        return this.target != null && this.target.m_6084_() && this.target.m_20096_();
    }

    public boolean m_8045_() {
        return this.lightnings > 0 && this.target.m_6084_();
    }

    public void m_8056_() {
        this.lightnings = this.lightningCountProvider.m_142270_(this.holder.m_21187_());
        this.castDuration = this.castDurationProvider.m_142270_(this.holder.m_21187_());
        this.holder.f_19853_.m_6263_(null, this.holder.m_20185_(), this.holder.m_20186_(), this.holder.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 1.0f, 1.0f);
        this.holder.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.lightnings <= 0) {
            return;
        }
        Level level = this.holder.f_19853_;
        if (this.castDuration > 0) {
            --this.castDuration;
            this.holder.m_20256_(Vec3.f_82478_);
            this.holder.m_21563_().m_148051_((Entity)this.target);
            if (this.holder.f_19797_ % 2 == 0) {
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.holder.m_20185_() - 0.5, this.holder.m_20186_(), this.holder.m_20189_() - 0.5, 25, 1.0, 0.1, 1.0, 0.5);
            }
            return;
        }
        Random random = this.holder.m_21187_();
        if (this.strikePos == null) {
            this.strikePos = this.target.m_20182_();
            BlockPos pos = new BlockPos(this.strikePos);
            if (level.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
                while (level.m_8055_(pos = pos.m_7494_()).m_60713_(Blocks.f_49990_)) {
                }
                this.aboveWaterPos = pos;
            }
            this.lightningDelay = this.lightningDelayProvider.m_142270_(random);
        }
        if (this.lightningDelay > 0) {
            --this.lightningDelay;
            int gameTime = this.holder.f_19797_;
            if (gameTime % 2 == 0) {
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.strikePos.f_82479_ - 1.0, this.aboveWaterPos != null ? (double)this.aboveWaterPos.m_123342_() : this.strikePos.f_82480_, this.strikePos.f_82481_ - 1.0, 50, 2.0, 0.2, 2.0, 0.5);
            }
            if ((gameTime + 10) % 40 == 0) {
                level.m_6263_(null, this.strikePos.f_82479_, this.strikePos.f_82480_, this.strikePos.f_82481_, SoundEvents.f_12090_, SoundSource.WEATHER, 0.5f, 1.0f);
            }
            return;
        }
        --this.lightnings;
        SummonLightningGoal.lightning(level, this.strikePos.f_82479_, this.strikePos.f_82480_, this.strikePos.f_82481_, this.damageProvider.m_142269_(random));
        SummonLightningGoal.lightning(level, this.strikePos.f_82479_ + 0.75, this.strikePos.f_82480_, this.strikePos.f_82481_ + 0.75, this.damageProvider.m_142269_(random));
        SummonLightningGoal.lightning(level, this.strikePos.f_82479_ + 0.75, this.strikePos.f_82480_, this.strikePos.f_82481_ - 0.75, this.damageProvider.m_142269_(random));
        SummonLightningGoal.lightning(level, this.strikePos.f_82479_ - 0.75, this.strikePos.f_82480_, this.strikePos.f_82481_ - 0.75, this.damageProvider.m_142269_(random));
        SummonLightningGoal.lightning(level, this.strikePos.f_82479_ - 0.75, this.strikePos.f_82480_, this.strikePos.f_82481_ + 0.75, this.damageProvider.m_142269_(random));
        this.applyKnockBack(AABB.m_165882_((Vec3)this.strikePos, (double)16.0, (double)16.0, (double)16.0));
        this.strikePos = null;
        this.aboveWaterPos = null;
    }

    public static void lightning(Level level, double x, double y, double z, float damage) {
        LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level);
        assert (lightning != null);
        lightning.m_6027_(x, y, z);
        if (damage > 0.0f) {
            lightning.setDamage(damage);
        } else {
            lightning.m_20874_(true);
        }
        level.m_7967_((Entity)lightning);
    }

    public void applyKnockBack(AABB hitbox) {
        List list = this.holder.m_183503_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26888_(target -> !target.m_7306_((Entity)this.holder)), (LivingEntity)this.holder, hitbox);
        for (LivingEntity livingEntity : list) {
            Vec3 direction = livingEntity.m_20182_().m_82546_(this.strikePos).m_82541_();
            float strength = 6.0f / (float)Math.sqrt(livingEntity.m_20238_(this.strikePos));
            livingEntity.m_5997_(direction.f_82479_ * (double)strength, Math.max(direction.f_82480_, 0.1) * (double)strength * 2.0, direction.f_82481_ * (double)strength);
        }
    }

    public void m_8041_() {
        this.target = null;
        this.cooldown = this.cooldownProvider.m_142270_(this.holder.m_21187_());
        this.lightnings = 0;
        this.strikePos = null;
        this.aboveWaterPos = null;
    }
}

