/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.exp9;

import java.util.EnumSet;
import java.util.List;
import net.foxyas.changedaddon.util.DelayedTask;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ThunderDiveGoal
extends Goal {
    private final PathfinderMob mob;
    private final double ascendBoost;
    private final double ascendHoldY;
    private final double diveSpeedXZ;
    private final double diveSpeedY;
    private final float ringRadius;
    private Phase phase;
    private int ticks;
    private BlockPos startGroundPos;
    protected final IntProvider cooldownProvider;
    public int cooldown = 0;
    private Vec3 lateral = Vec3.f_82478_;

    public ThunderDiveGoal(PathfinderMob mob, IntProvider cooldownProvider, double ascendBoost, double ascendHoldY, double diveSpeedXZ, double diveSpeedY, float ringRadius) {
        this.mob = mob;
        this.cooldownProvider = cooldownProvider;
        this.ascendBoost = ascendBoost;
        this.ascendHoldY = ascendHoldY;
        this.diveSpeedXZ = diveSpeedXZ;
        this.diveSpeedY = diveSpeedY;
        this.ringRadius = ringRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_8036_() {
        LivingEntity t = this.mob.m_5448_();
        if (this.cooldown > 0) {
            --this.cooldown;
            if (t != null && (t.m_21255_() || !t.m_20096_())) {
                this.cooldown -= 2;
            } else if (t instanceof Player) {
                Player player = (Player)t;
                if (player.m_150110_().f_35935_) {
                    this.cooldown -= 2;
                }
            }
            return false;
        }
        return t != null && t.m_6084_() && this.mob.m_20096_();
    }

    public void m_8056_() {
        this.phase = Phase.ASCEND;
        this.ticks = 0;
        this.startGroundPos = this.mob.m_142538_();
        LivingEntity t = this.mob.m_5448_();
        Vec3 dir = t != null ? this.mob.m_20182_().m_82505_(t.m_20182_()).m_82541_() : Vec3.f_82478_;
        this.mob.m_20256_(this.mob.m_20184_().m_82520_(dir.f_82479_ * 0.2, this.ascendBoost, dir.f_82481_ * 0.2));
        ChangedSounds.broadcastSound((Entity)this.mob, (SoundEvent)ChangedSounds.BOW2, (float)1.0f, (float)1.0f);
        this.mob.m_20242_(true);
        this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 0, false, false));
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_8045_() {
        return this.phase != null && !this.mob.m_20096_();
    }

    public void m_8037_() {
        ++this.ticks;
        LivingEntity t = this.mob.m_5448_();
        if (t != null) {
            this.mob.m_21563_().m_24960_((Entity)t, 30.0f, 30.0f);
        }
        switch (this.phase) {
            case ASCEND: {
                boolean timeout;
                boolean highEnough = this.mob.m_20186_() >= (double)this.startGroundPos.m_123342_() + this.ascendHoldY;
                boolean bl = timeout = this.ticks > 60;
                if (highEnough || timeout) {
                    this.phase = Phase.DIVE;
                    this.mob.m_20242_(false);
                    Vec3 lateral = Vec3.f_82478_;
                    if (t != null) {
                        Vec3 toT = this.mob.m_20182_().m_82505_(t.m_20182_());
                        lateral = new Vec3(toT.f_82479_, 0.0, toT.f_82481_).m_82541_().m_82490_(this.diveSpeedXZ);
                    }
                    this.mob.m_20334_(lateral.f_82479_, -Math.abs(this.diveSpeedY), lateral.f_82481_);
                    this.lateral = lateral;
                    break;
                }
                Vec3 dm = this.mob.m_20184_();
                if (!(dm.f_82480_ > 0.6)) break;
                this.mob.m_20334_(dm.f_82479_, 0.6, dm.f_82481_);
                break;
            }
            case DIVE: {
                if (t != null) {
                    this.mob.m_20334_(this.lateral.f_82479_, -Math.abs(this.diveSpeedY), this.lateral.f_82481_);
                    Vec3 position = this.mob.m_20182_().m_82520_(this.lateral.f_82479_, -Math.abs(this.diveSpeedY), this.lateral.f_82481_);
                    this.mob.m_21563_().m_24950_(position.f_82479_, position.f_82480_, position.f_82481_, 30.0f, 30.0f);
                    this.affectNearbyEntities(this.lateral);
                    break;
                }
                this.mob.m_20334_(0.0, -Math.abs(this.diveSpeedY), 0.0);
                Vec3 position = this.mob.m_20182_().m_82520_(0.0, -Math.abs(this.diveSpeedY), 0.0);
                this.mob.m_21563_().m_24950_(position.f_82479_, position.f_82480_, position.f_82481_, 30.0f, 30.0f);
                this.affectNearbyEntities(new Vec3(0.0, -Math.abs(this.diveSpeedY), 0.0));
            }
        }
    }

    private void affectNearbyEntities(Vec3 lateral) {
        for (LivingEntity livingEntity : this.mob.m_183503_().m_45976_(LivingEntity.class, this.mob.m_142469_().m_82400_(4.0))) {
            if (livingEntity.m_21255_()) {
                livingEntity.m_20334_(lateral.f_82479_, -Math.abs(this.diveSpeedY), lateral.f_82481_);
                ChangedSounds.broadcastSound((Entity)livingEntity, (SoundEvent)SoundEvents.f_12313_, (float)1.0f, (float)1.0f);
                continue;
            }
            if (!(livingEntity instanceof Player)) continue;
            Player player = (Player)livingEntity;
            if (!player.m_150110_().f_35935_) continue;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_150110_().f_35935_ = false;
                serverPlayer.m_20334_(lateral.f_82479_, -Math.abs(this.diveSpeedY), lateral.f_82481_);
                serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket(serverPlayer.m_142049_(), serverPlayer.m_20184_()));
                ChangedSounds.broadcastSound((Entity)serverPlayer, (SoundEvent)SoundEvents.f_12313_, (float)1.0f, (float)1.0f);
                continue;
            }
            player.m_150110_().f_35935_ = false;
            player.m_20334_(lateral.f_82479_, -Math.abs(this.diveSpeedY), lateral.f_82481_);
            ChangedSounds.broadcastSound((Entity)player, (SoundEvent)SoundEvents.f_12313_, (float)1.0f, (float)1.0f);
        }
    }

    public void m_8041_() {
        this.mob.m_20242_(false);
        this.mob.m_21195_(MobEffects.f_19591_);
        this.phase = null;
        Level level = this.mob.m_183503_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos center = this.mob.m_142538_();
        this.applyKnockBack(center);
        ThunderDiveGoal.spawnThunderCircle(serverLevel, center, this.ringRadius, 6);
        DelayedTask.schedule(5, () -> ThunderDiveGoal.spawnThunderCircle(serverLevel, center, (double)this.ringRadius * 1.4, 4));
        DelayedTask.schedule(10, () -> ThunderDiveGoal.spawnThunderCircle(serverLevel, center, (double)this.ringRadius * 1.8, 8));
        DelayedTask.schedule(15, () -> ThunderDiveGoal.spawnThunderCircle(serverLevel, center, (double)this.ringRadius * 2.2, 14));
        serverLevel.m_46796_(2001, center, Block.m_49956_((BlockState)Blocks.f_152587_.m_49966_()));
        this.cooldown = this.cooldownProvider.m_142270_(this.mob.m_21187_());
    }

    public void applyKnockBack(BlockPos pos) {
        List list = this.mob.m_183503_().m_6443_(LivingEntity.class, new AABB(pos).m_82400_(16.0), target -> !target.m_7306_((Entity)this.mob));
        for (LivingEntity livingEntity : list) {
            Vec3 direction = livingEntity.m_20182_().m_82546_(this.mob.m_20182_());
            direction = direction.m_82541_();
            double strength = 10.0 / (double)livingEntity.m_20270_((Entity)this.mob);
            livingEntity.m_5997_(direction.f_82479_ * strength, direction.f_82480_ * strength * 0.5, direction.f_82481_ * strength);
        }
    }

    public static void spawnThunderCircle(ServerLevel level, BlockPos center, double radius, int bolts) {
        for (int i = 0; i < bolts; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)bolts;
            double x = (double)center.m_123341_() + 0.5 + radius * Math.cos(angle);
            double z = (double)center.m_123343_() + 0.5 + radius * Math.sin(angle);
            int topY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mth.m_14107_((double)x), Mth.m_14107_((double)z));
            if (level.m_6042_().m_63946_()) {
                int maxY;
                for (int y = maxY = level.m_141928_() - 1; y > 0; --y) {
                    BlockPos checkPos = new BlockPos(x, (double)y, z);
                    if (!level.m_46859_(checkPos) || !level.m_46859_(checkPos.m_7494_())) continue;
                    topY = y;
                    break;
                }
            }
            BlockPos strikePos = new BlockPos(Mth.m_14107_((double)x), topY, Mth.m_14107_((double)z));
            LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
            if (bolt == null) continue;
            bolt.m_6027_((double)strikePos.m_123341_() + 0.5, (double)strikePos.m_123342_(), (double)strikePos.m_123343_() + 0.5);
            bolt.m_20874_(false);
            bolt.setDamage(2.0f);
            level.m_7967_((Entity)bolt);
        }
    }

    private static enum Phase {
        ASCEND,
        DIVE;

    }
}

