/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.exp9;

import java.util.EnumSet;
import java.util.List;
import net.foxyas.changedaddon.init.ChangedAddonParticleTypes;
import net.foxyas.changedaddon.util.DelayedTask;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.Vec3;

public class ThunderStrikeGoal
extends Goal {
    private final PathfinderMob pathfinderMob;
    private final double jumpPower;
    private final int duration;
    private int tickCounter;
    private BlockPos groundPos;
    private LivingEntity target;
    protected final IntProvider cooldownProvider;
    public int cooldown = 0;

    public ThunderStrikeGoal(PathfinderMob pathfinderMob, IntProvider cooldownProvider, double jumpPower, int duration) {
        this.pathfinderMob = pathfinderMob;
        this.jumpPower = jumpPower;
        this.duration = duration;
        this.cooldownProvider = cooldownProvider;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        LivingEntity target = this.pathfinderMob.m_5448_();
        return target != null && target.m_6084_() && this.pathfinderMob.m_20096_();
    }

    public void m_8056_() {
        this.target = this.pathfinderMob.m_5448_();
        this.groundPos = this.pathfinderMob.m_142538_();
        this.tickCounter = 0;
        Vec3 velocity = this.pathfinderMob.m_20182_().m_82505_(this.target.m_20182_()).m_82541_().m_82490_(0.5);
        this.pathfinderMob.m_20256_(this.pathfinderMob.m_20184_().m_82520_(velocity.f_82479_, this.jumpPower, velocity.f_82481_));
        ChangedSounds.broadcastSound((Entity)this.pathfinderMob, (SoundEvent)ChangedSounds.BOW2, (float)1.0f, (float)1.0f);
        this.pathfinderMob.m_7292_(new MobEffectInstance(MobEffects.f_19591_, this.duration + 40, 10, false, false));
        this.pathfinderMob.m_21573_().m_26573_();
    }

    public boolean m_8045_() {
        return this.target != null && this.target.m_6084_() && this.tickCounter < this.duration;
    }

    public void m_8037_() {
        ++this.tickCounter;
        if (this.target != null) {
            LightningBolt lightning;
            this.pathfinderMob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            this.pathfinderMob.m_21573_().m_26573_();
            if (this.tickCounter % 10 == 0 && (lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.pathfinderMob.m_183503_())) != null) {
                lightning.m_20219_(this.target.m_20182_());
                PathfinderMob pathfinderMob = this.pathfinderMob;
                if (pathfinderMob instanceof ChangedEntity) {
                    ChangedEntity changedEntity = (ChangedEntity)pathfinderMob;
                    lightning.m_20879_((ServerPlayer)changedEntity.getUnderlyingPlayer());
                }
                lightning.setDamage(10.0f);
                ParticlesUtil.sendParticles(this.pathfinderMob.m_183503_(), (ParticleOptions)ChangedAddonParticleTypes.thunderSpark(5), lightning.m_146892_(), 0.3f, 0.3f, 0.3f, 25, 0.25f);
                this.pathfinderMob.m_21563_().m_24960_((Entity)lightning, 30.0f, 30.0f);
                DelayedTask.schedule(10, () -> {
                    this.pathfinderMob.m_183503_().m_7967_((Entity)lightning);
                    this.applyKnockBack((Entity)lightning);
                    this.pathfinderMob.m_6674_(this.pathfinderMob.m_21526_() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                    if (this.target != null) {
                        Vec3 dir = this.pathfinderMob.m_20182_().m_82505_(this.target.m_20182_()).m_82541_().m_82490_(-0.5);
                        this.pathfinderMob.m_5997_(dir.f_82479_, dir.f_82480_ * 1.25, dir.f_82481_);
                    }
                });
                this.pathfinderMob.m_7292_(new MobEffectInstance(MobEffects.f_19591_, this.duration + 40, 10, false, false));
            }
        }
    }

    public void applyKnockBack(Entity lightning) {
        List list = lightning.m_183503_().m_45971_(LivingEntity.class, TargetingConditions.f_26872_.m_26888_(target -> !target.m_7306_(lightning) && !target.m_7306_((Entity)this.pathfinderMob)), (LivingEntity)this.pathfinderMob, lightning.m_142469_().m_82400_(8.0));
        for (LivingEntity livingEntity : list) {
            livingEntity.m_5997_(0.0, 0.5, 0.0);
        }
    }

    public void m_8041_() {
        if (this.groundPos != null) {
            this.pathfinderMob.m_6021_((double)this.groundPos.m_123341_() + 0.5, (double)this.groundPos.m_123342_(), (double)this.groundPos.m_123343_() + 0.5);
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.pathfinderMob.m_183503_());
            if (lightning != null) {
                lightning.m_6027_((double)this.groundPos.m_123341_() + 0.5, (double)this.groundPos.m_123342_(), (double)this.groundPos.m_123343_() + 0.5);
                PathfinderMob pathfinderMob = this.pathfinderMob;
                if (pathfinderMob instanceof ChangedEntity) {
                    ChangedEntity changedEntity = (ChangedEntity)pathfinderMob;
                    lightning.m_20879_((ServerPlayer)changedEntity.getUnderlyingPlayer());
                }
                this.pathfinderMob.m_183503_().m_7967_((Entity)lightning);
            }
        }
        this.pathfinderMob.m_21195_(MobEffects.f_19591_);
        this.target = null;
        this.groundPos = null;
        this.cooldown = this.cooldownProvider.m_142270_(this.pathfinderMob.m_21187_());
    }
}

