/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.generic.attacks;

import java.util.Random;
import net.foxyas.changedaddon.entity.bosses.VoidFoxEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class ComboAbilityGoal
extends Goal {
    private final Mob attacker;
    private final Random random = new Random();
    private final float minRange;
    private final float maxRange;
    private final float damage;
    private final SoundEvent[] impactSound;
    private final ParticleOptions[] impactParticle;
    private LivingEntity target;
    private int phase = 0;
    private int ticks = 0;
    private int delay = 5;
    private boolean shouldEnd = false;

    public ComboAbilityGoal(Mob attacker, float minRange, float maxRange, float damage, int delay, SoundEvent[] impactSounds, ParticleOptions[] impactParticle) {
        this.attacker = attacker;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.damage = damage;
        this.delay = delay;
        this.impactSound = impactSounds;
        this.impactParticle = impactParticle;
    }

    public boolean isShouldEnd() {
        return this.shouldEnd;
    }

    public boolean m_8036_() {
        Player player;
        this.target = this.attacker.m_5448_();
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            return false;
        }
        return this.target != null && this.target.m_20096_() && this.attacker.m_20270_((Entity)this.target) >= this.minRange && this.attacker.m_20270_((Entity)this.target) <= this.maxRange && this.attacker.m_21187_().nextFloat() < 0.5f;
    }

    public boolean m_8045_() {
        Player player;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            return false;
        }
        if (this.shouldEnd) {
            return false;
        }
        return this.phase <= 22 && this.target != null && this.target.m_6084_();
    }

    public void m_8056_() {
        this.phase = 0;
        this.ticks = 0;
        this.teleportToTarget();
    }

    public void m_8037_() {
        ++this.ticks;
        if (this.ticks % this.delay == 0) {
            switch (this.phase) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.teleportAndKnockback(4.0f / (float)Math.max(1, this.phase));
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    this.teleportAndKnockbackInAir(1.0f);
                    break;
                }
                case 5: 
                case 11: 
                case 17: {
                    this.uppercut();
                    break;
                }
                case 22: {
                    this.slam();
                }
            }
            ++this.phase;
        }
    }

    public void m_8041_() {
        if (this.shouldEnd && this.phase < 22) {
            this.slam();
        }
        if (!this.attacker.m_20096_()) {
            BlockPos pos = this.attacker.m_142538_();
            int groundY = this.attacker.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
            Level world = this.attacker.f_19853_;
            if (world.m_6042_().m_63946_()) {
                int maxY;
                for (int y = maxY = world.m_141928_() - 1; y > 0; --y) {
                    BlockPos checkPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
                    if (!world.m_46859_(checkPos) || !world.m_46859_(checkPos.m_7494_())) continue;
                    groundY = y;
                    break;
                }
            }
            this.attacker.m_6021_((double)pos.m_123341_() + 0.5, (double)groundY + 0.5, (double)pos.m_123343_() + 0.5);
            this.spawnImpactEffect(this.attacker.m_20182_(), 3);
            this.spawnImpactParticleEffect(this.target.m_20182_(), 2);
        }
        this.shouldEnd = false;
    }

    private void teleportToTarget() {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.attacker.m_21391_((Entity)this.target, 1.0f, 1.0f);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.shouldEnd = true;
        }
        this.spawnImpactEffect(this.target.m_20182_(), 0);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 0);
    }

    private void removeIframesFromTarget() {
        this.target.f_19802_ = 0;
        this.target.f_20917_ = 1;
        this.target.f_20918_ = 1.0f;
        this.target.f_20916_ = 1;
    }

    private void teleportAndKnockback(float strength) {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        Vec3 knockDir = this.attacker.m_20154_().m_82490_((double)strength).m_82520_(0.0, 0.2, 0.0);
        this.target.m_20256_(knockDir);
        this.attacker.m_21391_((Entity)this.target, 1.0f, 1.0f);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage / 2.0f);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.shouldEnd = true;
        }
        this.spawnImpactEffect(this.target.m_20182_(), 0);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 0);
    }

    private void teleportAndKnockbackInAir(float strength) {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        Vec3 knockDir = this.attacker.m_20154_().m_82490_((double)strength).m_82520_(0.0, 0.2, 0.0);
        this.target.m_20256_(knockDir);
        this.attacker.m_21391_((Entity)this.target, 1.0f, 1.0f);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage / 2.0f);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.shouldEnd = true;
        }
        this.applySlowFalling(this.target);
        this.spawnImpactEffect(this.target.m_20182_(), 0);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 0);
    }

    private void uppercut() {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.target.m_20334_(0.0, 1.5, 0.0);
        this.attacker.m_21391_((Entity)this.target, 1.0f, 1.0f);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.shouldEnd = true;
        }
        this.applySlowFalling(this.target);
        this.spawnImpactEffect(this.target.m_20182_(), 1);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 1);
    }

    private void slam() {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.target.m_20334_(0.0, -2.0, 0.0);
        this.attacker.m_21391_((Entity)this.target, 1.0f, 1.0f);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.spawnImpactEffect(this.target.m_20182_(), 2);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 2);
        this.removeSlowFalling();
    }

    private void removeSlowFalling() {
        this.target.m_21195_(MobEffects.f_19591_);
        this.attacker.m_21195_(MobEffects.f_19591_);
    }

    private void applySlowFalling(LivingEntity entity) {
        MobEffectInstance slowFalling = new MobEffectInstance(MobEffects.f_19591_, 40, 0, false, false);
        entity.m_7292_(slowFalling);
        this.attacker.m_7292_(slowFalling);
    }

    private void spawnImpactEffect(Vec3 pos, int type) {
        Level level = this.attacker.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (type <= this.impactSound.length) {
                this.attacker.m_5496_(this.impactSound[type], 2.0f, 1.0f);
            }
        }
    }

    private void spawnImpactParticleEffect(Vec3 pos, int type) {
        Level level = this.attacker.f_19853_;
        if (level instanceof ServerLevel) {
            VoidFoxEntity voidFoxEntity;
            Mob mob;
            ServerLevel serverLevel = (ServerLevel)level;
            if (type <= this.impactParticle.length) {
                serverLevel.m_8767_(this.impactParticle[type], pos.f_82479_, pos.f_82480_, pos.f_82481_, 3, 0.0, 0.0, 0.0, 0.0);
            }
            if (type != 1 && type != 2 && (mob = this.attacker) instanceof VoidFoxEntity && (voidFoxEntity = (VoidFoxEntity)mob).m_21205_().m_41619_()) {
                voidFoxEntity.doClawsAttackEffect();
            }
        }
    }
}

