/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.generic.attacks;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DashPunchGoal
extends Goal {
    private final Mob mob;
    private Phase phase = Phase.IDLE;
    private int chargeTicks = 0;
    private int dashTicks = 0;
    private int cooldown = 0;
    private LivingEntity target;

    public DashPunchGoal(Mob mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.target = this.mob.m_5448_();
        return this.target != null && this.target.m_6084_() && this.mob.m_20270_((Entity)this.target) < 16.0f && this.mob.m_20096_();
    }

    public void m_8056_() {
        this.phase = Phase.CHARGING;
        this.chargeTicks = 0;
        this.dashTicks = 0;
        this.mob.m_21573_().m_26573_();
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        this.mob.m_183503_().m_5594_(null, this.mob.m_142538_(), SoundEvents.f_12314_, SoundSource.HOSTILE, 1.0f, 1.0f);
        Level level = this.mob.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (LivingEntity living : this.mob.m_183503_().m_6443_(LivingEntity.class, this.mob.m_142469_().m_82400_(8.0), livingEntity -> !livingEntity.m_5833_() && !livingEntity.m_7306_((Entity)this.mob))) {
            Vec3 knock = living.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_().m_82490_(1.2);
            living.m_5997_(knock.f_82479_, knock.f_82480_ * 1.25, knock.f_82481_);
        }
    }

    public void m_8037_() {
        if (this.target == null || !this.target.m_6084_()) {
            this.m_8041_();
            return;
        }
        switch (this.phase) {
            case CHARGING: {
                this.handleCharging();
                break;
            }
            case DASHING: {
                this.handleDashing();
                break;
            }
        }
    }

    private void handleCharging() {
        ++this.chargeTicks;
        this.mob.m_21573_().m_26573_();
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        Level level = this.mob.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123811_, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
        }
        if (this.chargeTicks >= 40) {
            this.beginDash();
        }
    }

    private void beginDash() {
        this.phase = Phase.DASHING;
        this.dashTicks = 0;
        this.mob.m_21573_().m_26573_();
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        this.mob.m_183503_().m_5594_(null, this.mob.m_142538_(), SoundEvents.f_144167_, SoundSource.HOSTILE, 1.0f, 0.9f);
    }

    private void handleDashing() {
        ++this.dashTicks;
        this.mob.m_21563_().m_148051_((Entity)this.target);
        Vec3 direction = this.mob.m_20184_().m_82549_(this.target.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_().m_82490_(0.6));
        this.mob.m_20334_(direction.f_82479_, direction.f_82480_, direction.f_82481_);
        this.mob.f_19864_ = true;
        if ((double)this.mob.m_20270_((Entity)this.target) < 2.5) {
            this.applyImpact();
            this.m_8041_();
        }
        if (this.dashTicks > 25) {
            this.m_8041_();
        }
    }

    private void applyImpact() {
        Level level = this.mob.m_183503_();
        Vec3 reverse = this.mob.m_20182_().m_82546_(this.target.m_20182_()).m_82541_().m_82490_(2.0);
        this.mob.m_20334_(reverse.f_82479_, reverse.f_82480_ * 1.25, reverse.f_82481_);
        this.mob.f_19864_ = true;
        this.mob.f_19812_ = true;
        Vec3 knock = this.target.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_().m_82490_(2.0);
        this.target.m_5997_(knock.f_82479_, knock.f_82480_ * 1.25, knock.f_82481_);
        this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 6.0f);
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
        }
        level.m_5594_(null, this.mob.m_142538_(), SoundEvents.f_12316_, SoundSource.HOSTILE, 1.5f, 0.8f);
        level.m_5594_(null, this.mob.m_142538_(), SoundEvents.f_12314_, SoundSource.HOSTILE, 1.5f, 0.8f);
    }

    public boolean m_8045_() {
        Player player;
        LivingEntity livingEntity;
        if (this.target.m_5833_() || this.target.m_20147_() || (livingEntity = this.target) instanceof Player && (player = (Player)livingEntity).m_7500_()) {
            return false;
        }
        return this.phase != Phase.IDLE;
    }

    public void m_8041_() {
        this.phase = Phase.IDLE;
        this.cooldown = 40;
        this.chargeTicks = 0;
        this.dashTicks = 0;
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    private static enum Phase {
        IDLE,
        CHARGING,
        DASHING;

    }
}

