/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.generic.attacks;

import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class KnockBackBurstGoal
extends Goal {
    private final Mob mob;
    private final double damageThreshold;
    private final int checkInterval = 20;
    private final float knockbackForce = 2.5f;
    private final int cooldown = 100;
    private int ticks;
    private float recentDamage;
    private int recentHits;
    private int cooldownTimer;

    public KnockBackBurstGoal(Mob mob, double damageThreshold) {
        this.mob = mob;
        this.damageThreshold = damageThreshold;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
            return false;
        }
        ++this.ticks;
        if (this.ticks >= 20) {
            this.ticks = 0;
            this.recentDamage = 0.0f;
            this.recentHits = 0;
            if ((double)this.recentDamage >= this.damageThreshold && this.recentHits <= 1) {
                this.recentDamage = 0.0f;
                this.recentHits = 0;
                return true;
            }
        }
        return false;
    }

    public void m_8056_() {
        this.recentDamage = 0.0f;
        this.recentHits = 0;
        Level level = this.mob.m_183503_();
        AABB area = this.mob.m_142469_().m_82400_(4.0);
        List players = level.m_6443_(LivingEntity.class, area, livingEntity -> livingEntity != this.mob);
        for (LivingEntity livingEntity2 : players) {
            if (!livingEntity2.m_6084_()) continue;
            double dx = livingEntity2.m_20185_() - this.mob.m_20185_();
            double dz = livingEntity2.m_20189_() - this.mob.m_20189_();
            double dist = Math.max(0.1, Math.sqrt(dx * dx + dz * dz));
            livingEntity2.m_5997_(dx / dist * 2.5, 0.5, dz / dist * 2.5);
            livingEntity2.f_19864_ = true;
            livingEntity2.m_183503_().m_6269_(null, (Entity)this.mob, SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
            if (!(livingEntity2 instanceof Player)) continue;
            Player player = (Player)livingEntity2;
            player.m_5661_((Component)new TextComponent("That's ENOUGH").m_130938_(style -> {
                Style newStyle = style;
                Color color = new Color(0, 0, 0);
                newStyle = newStyle.m_178520_(color.getRGB()).m_131136_(Boolean.valueOf(true)).m_131155_(Boolean.valueOf(true));
                return newStyle;
            }), true);
        }
        this.cooldownTimer = 100;
    }

    public boolean m_183429_() {
        return true;
    }

    public void registerDamage(float amount) {
        this.recentDamage += amount;
    }

    public void registerHit() {
        ++this.recentHits;
    }
}

