/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.generic.attacks;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LeapSmashGoal
extends Goal {
    private final Mob mob;
    public int cooldown;
    private LivingEntity target;
    private int leapTicks;
    private boolean wasInAir;

    public LeapSmashGoal(Mob mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (this.target == null || !this.target.m_6084_()) {
            return false;
        }
        if (!this.mob.m_20096_()) {
            return false;
        }
        return this.mob.m_20270_((Entity)this.target) >= 3.0f;
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        this.leapTicks = 0;
        this.wasInAir = false;
        Vec3 dir = this.target.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_();
        double horizontalBoost = 1.5;
        double verticalBoost = 1.5;
        this.mob.m_20334_(dir.f_82479_ * horizontalBoost, verticalBoost, dir.f_82481_ * horizontalBoost);
        this.mob.m_21573_().m_26573_();
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        this.mob.m_183503_().m_5594_(null, this.mob.m_142538_(), SoundEvents.f_144167_, SoundSource.HOSTILE, 1.0f, 0.9f);
        this.mob.m_183503_().m_7605_((Entity)this.mob, (byte)4);
        this.mob.m_21569_().m_24901_();
    }

    public void m_8037_() {
        ++this.leapTicks;
        if (this.mob.m_20096_() && this.wasInAir) {
            this.performSmash();
            this.m_8041_();
        }
        if (!this.mob.m_20096_()) {
            this.wasInAir = true;
            this.mob.m_21573_().m_26573_();
            if (this.leapTicks >= 40) {
                Vec3 motion = this.mob.m_20184_();
                double verticalBoost = -0.5;
                this.mob.m_21563_().m_24950_(motion.f_82479_, verticalBoost, motion.f_82481_, 30.0f, 30.0f);
                this.mob.m_20334_(motion.f_82479_, verticalBoost, motion.f_82481_);
            }
        }
    }

    private void performSmash() {
        BlockPos pos2;
        BlockPos center = this.mob.m_142538_();
        int radius = 4;
        for (BlockPos pos2 : BlockPos.m_121921_((AABB)new AABB(center.m_7495_()).m_82377_((double)radius, 0.0, (double)radius)).toList()) {
            double dz;
            double dy;
            double dx = (double)(center.m_123341_() - pos2.m_123341_()) / (double)radius;
            double distanceSq = dx * dx + (dy = (double)(center.m_123342_() - pos2.m_123342_())) * dy + (dz = (double)(center.m_123343_() - pos2.m_123343_()) / (double)radius) * dz;
            if (!(distanceSq <= (double)(radius * radius))) continue;
            BlockState blockState = this.mob.f_19853_.m_8055_(pos2);
            this.mob.f_19853_.m_46796_(2001, pos2, Block.m_49956_((BlockState)blockState));
            Level level = this.mob.m_183503_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            int breakerId = this.mob.m_142049_();
            int stage = 5;
            serverLevel.m_6801_(breakerId, pos2, stage);
        }
        pos2 = this.mob.m_183503_();
        if (pos2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pos2;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), 1, 0.0, 0.0, 0.0, 1.0);
        }
        AABB smashArea = this.mob.m_142469_().m_82400_(4.0);
        List hitEntities = this.mob.m_183503_().m_6443_(LivingEntity.class, smashArea, e -> e != this.mob && e.m_6084_());
        for (LivingEntity entity : hitEntities) {
            if (!entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 4.0f)) continue;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 0));
            Vec3 knockback = entity.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_().m_82490_(1.2);
            entity.m_5997_(knockback.f_82479_, 0.5, knockback.f_82481_);
        }
        this.mob.m_183503_().m_5594_(null, this.mob.m_142538_(), SoundEvents.f_12316_, SoundSource.HOSTILE, 1.5f, 0.8f);
    }

    public boolean m_8045_() {
        return this.leapTicks < 60 && !this.mob.m_20096_();
    }

    public void m_8041_() {
        this.leapTicks = 0;
        this.wasInAir = false;
        this.cooldown = 40;
    }
}

