/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.generic.attacks;

import java.util.EnumSet;
import net.foxyas.changedaddon.entity.projectile.VoidFoxParticleProjectile;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ProjectileAttackGoal
extends Goal {
    private final Mob mob;
    private final EntityType<? extends VoidFoxParticleProjectile> projectileType;
    private final int attackCooldownMax = 60;
    private final int prepareDelayMax = 20;
    private int attackCooldown = 0;
    private int prepareDelay = 0;

    public ProjectileAttackGoal(Mob mob, EntityType<? extends VoidFoxParticleProjectile> projectileType) {
        this.mob = mob;
        this.projectileType = projectileType;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        return target != null && target.m_6084_() && target.m_20270_((Entity)this.mob) >= 2.5f;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        this.prepareDelay = 20;
    }

    public void m_8041_() {
        this.prepareDelay = 0;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
            Level level = this.mob.m_183503_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_(), 4, 0.25, 0.5, 0.25, 0.5);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_(), 4, 0.25, 0.5, 0.25, (double)0.05f);
            }
            return;
        }
        if (this.prepareDelay > 0) {
            --this.prepareDelay;
            return;
        }
        this.shootProjectile(target);
        this.attackCooldown = 60;
        this.prepareDelay = 20;
    }

    private void shootProjectile(LivingEntity target) {
        Level level = this.mob.f_19853_;
        if (!level.f_46443_) {
            this.spawnProjectilesInCircle((LivingEntity)this.mob, target, new Vec3(0.0, 0.5, 0.0), 2.0, 8);
        }
    }

    public void spawnProjectilesInCircle(LivingEntity entity, LivingEntity target, Vec3 offset, double radius, int count) {
        Vec3 center = entity.m_146892_().m_82549_(offset);
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)count;
            Vec3 dir = new Vec3(1.0, 0.0, 0.0).m_82535_((float)angle).m_82524_((float)Math.toRadians(-target.m_146908_())).m_82541_();
            Vec3 spawnPos = center.m_82549_(dir.m_82490_(radius));
            VoidFoxParticleProjectile projectile = new VoidFoxParticleProjectile(this.projectileType, (LivingEntity)this.mob, this.mob.m_183503_(), target);
            projectile.m_146884_(spawnPos);
            projectile.m_20242_(true);
            projectile.m_5602_((Entity)this.mob);
            Vec3 direction = target.m_20299_(1.0f).m_82546_(this.mob.m_20299_(0.5f)).m_82541_();
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 0.0f);
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            entity.f_19853_.m_7967_((Entity)projectile);
        }
    }
}

