/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.generic.attacks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class SimpleAntiFlyingAttack
extends Goal {
    private final Mob attacker;
    private final int delay;
    private final IntProvider cooldownProvider;
    public int cooldown;
    private final float minRange;
    private final float maxRange;
    private final float damage;
    private LivingEntity target;
    private int ticks = 0;

    public SimpleAntiFlyingAttack(Mob attacker, IntProvider cooldownProvider, float minRange, float maxRange, float damage, int delay) {
        this.attacker = attacker;
        this.cooldownProvider = cooldownProvider;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.damage = damage;
        this.delay = delay;
    }

    public Mob getAttacker() {
        return this.attacker;
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public boolean m_8036_() {
        this.target = this.attacker.m_5448_();
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_7500_() || player.m_5833_()) {
                return false;
            }
            return player.m_150110_().f_35935_ && this.attacker.m_20270_((Entity)player) <= this.maxRange;
        }
        return this.target != null && !this.target.m_20096_() && this.attacker.m_20270_((Entity)this.target) >= this.minRange && this.attacker.m_20270_((Entity)this.target) <= this.maxRange;
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_7500_() || player.m_5833_()) {
                return false;
            }
            return player.m_6084_() && !player.m_20096_();
        }
        return this.target != null && this.target.m_6084_() && !this.target.m_20096_();
    }

    public void m_8056_() {
    }

    public boolean m_183429_() {
        return true;
    }

    protected int m_183277_(int delay) {
        return super.m_183277_(delay);
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        ++this.ticks;
        if (this.ticks % this.delay == 0) {
            Player player;
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).m_6084_() && !player.m_20096_() && player.m_150110_().f_35935_) {
                if (this.attacker.m_20270_((Entity)this.target) <= 2.0f && this.attacker.m_20096_()) {
                    this.slam();
                }
            } else {
                Player player2;
                livingEntity = this.target;
                if (livingEntity instanceof Player && (player2 = (Player)livingEntity).m_6084_() && !player2.m_20096_() && player2.m_21255_() && this.attacker.m_20096_()) {
                    this.slam();
                }
            }
            if (!this.target.m_20096_() && this.attacker.m_20096_()) {
                this.slam();
            }
        } else {
            this.attacker.m_21573_().m_26573_();
            this.attacker.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            Level player2 = this.attacker.m_183503_();
            if (player2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)player2;
                BlockState ground = this.attacker.m_146900_();
                BlockParticleOption dust = new BlockParticleOption(ParticleTypes.f_123794_, ground);
                for (int i = 0; i < 6; ++i) {
                    double x = this.attacker.m_20185_() + (this.attacker.m_21187_().nextDouble() - 0.5) * 0.6;
                    double y = this.attacker.m_20186_();
                    double z = this.attacker.m_20189_() + (this.attacker.m_21187_().nextDouble() - 0.5) * 0.6;
                    double motionX = (this.attacker.m_21187_().nextDouble() - 0.5) * 0.1;
                    double motionY = this.attacker.m_21187_().nextDouble() * 0.1 + 0.05;
                    double motionZ = (this.attacker.m_21187_().nextDouble() - 0.5) * 0.1;
                    serverLevel.m_8767_((ParticleOptions)dust, x, y, z, 1, motionX, motionY, motionZ, 0.0);
                }
            }
        }
    }

    public void m_8041_() {
        if (!this.attacker.m_20096_()) {
            BlockPos pos = this.attacker.m_142538_();
            int groundY = this.attacker.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
            Level world = this.attacker.f_19853_;
            if (world.m_6042_().m_63946_()) {
                int maxY;
                for (int y = maxY = world.m_141928_() - 1; y > 0; --y) {
                    BlockPos checkPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
                    if (!world.m_46859_(checkPos) || !world.m_46859_(checkPos.m_7494_())) continue;
                    groundY = y;
                    break;
                }
            }
            this.attacker.m_6021_((double)pos.m_123341_() + 0.5, (double)groundY + 0.5, (double)pos.m_123343_() + 0.5);
            this.spawnImpactSoundEffect();
            this.spawnImpactParticleEffect(this.target.m_20182_());
        }
        this.ticks = 0;
        this.cooldown = this.cooldownProvider.m_142270_(this.attacker.m_21187_());
    }

    private void removeIframesFromTarget() {
        this.target.f_19802_ = 0;
        this.target.f_20917_ = 1;
        this.target.f_20918_ = 1.0f;
        this.target.f_20916_ = 1;
    }

    private void teleportAndKnockbackInAir(float strength) {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        Vec3 knockDir = this.attacker.m_20154_().m_82490_((double)strength).m_82520_(0.0, 0.2, 0.0);
        this.target.m_20256_(knockDir);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage / 2.0f);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.applySlowFalling(this.target);
        this.spawnImpactSoundEffect();
        this.spawnImpactParticleEffect(this.target.m_20182_());
    }

    private void slam() {
        if (this.target == null) {
            return;
        }
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_150110_().f_35935_) {
                player.m_150110_().f_35935_ = false;
                player.m_6885_();
            }
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.target.m_20334_(0.0, -8.0, 0.0);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.spawnImpactSoundEffect();
        this.spawnImpactParticleEffect(this.target.m_20182_());
        this.removeSlowFalling();
    }

    private void removeSlowFalling() {
        this.target.m_21195_(MobEffects.f_19591_);
        this.attacker.m_21195_(MobEffects.f_19591_);
    }

    private void applySlowFalling(LivingEntity entity) {
        MobEffectInstance slowFalling = new MobEffectInstance(MobEffects.f_19591_, 40, 0, false, false);
        entity.m_7292_(slowFalling);
        this.attacker.m_7292_(slowFalling);
    }

    private void spawnImpactSoundEffect() {
        Level level = this.attacker.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.attacker.m_5496_(SoundEvents.f_12313_, 2.0f, 1.0f);
        }
    }

    private void spawnImpactParticleEffect(Vec3 pos) {
        Level level = this.attacker.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 3, 0.0, 0.0, 0.0, 0.0);
            this.doClawsAttackEffect((LivingEntity)this.attacker);
        }
    }

    public void doClawsAttackEffect(LivingEntity livingEntity) {
        double d0 = (double)(-Mth.m_14031_((float)(livingEntity.m_146908_() * ((float)Math.PI / 180)))) * 1.0;
        double d1 = (double)Mth.m_14089_((float)(livingEntity.m_146908_() * ((float)Math.PI / 180))) * 1.0;
        Level level = livingEntity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, livingEntity.m_20185_() + d0, livingEntity.m_20227_(0.5), livingEntity.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, livingEntity.m_20185_() + d0, livingEntity.m_20227_(0.6), livingEntity.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, livingEntity.m_20185_() + d0, livingEntity.m_20227_(0.7), livingEntity.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            livingEntity.f_19853_.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 0.75f);
        }
    }
}

