/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.phantom;

import java.util.List;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.foxyas.changedaddon.mixins.entity.PhantomAccessor;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AvoidCatlikeOrCatGoal
extends Goal {
    private final Phantom phantom;
    private int nextSearchTick;

    public AvoidCatlikeOrCatGoal(Phantom phantom) {
        this.phantom = phantom;
    }

    public boolean m_8036_() {
        Player player;
        LivingEntity target = this.phantom.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (target instanceof Player && this.isCatlike((LivingEntity)(player = (Player)target))) {
            this.hiss((LivingEntity)player);
            return true;
        }
        return this.isCatlike(target) || this.haveCatLikeNearby();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        this.phantom.m_6710_(null);
        Phantom phantom = this.phantom;
        if (phantom instanceof PhantomAccessor) {
            PhantomAccessor accessor = (PhantomAccessor)phantom;
            accessor.setAttackPhase(Phantom.AttackPhase.CIRCLE);
        }
    }

    public void hiss(@NotNull LivingEntity cat) {
        Level level = cat.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6263_(null, cat.m_20185_(), cat.m_20188_(), cat.m_20189_(), SoundEvents.f_11789_, SoundSource.AMBIENT, 1.0f, 1.0f);
        } else {
            cat.m_183503_().m_7785_(cat.m_20185_(), cat.m_20188_(), cat.m_20189_(), SoundEvents.f_11789_, SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
    }

    private boolean isCatlike(LivingEntity entity) {
        ChangedEntity changed;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return ProcessTransfur.getPlayerTransfurVariantSafe((Player)player).map(v -> v.getParent().is(ChangedAddonTags.TransfurTypes.CAT_LIKE) || v.getParent().is(ChangedAddonTags.TransfurTypes.LEOPARD_LIKE)).orElse(false);
        }
        if (entity instanceof ChangedEntity && (changed = (ChangedEntity)entity).getSelfVariant() != null) {
            return changed.getSelfVariant().is(ChangedAddonTags.TransfurTypes.CAT_LIKE) || changed.getSelfVariant().is(ChangedAddonTags.TransfurTypes.LEOPARD_LIKE);
        }
        return false;
    }

    private boolean haveCatLikeNearby() {
        if (this.phantom.f_19797_ < this.nextSearchTick) {
            return false;
        }
        this.nextSearchTick = this.phantom.f_19797_ + 20;
        List catLikeNearby = this.phantom.f_19853_.m_6443_(LivingEntity.class, this.phantom.m_142469_().m_82400_(32.0), livingEntity -> EntitySelector.f_20403_.test(livingEntity) && this.isCatlike((LivingEntity)livingEntity));
        catLikeNearby.forEach(this::hiss);
        return !catLikeNearby.isEmpty();
    }
}

