/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.prototype;

import java.util.EnumSet;
import net.foxyas.changedaddon.entity.advanced.PrototypeEntity;
import net.foxyas.changedaddon.init.ChangedAddonSoundEvents;
import net.ltxprogrammer.changed.entity.Emote;
import net.ltxprogrammer.changed.init.ChangedParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class PlantSeedsGoal
extends Goal {
    private static final int searchRange = 6;
    private final PrototypeEntity entity;
    private final PathNavigation navigation;
    private BlockPos targetPos;

    public PlantSeedsGoal(PrototypeEntity entity) {
        this.entity = entity;
        this.navigation = entity.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_8036_() {
        ItemStack seeds = this.findSeeds();
        if (seeds.m_41619_()) {
            return false;
        }
        this.targetPos = this.findPlantableFarmland(this.entity.m_183503_(), this.entity.m_142538_(), 6);
        return this.targetPos != null;
    }

    public void m_8056_() {
        if (this.targetPos == null) {
            return;
        }
        this.entity.m_183503_().m_5594_(null, this.entity.m_142538_(), ChangedAddonSoundEvents.PROTOTYPE_IDEA, SoundSource.MASTER, 1.0f, 1.0f);
        if (this.entity.m_183503_().f_46443_) {
            this.entity.m_183503_().m_7106_((ParticleOptions)ChangedParticles.emote((Entity)this.entity, (Emote)Emote.IDEA), this.entity.m_20185_(), this.entity.m_20186_() + (double)this.entity.m_6972_((Pose)this.entity.m_20089_()).f_20378_ + 0.65, this.entity.m_20189_(), 0.0, 0.0, 0.0);
        }
        this.navigation.m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5, 0.25);
    }

    public void m_8037_() {
        if (this.targetPos == null) {
            return;
        }
        if (this.entity.m_142538_().m_123314_((Vec3i)this.targetPos, 3.0)) {
            this.plantSeedAt(this.targetPos);
            this.targetPos = null;
            return;
        }
        this.navigation.m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5, 0.25);
        this.entity.m_21563_().m_24950_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), 30.0f, 30.0f);
        this.navigation.m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5, 0.25);
    }

    public void m_8041_() {
        super.m_8041_();
    }

    private ItemStack findSeeds() {
        ItemStack seeds = this.entity.m_6844_(EquipmentSlot.MAINHAND);
        if (this.isSeed(seeds)) {
            return seeds;
        }
        seeds = this.entity.m_6844_(EquipmentSlot.OFFHAND);
        if (this.isSeed(seeds)) {
            return seeds;
        }
        for (int i = 0; i < this.entity.getInventory().m_6643_(); ++i) {
            seeds = this.entity.getInventory().m_8020_(i);
            if (!this.isSeed(seeds)) continue;
            return seeds;
        }
        return ItemStack.f_41583_;
    }

    private boolean isSeed(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.m_40614_();
        return block instanceof CropBlock;
    }

    private BlockPos findPlantableFarmland(Level level, BlockPos center, int range) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_142082_(-range, -1, -range), (BlockPos)center.m_142082_(range, 1, range))) {
            BlockState soil = level.m_8055_(pos);
            BlockState above = level.m_8055_(pos.m_7494_());
            if (soil.m_60734_() != Blocks.f_50093_ || !above.m_60795_()) continue;
            return pos.m_7494_();
        }
        return null;
    }

    private void plantSeedAt(BlockPos pos) {
        Level level = this.entity.m_183503_();
        if (level.f_46443_) {
            return;
        }
        ItemStack seeds = this.findSeeds();
        if (seeds.m_41619_()) {
            return;
        }
        this.entity.m_21563_().m_24950_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 30.0f, 30.0f);
        this.entity.m_6674_(this.entity.m_21526_() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        Block block = ((BlockItem)seeds.m_41720_()).m_40614_();
        level.m_7731_(pos, block.m_49966_(), 3);
        level.m_5594_(null, pos, block.m_49966_().m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
        seeds.m_41774_(1);
    }
}

