/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.ltxprogrammer.changed.entity.Emote;
import net.ltxprogrammer.changed.entity.TamableLatexEntity;
import net.ltxprogrammer.changed.init.ChangedParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class SleepingWithOwnerGoal
extends Goal {
    private static final double MAX_DISTANCE_SQ = 32.0;
    private final LivingEntity pet;
    private final boolean isDogOrCat;
    private Player owner;
    private BlockPos bedPos;
    private int sleepTimer = 0;

    public SleepingWithOwnerGoal(LivingEntity pet, boolean isDogOrCat) {
        this.pet = pet;
        this.isDogOrCat = isDogOrCat;
    }

    public SleepingWithOwnerGoal(LivingEntity pet) {
        this.pet = pet;
        this.isDogOrCat = false;
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.pet;
        if (!(livingEntity instanceof TamableLatexEntity)) {
            return false;
        }
        TamableLatexEntity tamablePet = (TamableLatexEntity)livingEntity;
        if (!tamablePet.isTame() || this.pet.m_20069_() || this.pet.m_20160_()) {
            return false;
        }
        Entity ownerEntity = tamablePet.m_142480_();
        if (!(ownerEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)ownerEntity;
        if (player.m_5803_()) {
            this.owner = player;
            this.bedPos = player.m_21257_().orElse(null);
            if (this.bedPos == null) {
                return false;
            }
            if (this.pet.m_20275_((double)this.bedPos.m_123341_() + 0.5, (double)this.bedPos.m_123342_(), (double)this.bedPos.m_123343_() + 0.5) > 32.0) {
                return false;
            }
            return !this.pet.m_5803_();
        }
        return false;
    }

    public void m_8056_() {
        LivingEntity livingEntity;
        if (this.bedPos != null && (livingEntity = this.pet) instanceof PathfinderMob) {
            PathfinderMob pathfinderPet = (PathfinderMob)livingEntity;
            if (this.owner.m_183503_().m_5776_()) {
                this.owner.m_183503_().m_7106_((ParticleOptions)ChangedParticles.emote((Entity)this.pet, (Emote)Emote.IDEA), this.pet.m_20185_(), this.pet.m_20186_() + (double)this.pet.m_6972_((Pose)this.pet.m_20089_()).f_20378_ + 0.65, this.pet.m_20189_(), 0.0, 0.0, 0.0);
            }
            pathfinderPet.m_21573_().m_26519_((double)this.bedPos.m_123341_() + 0.5, (double)this.bedPos.m_123342_(), (double)this.bedPos.m_123343_() + 0.5, 0.7);
            if (!this.isDogOrCat) {
                this.pet.m_5496_(SoundEvents.f_11793_, 1.0f, 1.0f);
            }
        }
    }

    public boolean m_8045_() {
        return this.owner != null && this.owner.m_5803_();
    }

    public void m_8037_() {
        if (this.bedPos != null) {
            LivingEntity livingEntity;
            double distanceToBed = this.pet.m_20275_((double)this.bedPos.m_123341_() + 0.5, (double)this.bedPos.m_123342_(), (double)this.bedPos.m_123343_() + 0.5);
            if (distanceToBed >= 1.5 && (livingEntity = this.pet) instanceof PathfinderMob) {
                PathfinderMob pathfinderPet = (PathfinderMob)livingEntity;
                pathfinderPet.m_21573_().m_26519_((double)this.bedPos.m_123341_() + 0.5, (double)this.bedPos.m_123342_(), (double)this.bedPos.m_123343_() + 0.5, 0.3);
            } else {
                ++this.sleepTimer;
                if (this.sleepTimer >= 10) {
                    LivingEntity livingEntity2;
                    if (!this.pet.m_5803_()) {
                        if (this.owner.m_183503_().m_5776_()) {
                            this.owner.m_183503_().m_7106_((ParticleOptions)ChangedParticles.emote((Entity)this.pet, (Emote)Emote.HEART), this.pet.m_20185_(), this.pet.m_20186_() + (double)this.pet.m_6972_((Pose)this.pet.m_20089_()).f_20378_ + 0.65, this.pet.m_20189_(), 0.0, 0.0, 0.0);
                        }
                        this.pet.m_5802_(this.bedPos);
                    }
                    if ((livingEntity2 = this.pet) instanceof PathfinderMob) {
                        PathfinderMob pathfinderPet = (PathfinderMob)livingEntity2;
                        pathfinderPet.m_21573_().m_26573_();
                    }
                    if (this.bedPos.m_203193_((Position)this.pet.m_20182_()) >= 1.25) {
                        this.pet.m_6034_((double)((float)this.bedPos.m_123341_() + 0.5f), (double)((float)this.bedPos.m_123342_() + 0.9f), (double)((float)this.bedPos.m_123343_() + 0.5f));
                    }
                }
            }
        }
    }

    public void m_8041_() {
        if (this.pet.m_5803_()) {
            this.pet.m_5796_();
        }
        this.owner = null;
        this.bedPos = null;
        this.sleepTimer = 0;
    }

    public static class BipedSleepGoal
    extends Goal {
        private static final int BED_SEARCH_RADIUS = 5;
        private static final double MAX_DISTANCE_SQ = 32.0;
        private final LivingEntity pet;
        private final boolean isDogOrCat;
        private final BedSearchType bedSearchType;
        private Player owner;
        private BlockPos bedPos;
        private int sleepTimer = 0;

        public BipedSleepGoal(LivingEntity pet) {
            this.pet = pet;
            this.isDogOrCat = false;
            this.bedSearchType = BedSearchType.NEAREST;
        }

        public BipedSleepGoal(LivingEntity pet, boolean isDogOrCat) {
            this.pet = pet;
            this.isDogOrCat = isDogOrCat;
            this.bedSearchType = BedSearchType.NEAREST;
        }

        public BipedSleepGoal(LivingEntity pet, boolean isDogOrCat, BedSearchType bedSearchType) {
            this.pet = pet;
            this.isDogOrCat = isDogOrCat;
            this.bedSearchType = bedSearchType;
        }

        public BipedSleepGoal(LivingEntity pet, boolean isDogOrCat, Random PersonalityBased) {
            this.pet = pet;
            this.isDogOrCat = isDogOrCat;
            this.bedSearchType = BipedSleepGoal.selectRandom(PersonalityBased);
        }

        private static BedSearchType selectRandom(Random random) {
            int value = random.nextInt(3);
            if (value == 0) {
                return BedSearchType.NEAREST;
            }
            if (value == 1) {
                return BedSearchType.FURTHER;
            }
            return new BedSearchType(random.nextDouble(11.0), 10.0);
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.pet;
            if (!(livingEntity instanceof TamableLatexEntity)) {
                return false;
            }
            TamableLatexEntity tamablePet = (TamableLatexEntity)livingEntity;
            if (!tamablePet.isTame() || this.pet.m_20069_() || this.pet.m_20160_()) {
                return false;
            }
            Entity ownerEntity = tamablePet.m_142480_();
            if (!(ownerEntity instanceof Player)) {
                return false;
            }
            Player player = (Player)ownerEntity;
            if (player.m_5803_()) {
                this.owner = player;
                this.bedPos = this.bedSearchType == BedSearchType.NEAREST ? this.getNearestBedFromList(this.findBedsNearOwner(player)) : (this.bedSearchType == BedSearchType.FURTHER ? this.getFurtherAwayBedFromList(this.findBedsNearOwner(player)) : (BlockPos)this.getBestBed(this.findBedsNearOwner(player), this.bedSearchType.getMinScale(), this.bedSearchType.getMaxScale()).orElse(null));
                if (this.bedPos == null) {
                    return false;
                }
                if (this.pet.m_20275_((double)this.bedPos.m_123341_() + 0.5, (double)this.bedPos.m_123342_(), (double)this.bedPos.m_123343_() + 0.5) > 32.0) {
                    return false;
                }
                return !this.pet.m_5803_();
            }
            return false;
        }

        public void m_8056_() {
            LivingEntity livingEntity;
            if (this.bedPos != null && (livingEntity = this.pet) instanceof PathfinderMob) {
                PathfinderMob pathfinderPet = (PathfinderMob)livingEntity;
                if (this.owner.m_183503_().m_5776_()) {
                    this.owner.m_183503_().m_7106_((ParticleOptions)ChangedParticles.emote((Entity)this.pet, (Emote)Emote.IDEA), this.pet.m_20185_(), this.pet.m_20186_() + (double)this.pet.m_6972_((Pose)this.pet.m_20089_()).f_20378_ + 0.65, this.pet.m_20189_(), 0.0, 0.0, 0.0);
                }
                pathfinderPet.m_21573_().m_26519_((double)this.bedPos.m_123341_() + 0.5, (double)this.bedPos.m_123342_(), (double)this.bedPos.m_123343_() + 0.5, 0.7);
                if (!this.isDogOrCat) {
                    this.pet.m_5496_(SoundEvents.f_11793_, 1.0f, 1.0f);
                }
            }
        }

        public boolean m_8045_() {
            return this.owner != null && this.owner.m_5803_();
        }

        public void m_8037_() {
            if (this.pet.m_5803_()) {
                LivingEntity livingEntity;
                if (this.bedPos != null && this.bedPos.m_203193_((Position)this.pet.m_20182_()) >= 1.25) {
                    this.pet.m_6034_((double)((float)this.bedPos.m_123341_() + 0.5f), (double)((float)this.bedPos.m_123342_() + 0.9f), (double)((float)this.bedPos.m_123343_() + 0.5f));
                }
                if ((livingEntity = this.pet) instanceof PathfinderMob) {
                    PathfinderMob pathfinderPet = (PathfinderMob)livingEntity;
                    pathfinderPet.m_21573_().m_26573_();
                }
                return;
            }
            if (this.bedPos != null) {
                LivingEntity livingEntity;
                BlockState bedState = this.pet.f_19853_.m_8055_(this.bedPos);
                if (!(bedState.m_60734_() instanceof BedBlock) || ((Boolean)bedState.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
                    this.bedPos = null;
                    this.sleepTimer = 0;
                    return;
                }
                double distanceToBed = this.pet.m_20275_((double)this.bedPos.m_123341_() + 0.5, (double)this.bedPos.m_123342_(), (double)this.bedPos.m_123343_() + 0.5);
                if (distanceToBed >= 1.5 && (livingEntity = this.pet) instanceof PathfinderMob) {
                    PathfinderMob pathfinderPet = (PathfinderMob)livingEntity;
                    pathfinderPet.m_21573_().m_26519_((double)this.bedPos.m_123341_() + 0.5, (double)this.bedPos.m_123342_(), (double)this.bedPos.m_123343_() + 0.5, 0.3);
                } else {
                    ++this.sleepTimer;
                    if (this.sleepTimer >= 10) {
                        if (!((Boolean)bedState.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
                            this.pet.m_5802_(this.bedPos);
                            if (this.owner.m_183503_().m_5776_()) {
                                this.owner.m_183503_().m_7106_((ParticleOptions)ChangedParticles.emote((Entity)this.pet, (Emote)Emote.HEART), this.pet.m_20185_(), this.pet.m_20186_() + (double)this.pet.m_6972_((Pose)this.pet.m_20089_()).f_20378_ + 0.65, this.pet.m_20189_(), 0.0, 0.0, 0.0);
                            }
                            this.pet.f_19853_.m_46597_(this.bedPos, (BlockState)bedState.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(true)));
                            LivingEntity livingEntity2 = this.pet;
                            if (livingEntity2 instanceof PathfinderMob) {
                                PathfinderMob pathfinderPet = (PathfinderMob)livingEntity2;
                                pathfinderPet.m_21573_().m_26573_();
                            }
                        } else {
                            this.bedPos = null;
                            this.sleepTimer = 0;
                        }
                    }
                }
            }
            if (this.bedPos == null) {
                this.bedPos = this.findNewBed();
            }
        }

        private BlockPos findNewBed() {
            List<BlockPos> beds = this.findBedsNearOwner(this.owner);
            if (beds.isEmpty()) {
                return null;
            }
            return this.bedSearchType == BedSearchType.NEAREST ? this.getNearestBedFromList(beds) : (this.bedSearchType == BedSearchType.FURTHER ? this.getFurtherAwayBedFromList(beds) : (BlockPos)this.getBestBed(beds, this.bedSearchType.getMinScale(), this.bedSearchType.getMaxScale()).orElse(null));
        }

        public void m_8041_() {
            if (this.pet.m_5803_()) {
                BlockState bedState;
                this.pet.m_5796_();
                if (this.bedPos != null && (bedState = this.pet.f_19853_.m_8055_(this.bedPos)).m_60734_() instanceof BedBlock) {
                    this.pet.f_19853_.m_46597_(this.bedPos, (BlockState)bedState.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(false)));
                }
            }
            this.owner = null;
            this.bedPos = null;
            this.sleepTimer = 0;
        }

        private List<BlockPos> findBedsNearOwner(Player player) {
            if (player == null) {
                return Collections.emptyList();
            }
            Level world = this.pet.f_19853_;
            BlockPos ownerPos = player.m_142538_();
            BlockPos playerBed = player.m_21257_().orElse(null);
            ArrayList<BlockPos> nearbyBeds = new ArrayList<BlockPos>();
            for (int x = -5; x <= 5; ++x) {
                for (int y = -5; y <= 5; ++y) {
                    for (int z = -5; z <= 5; ++z) {
                        BlockPos checkPos = ownerPos.m_142082_(x, y, z);
                        BlockState state = world.m_8055_(checkPos);
                        Block block = state.m_60734_();
                        if (!(block instanceof BedBlock)) continue;
                        BedBlock bedBlock = (BedBlock)block;
                        if (((Boolean)state.m_61143_((Property)BedBlock.f_49441_)).booleanValue() || state.m_61143_((Property)BedBlock.f_49440_) != BedPart.HEAD || checkPos.equals((Object)playerBed)) continue;
                        nearbyBeds.add(checkPos);
                    }
                }
            }
            return nearbyBeds;
        }

        private BlockPos getFurtherAwayBedFromList(List<BlockPos> bedList) {
            BlockPos nearestBed = null;
            double nearestDistanceSq = Double.MIN_VALUE;
            for (BlockPos bedPos : bedList) {
                double distanceSq = this.owner.m_20275_((double)bedPos.m_123341_() + 0.5, (double)bedPos.m_123342_(), (double)bedPos.m_123343_() + 0.5);
                if (!(distanceSq > nearestDistanceSq)) continue;
                nearestDistanceSq = distanceSq;
                nearestBed = bedPos;
            }
            return nearestBed;
        }

        private BlockPos getNearestBedFromList(List<BlockPos> bedList) {
            BlockPos nearestBed = null;
            double nearestDistanceSq = Double.MAX_VALUE;
            for (BlockPos bedPos : bedList) {
                double distanceSq = this.owner.m_20275_((double)bedPos.m_123341_() + 0.5, (double)bedPos.m_123342_(), (double)bedPos.m_123343_() + 0.5);
                if (!(distanceSq < nearestDistanceSq)) continue;
                nearestDistanceSq = distanceSq;
                nearestBed = bedPos;
            }
            return nearestBed;
        }

        private Optional<BlockPos> getBestBed(List<BlockPos> bedList, double minScale, double maxScale) {
            if (minScale >= maxScale) {
                minScale = maxScale;
            }
            double maxDistance = 25.0 * maxScale;
            double minDistance = 25.0 * minScale;
            return bedList.stream().map(bedPos -> Map.entry(bedPos, this.pet.m_20275_((double)bedPos.m_123341_() + 0.5, (double)bedPos.m_123342_(), (double)bedPos.m_123343_() + 0.5))).filter(entry -> (Double)entry.getValue() >= minDistance && (Double)entry.getValue() <= maxDistance).min(Comparator.comparingDouble(Map.Entry::getValue)).map(Map.Entry::getKey);
        }

        public static class BedSearchType {
            public static final BedSearchType NEAREST = new BedSearchType(0.0, 10.0);
            public static final BedSearchType FURTHER = new BedSearchType(10.0, 10.0);
            private final double MinScale;
            private final double MaxScale;

            public BedSearchType(double[] scale) {
                this.MinScale = scale[0];
                this.MaxScale = scale[1];
            }

            public BedSearchType(double MinScale, double MaxScale) {
                this.MinScale = MinScale;
                this.MaxScale = MaxScale;
            }

            public double getMaxScale() {
                return this.MaxScale;
            }

            public double getMinScale() {
                return this.MinScale;
            }
        }
    }
}

