/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.void_fox;

import java.util.EnumSet;
import java.util.List;
import net.foxyas.changedaddon.entity.projectile.VoidFoxParticleProjectile;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VoidFoxDashAttack
extends Goal {
    public static final int PREPARE_TIME = 60;
    public static final int MAX_DASH_TICKS = 20;
    private static final double DETECTION_DISTANCE = 3.5;
    private static final double KNOCKBACK_MULTIPLIER = 1.5;
    private final Mob dasher;
    private final EntityType<? extends VoidFoxParticleProjectile> projectileType;
    private LivingEntity target;
    private int tickCount = 0;
    private boolean isDashing = false;
    private Vec3 dashDirection = Vec3.f_82478_;
    private float dashSpeed = 1.0f;
    private float strength = 1.0f;

    public VoidFoxDashAttack(Mob dasher, EntityType<? extends VoidFoxParticleProjectile> projectileType) {
        this.dasher = dasher;
        this.projectileType = projectileType;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_8036_() {
        Player player;
        this.target = this.dasher.m_5448_();
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            return false;
        }
        return this.target != null && this.target.m_6084_() && this.target.m_20270_((Entity)this.dasher) >= 3.5f;
    }

    public boolean m_8045_() {
        return this.isDashing || this.tickCount < 80;
    }

    public void m_8056_() {
        if (this.tickCount >= 80) {
            this.tickCount = 0;
        }
        this.isDashing = false;
        this.dashDirection = Vec3.f_82478_;
    }

    public void m_8037_() {
        ++this.tickCount;
        this.dashDirection.m_82490_((double)this.dashSpeed);
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
        }
        if (this.tickCount < 60) {
            this.dasher.m_21573_().m_26573_();
            this.dasher.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            this.dashDirection = this.dasher.m_20252_(1.0f).m_82490_((double)this.strength).m_82542_(1.0, 0.0, 1.0);
            if (this.tickCount % 20 == 0) {
                this.shootProjectile(this.target);
                if (!this.dasher.m_183503_().m_5776_()) {
                    this.dasher.m_183503_().m_6269_(null, (Entity)this.dasher, SoundEvents.f_11867_, SoundSource.HOSTILE, 2.0f, (float)this.tickCount / 60.0f);
                }
            }
            if ((livingEntity = this.dasher.m_183503_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)livingEntity;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, this.dasher.m_20185_(), this.dasher.m_20188_(), this.dasher.m_20189_(), 4, 0.25, 0.5, 0.25, 0.5);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.dasher.m_20185_(), this.dasher.m_20188_(), this.dasher.m_20189_(), 4, 0.25, 0.5, 0.25, (double)0.05f);
            }
            this.isDashing = false;
            return;
        }
        if (!this.isDashing) {
            this.isDashing = true;
        }
        if (this.tickCount <= 80) {
            this.dasher.m_20256_(this.dashDirection);
            this.dasher.m_21563_().m_24964_(this.dasher.m_146892_().m_82549_(this.dashDirection));
            if (this.dasher.f_19862_ || this.dasher.f_185931_) {
                this.tickCount += 5;
            }
            Vec3 forward = this.dasher.m_20154_();
            Vec3 origin = this.dasher.m_20182_();
            AABB detectionBox = this.dasher.m_142469_().m_82369_(forward.m_82490_(3.5)).m_82400_(1.0);
            List entities = this.dasher.f_19853_.m_6443_(LivingEntity.class, detectionBox, e -> e != this.dasher && e.m_6084_());
            for (LivingEntity entity : entities) {
                Vec3 difference = entity.m_20182_().m_82546_(this.dasher.m_20182_());
                double distance = difference.m_82553_();
                if (!(distance > 0.1)) continue;
                Vec3 knockback = difference.m_82541_().m_82490_(distance * 1.5);
                this.dasher.m_6674_(InteractionHand.MAIN_HAND);
                if (entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.dasher), 6.0f)) {
                    this.dasher.m_183503_().m_6269_(null, (Entity)entity, SoundEvents.f_12316_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    this.dasher.m_183503_().m_6269_(null, (Entity)entity, SoundEvents.f_12313_, SoundSource.HOSTILE, 1.0f, 1.0f);
                } else {
                    Level level = this.dasher.m_183503_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), 4, 0.25, 0.25, 0.25, 0.05);
                    }
                    if (entity.m_21254_() && this.dasher.m_183503_().m_5776_()) {
                        this.dasher.m_183503_().m_6269_(null, (Entity)entity, SoundEvents.f_12346_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    }
                }
                entity.m_20256_(entity.m_20184_().m_82549_(knockback));
            }
            this.isDashing = false;
        }
    }

    public Vec3 getDashDirection() {
        return this.dashDirection;
    }

    public void setDashDirection(Vec3 dashDirection) {
        this.dashDirection = dashDirection;
    }

    public float getDashSpeed() {
        return this.dashSpeed;
    }

    public void setDashSpeed(float dashSpeed) {
        this.dashSpeed = dashSpeed;
    }

    public boolean isChargingDash() {
        return this.tickCount <= 60;
    }

    public boolean isDashing() {
        return this.isDashing;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public Mob getDasher() {
        return this.dasher;
    }

    private void shootProjectile(LivingEntity target) {
        Level level = this.dasher.f_19853_;
        switch (this.dasher.m_21187_().nextInt(3)) {
            case 0: {
                this.spawnProjectilesInCircle((LivingEntity)this.dasher, target, new Vec3(0.0, 0.5, 0.0), 2.0, 4, level);
                break;
            }
            case 1: {
                this.spawnProjectilesInXCircleTargetInPlayer((LivingEntity)this.dasher, target, new Vec3(0.0, 0.0, 0.0), 2.0, 8, level);
                break;
            }
            case 2: {
                this.spawnProjectilesInXCircleTargetInPlayerPos((LivingEntity)this.dasher, target, new Vec3(0.0, 0.0, 0.0), 2.0, 8, level);
            }
        }
    }

    public void spawnProjectilesInCircle(LivingEntity entity, LivingEntity target, Vec3 offset, double radius, int count, Level level) {
        Vec3 center = entity.m_146892_().m_82549_(offset);
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)count;
            Vec3 dir = new Vec3(1.0, 0.0, 0.0).m_82535_((float)angle).m_82524_((float)Math.toRadians(-this.dasher.m_146908_())).m_82541_();
            Vec3 spawnPos = center.m_82549_(dir.m_82490_(radius));
            if (level.m_5776_()) continue;
            VoidFoxParticleProjectile projectile = new VoidFoxParticleProjectile(this.projectileType, (LivingEntity)this.dasher, this.dasher.m_183503_(), target);
            projectile.m_146884_(spawnPos);
            projectile.m_20242_(true);
            projectile.m_5602_((Entity)this.dasher);
            projectile.teleport = false;
            Vec3 direction = target.m_20299_(1.0f).m_82546_(this.dasher.m_20299_(0.5f)).m_82541_();
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 0.0f);
            entity.f_19853_.m_7967_((Entity)projectile);
        }
        this.dasher.m_6674_(InteractionHand.MAIN_HAND);
    }

    public void spawnProjectilesInXCircleTargetInPlayer(LivingEntity entity, LivingEntity target, Vec3 offset, double radius, int count, Level level) {
        Vec3 center = target.m_146892_().m_82549_(offset);
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)count;
            Vec3 dir = new Vec3(1.0, 0.0, 0.0).m_82524_((float)angle).m_82541_();
            Vec3 spawnPos = center.m_82549_(dir.m_82490_(radius));
            if (level.m_5776_()) continue;
            VoidFoxParticleProjectile projectile = new VoidFoxParticleProjectile(this.projectileType, (LivingEntity)this.dasher, this.dasher.m_183503_(), target);
            projectile.m_146884_(spawnPos);
            projectile.m_20242_(true);
            projectile.m_5602_((Entity)this.dasher);
            projectile.teleport = false;
            Vec3 direction = target.m_20299_(1.0f).m_82546_(this.dasher.m_20299_(0.5f)).m_82541_();
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 0.0f);
            entity.f_19853_.m_7967_((Entity)projectile);
        }
        this.dasher.m_6674_(InteractionHand.MAIN_HAND);
    }

    public void spawnProjectilesInXCircleTargetInPlayerPos(LivingEntity entity, LivingEntity target, Vec3 offset, double radius, int count, Level level) {
        Vec3 center = target.m_146892_().m_82549_(offset);
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)count;
            Vec3 dir = new Vec3(1.0, 0.0, 0.0).m_82496_((float)angle).m_82541_();
            Vec3 spawnPos = center.m_82549_(dir.m_82490_(radius));
            if (level.m_5776_()) continue;
            VoidFoxParticleProjectile projectile = new VoidFoxParticleProjectile(this.projectileType, (LivingEntity)this.dasher, this.dasher.m_183503_(), null);
            projectile.setTargetPos(target.m_20182_());
            projectile.m_146884_(spawnPos);
            projectile.m_20242_(true);
            projectile.m_5602_((Entity)this.dasher);
            projectile.teleport = false;
            Vec3 direction = target.m_20299_(1.0f).m_82546_(this.dasher.m_20299_(0.5f)).m_82541_();
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 0.0f);
            entity.f_19853_.m_7967_((Entity)projectile);
        }
        this.dasher.m_6674_(InteractionHand.MAIN_HAND);
    }
}

