/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.interfaces;

import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface CrawlFeature {
    default public void crawlingSystem(ChangedEntity livingEntity, LivingEntity target, float swimSpeed) {
        this.updateSwimmingMovement(livingEntity, swimSpeed);
        if (target != null) {
            this.setCrawlingPoseIfNeeded((LivingEntity)livingEntity, target);
            this.crawlToTarget((LivingEntity)livingEntity, target);
        } else if (!livingEntity.m_6069_() && !livingEntity.f_19853_.m_8055_(new BlockPos(livingEntity.m_20185_(), livingEntity.m_20188_(), livingEntity.m_20189_())).m_60795_()) {
            livingEntity.m_20124_(Pose.SWIMMING);
        }
    }

    default public void crawlingSystem(ChangedEntity livingEntity, LivingEntity target) {
        this.crawlingSystem(livingEntity, target, 0.07f);
    }

    default public void OnlyCrawlingSystem(LivingEntity livingEntity, LivingEntity target) {
        if (target != null) {
            this.setCrawlingPoseIfNeeded(livingEntity, target);
            this.crawlToTarget(livingEntity, target);
        } else {
            BlockPos above = new BlockPos(livingEntity.m_20185_(), livingEntity.m_20188_(), livingEntity.m_20189_()).m_7494_();
            BlockState blockState = livingEntity.f_19853_.m_8055_(above);
            if (!(livingEntity.m_20089_() != Pose.SWIMMING || livingEntity.m_20069_() || !blockState.m_60795_() && blockState.m_60828_((BlockGetter)livingEntity.f_19853_, above) && blockState.m_60804_((BlockGetter)livingEntity.f_19853_, above))) {
                livingEntity.m_20124_(Pose.STANDING);
            }
            if (!livingEntity.m_6069_() && (!blockState.m_60795_() || blockState.m_60828_((BlockGetter)livingEntity.f_19853_, above) || blockState.m_60804_((BlockGetter)livingEntity.f_19853_, above))) {
                livingEntity.m_20124_(Pose.SWIMMING);
            }
        }
    }

    default public void setCrawlingPoseIfNeeded(LivingEntity livingEntity, LivingEntity target) {
        if (target.m_20089_() == Pose.SWIMMING && livingEntity.m_20089_() != Pose.SWIMMING) {
            if (target.m_20186_() < livingEntity.m_20188_() && !target.f_19853_.m_8055_(new BlockPos(target.m_20185_(), target.m_20188_(), target.m_20189_()).m_7494_()).m_60795_()) {
                livingEntity.m_20124_(Pose.SWIMMING);
            }
        } else if (!livingEntity.m_6069_() && livingEntity.f_19853_.m_8055_(new BlockPos(livingEntity.m_20185_(), livingEntity.m_20188_(), livingEntity.m_20189_()).m_7494_()).m_60795_()) {
            livingEntity.m_20124_(Pose.STANDING);
        }
    }

    default public void crawlToTarget(LivingEntity livingEntity, LivingEntity target) {
        if (target.m_20089_() == Pose.SWIMMING && livingEntity.m_20089_() == Pose.SWIMMING) {
            Vec3 direction = target.m_20182_().m_82546_(livingEntity.m_20182_()).m_82541_();
            livingEntity.m_20256_(livingEntity.m_20184_().m_82549_(direction.m_82490_(0.05)));
        }
    }

    default public void updateSwimmingMovement(ChangedEntity livingEntity, float speed) {
        if (livingEntity.m_20069_()) {
            if (livingEntity.m_5448_() != null) {
                Vec3 direction = livingEntity.m_5448_().m_20182_().m_82546_(livingEntity.m_20182_()).m_82541_();
                if (livingEntity.m_204029_(FluidTags.f_13131_)) {
                    livingEntity.m_20256_(livingEntity.m_20184_().m_82549_(direction.m_82490_((double)speed)));
                } else {
                    livingEntity.m_20256_(livingEntity.m_20184_().m_82549_(direction.m_82490_((double)(speed / 4.0f))));
                }
            }
            if (livingEntity.m_204029_(FluidTags.f_13131_)) {
                livingEntity.m_20124_(Pose.SWIMMING);
                livingEntity.m_20282_(true);
            } else {
                livingEntity.m_20124_(Pose.STANDING);
                livingEntity.m_20282_(false);
            }
        } else {
            BlockPos above = new BlockPos(livingEntity.m_20185_(), livingEntity.m_20188_(), livingEntity.m_20189_()).m_7494_();
            BlockState blockState = livingEntity.f_19853_.m_8055_(above);
            if (!(livingEntity.m_20089_() != Pose.SWIMMING || livingEntity.m_20069_() || !blockState.m_60795_() && blockState.m_60828_((BlockGetter)livingEntity.f_19853_, above) && blockState.m_60804_((BlockGetter)livingEntity.f_19853_, above))) {
                livingEntity.m_20124_(Pose.STANDING);
            }
        }
    }
}

