/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.projectile;

import java.util.UUID;
import net.foxyas.changedaddon.entity.bosses.VoidFoxEntity;
import net.foxyas.changedaddon.entity.projectile.ParriableProjectile;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVoidFoxParticleProjectile
extends ParriableProjectile {
    private static final EntityDataAccessor<Boolean> PARRY_ABLE = SynchedEntityData.m_135353_(AbstractVoidFoxParticleProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean teleport = false;
    @Nullable
    protected Entity target = null;
    @Nullable
    protected Vec3 targetPos = null;
    protected ParticleOptions particle = ParticleTypes.f_123810_;
    protected int lifeSpamWithoutTarget;
    protected int lifeSpamNearTarget = 0;
    @Nullable
    private UUID targetUUID;
    private boolean smoothMotion = false;

    protected AbstractVoidFoxParticleProjectile(EntityType<? extends AbstractVoidFoxParticleProjectile> type, Level level) {
        super(type, level);
        this.setBaseDamage(1.0);
        this.setPierceLevel((byte)0);
        this.setKnockback(0);
        this.m_20225_(true);
        this.m_20242_(true);
    }

    protected AbstractVoidFoxParticleProjectile(EntityType<? extends AbstractVoidFoxParticleProjectile> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
    }

    protected AbstractVoidFoxParticleProjectile(EntityType<? extends AbstractVoidFoxParticleProjectile> type, LivingEntity shooter, Level level) {
        super(type, shooter, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARRY_ABLE, (Object)false);
    }

    public boolean isParryAble() {
        return (Boolean)this.f_19804_.m_135370_(PARRY_ABLE);
    }

    public void setParryAble(boolean set) {
        this.f_19804_.m_135381_(PARRY_ABLE, (Object)set);
    }

    @Nullable
    public Entity getTarget() {
        if (this.target != null && !this.target.m_146910_()) {
            return this.target;
        }
        if (this.targetUUID != null && this.f_19853_ instanceof ServerLevel) {
            this.target = ((ServerLevel)this.f_19853_).m_8791_(this.targetUUID);
            return this.target;
        }
        return null;
    }

    public void setTarget(@Nullable LivingEntity target) {
        this.target = target;
        if (target != null) {
            this.targetUUID = target.m_142081_();
        }
    }

    public void setTarget(@Nullable Entity target) {
        this.target = target;
    }

    @Nullable
    public UUID getTargetUUID() {
        return this.targetUUID;
    }

    public void setTargetUUID(@Nullable UUID targetUUID) {
        this.targetUUID = targetUUID;
    }

    public ParticleOptions getParticle() {
        return this.particle;
    }

    public void setParticle(ParticleOptions particle) {
        this.particle = particle;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("ticksWandering", this.lifeSpamWithoutTarget);
        tag.m_128405_("lifeSpamNearTarget", this.lifeSpamNearTarget);
        tag.m_128379_("isSmoothMotion", this.smoothMotion);
        tag.m_128379_("isParryAble", this.isParryAble());
        if (this.targetPos != null) {
            tag.m_128365_("TargetPos", (Tag)this.m_20063_(new double[]{this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_}));
        }
        if (this.targetUUID != null) {
            tag.m_128362_("target", this.targetUUID);
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("ticksWandering")) {
            this.lifeSpamWithoutTarget = tag.m_128451_("ticksWandering");
        }
        if (tag.m_128441_("lifeSpamNearTarget")) {
            this.lifeSpamNearTarget = tag.m_128451_("lifeSpamNearTarget");
        }
        if (tag.m_128441_("isSmoothMotion")) {
            this.smoothMotion = tag.m_128471_("isSmoothMotion");
        }
        if (tag.m_128441_("isParryAble")) {
            this.setParryAble(tag.m_128471_("isParryAble"));
        }
        if (tag.m_128441_("TargetPos")) {
            try {
                ListTag TargetPosList = tag.m_128437_("TargetPos", 6);
                this.targetPos = new Vec3(TargetPosList.m_128772_(0), TargetPosList.m_128772_(1), TargetPosList.m_128772_(2));
            }
            catch (Throwable ignored) {
                this.targetPos = Vec3.f_82478_;
            }
        }
        if (tag.m_128403_("target")) {
            this.targetUUID = tag.m_128342_("target");
        }
    }

    @Nullable
    public Vec3 getTargetPos() {
        return this.targetPos;
    }

    public void setTargetPos(@Nullable Vec3 targetPos) {
        this.targetPos = targetPos;
    }

    public int getLifeSpamWithoutTarget() {
        return this.lifeSpamWithoutTarget;
    }

    public void setLifeSpamWithoutTarget(int lifeSpamWithoutTarget) {
        this.lifeSpamWithoutTarget = lifeSpamWithoutTarget;
    }

    @Override
    public void m_8119_() {
        LivingEntity livingEntity;
        Entity entity;
        Entity entity2;
        super.m_8119_();
        this.m_7311_(0);
        if (this.f_19797_ > 400) {
            ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.05f, 0.05f, 0.05f, 20, 0.5f);
            this.m_146870_();
        }
        if (this.lifeSpamNearTarget >= 100) {
            ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.05f, 0.05f, 0.05f, 20, 0.5f);
            this.lifeSpamWithoutTarget = 0;
            this.m_146870_();
        }
        if (this.getTarget() == null && this.targetPos != null) {
            if (this.f_19861_) {
                ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.05f, 0.05f, 0.05f, 20, 0.5f);
                this.m_146870_();
            }
            this.lifeSpamWithoutTarget = 0;
            double dx = this.targetPos.m_7096_() - this.m_20185_();
            double dy = this.targetPos.m_7098_() - this.m_20186_();
            double dz = this.targetPos.m_7094_() - this.m_20189_();
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetPos);
            if (distance > (double)0.1f) {
                double speed = 0.35;
                Vec3 desiredMotion = new Vec3(dx / distance, dy / distance, dz / distance).m_82490_(speed);
                if (this.smoothMotion) {
                    this.applyMotionSmooth(desiredMotion);
                } else {
                    this.applyMotion(desiredMotion);
                }
            } else {
                ++this.lifeSpamNearTarget;
            }
        }
        if (!((entity2 = this.getTarget()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingTarget = (LivingEntity)entity2;
        if (!this.f_19853_.f_46443_ && livingTarget.m_6084_()) {
            Player player;
            if (this.m_37282_() != null && livingTarget.m_7306_(this.m_37282_())) {
                ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.05f, 0.05f, 0.05f, 20, 0.5f);
                this.m_146870_();
            }
            if (this.f_19861_) {
                ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.05f, 0.05f, 0.05f, 20, 0.5f);
                this.m_146870_();
            }
            this.lifeSpamWithoutTarget = 0;
            if (livingTarget instanceof Player && ((player = (Player)livingTarget).m_7500_() || player.m_5833_())) {
                ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.05f, 0.05f, 0.05f, 20, 0.5f);
                this.m_146870_();
            }
            double dx = livingTarget.m_20185_() - this.m_20185_();
            double dy = livingTarget.m_20186_() + (double)livingTarget.m_20206_() / 2.0 - this.m_20186_();
            double dz = livingTarget.m_20189_() - this.m_20189_();
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, livingTarget.m_20182_());
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (distance > (double)0.1f) {
                double speed = 0.35;
                Vec3 desiredMotion = new Vec3(dx / distance, dy / distance, dz / distance).m_82490_(speed);
                if (this.smoothMotion) {
                    this.applyMotionSmooth(desiredMotion);
                } else {
                    this.applyMotion(desiredMotion);
                }
            } else {
                ++this.lifeSpamNearTarget;
                this.m_5790_(new EntityHitResult((Entity)livingTarget));
            }
        } else if (!this.f_19853_.f_46443_ && livingTarget.m_21224_()) {
            ++this.lifeSpamWithoutTarget;
            if (this.lifeSpamWithoutTarget >= 120) {
                ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.05f, 0.05f, 0.05f, 20, 0.5f);
                this.lifeSpamWithoutTarget = 0;
                this.m_146870_();
            }
        } else if (!this.f_19853_.m_5776_() && (this.m_37282_() == null || (entity = this.m_37282_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21224_())) {
            ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.05f, 0.05f, 0.05f, 20, 0.5f);
            this.m_146870_();
        }
        ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.3f, 0.3f, 0.3f, 1, 0.005f);
    }

    public boolean isSmoothMotion() {
        return this.smoothMotion;
    }

    public void setSmoothMotion(boolean smoothMotion) {
        this.smoothMotion = smoothMotion;
    }

    public void applyMotion(Vec3 desiredMotion) {
        this.m_6001_(desiredMotion.f_82479_, desiredMotion.f_82480_, desiredMotion.f_82481_);
        this.f_19812_ = true;
    }

    public void applyMotionSmooth(Vec3 desiredMotion) {
        Vec3 currentMotion = this.m_20184_();
        double lerpFactor = 0.1;
        Vec3 smoothedMotion = currentMotion.m_165921_(desiredMotion, lerpFactor);
        this.m_20256_(smoothedMotion);
        this.f_19812_ = true;
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (entity instanceof VoidFoxEntity) {
            VoidFoxEntity voidFox = (VoidFoxEntity)entity;
            voidFox.f_19802_ = 0;
            voidFox.f_20917_ = 1;
            voidFox.f_20918_ = 1.0f;
            voidFox.f_20916_ = 1;
            super.m_5790_(result);
            return;
        }
        if (this.isParryAble() && (entity = result.m_82443_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_19802_ = 0;
            livingEntity.f_20917_ = 1;
            livingEntity.f_20918_ = 1.0f;
            livingEntity.f_20916_ = 1;
        }
        if (this.isParryAble()) {
            this.HandleParry(result);
        } else {
            ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.05f, 0.05f, 0.05f, 5, 0.5f);
            super.m_5790_(result);
            if (result.m_82443_().f_19864_) {
                ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.05f, 0.05f, 0.05f, 20, 0.5f);
                this.m_146870_();
            }
        }
    }

    @Override
    protected boolean m_5603_(@NotNull Entity entity) {
        VoidFoxEntity voidFoxEntity;
        Entity entity2 = this.m_37282_();
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            return !player.m_7306_(entity);
        }
        entity2 = this.m_37282_();
        if (entity2 instanceof VoidFoxEntity && (voidFoxEntity = (VoidFoxEntity)entity2).m_7306_(entity)) {
            return true;
        }
        return super.m_5603_(entity);
    }

    private void HandleParry(@NotNull EntityHitResult result) {
        LivingEntity livingEntity;
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21254_() && this.m_37282_() != null && this.getTarget() != null) {
            EquipmentSlot[] equipmentSlotArray;
            Entity oTarget = this.getTarget();
            Entity oOwner = this.m_37282_();
            this.m_5602_(oTarget);
            this.setTarget(oOwner);
            this.setBaseDamage(5.0);
            if (!oTarget.f_19853_.m_5776_() && (equipmentSlotArray = oTarget.m_183503_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)equipmentSlotArray;
                serverLevel.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_12346_, SoundSource.MASTER, 1.0f, 1.0f);
                serverLevel.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_11668_, SoundSource.MASTER, 0.5f, 1.2f);
                for (EquipmentSlot itemBySlot : EquipmentSlot.values()) {
                    ItemStack stack = livingEntity.m_6844_(itemBySlot);
                    stack.m_41721_(Math.max(stack.m_41773_() - 2, 0));
                }
            }
            this.m_20256_(this.m_20184_().m_82490_(-1.0));
            this.lifeSpamNearTarget = 0;
            this.lifeSpamWithoutTarget = 0;
        }
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float amount) {
        if (this.isParryAble()) {
            Entity entity = damageSource.m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.m_37282_() != null && this.getTarget() != null) {
                    EquipmentSlot[] equipmentSlotArray;
                    Entity oTarget = this.getTarget();
                    Entity oOwner = this.m_37282_();
                    this.m_5602_(oTarget);
                    this.setTarget(oOwner);
                    this.setBaseDamage(5.0);
                    if (!oTarget.m_183503_().m_5776_() && (equipmentSlotArray = oTarget.m_183503_()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)equipmentSlotArray;
                        serverLevel.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_12346_, SoundSource.MASTER, 1.0f, 1.0f);
                        serverLevel.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_11668_, SoundSource.MASTER, 0.5f, 1.2f);
                        for (EquipmentSlot itemBySlot : EquipmentSlot.values()) {
                            ItemStack stack = livingEntity.m_6844_(itemBySlot);
                            stack.m_41721_(Math.max(stack.m_41773_() - 2, 0));
                        }
                    }
                    this.m_20256_(this.m_20184_().m_82490_(-1.0));
                    this.lifeSpamNearTarget = 0;
                    this.lifeSpamWithoutTarget = 0;
                    this.m_5834_();
                    return true;
                }
            }
        } else if (damageSource.m_7639_() != null) {
            Level level;
            if (this.m_6673_(damageSource)) {
                return false;
            }
            this.m_20256_(this.m_20184_().m_82490_((double)(-amount) * 0.1));
            this.lifeSpamNearTarget = 0;
            this.lifeSpamWithoutTarget = 0;
            this.m_5834_();
            if (!this.f_19853_.m_5776_() && (level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_12346_, SoundSource.MASTER, 1.0f, 1.0f);
                serverLevel.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_11668_, SoundSource.MASTER, 0.5f, 1.2f);
            }
            return true;
        }
        return super.m_6469_(damageSource, amount);
    }

    @Override
    public boolean m_6097_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    @Override
    protected void m_8060_(@NotNull BlockHitResult result) {
        ParticlesUtil.sendParticles(this.f_19853_, this.particle, this.m_20182_(), 0.05f, 0.05f, 0.05f, 20, 0.5f);
        this.m_146870_();
    }

    @Override
    @NotNull
    protected ItemStack getPickupItem() {
        return ItemStack.f_41583_;
    }

    public boolean m_142391_() {
        return this.m_37282_() != null;
    }

    @Override
    protected void doPostHurtEffects(@NotNull LivingEntity targetHit) {
        Entity entity;
        boolean blocked;
        if (!this.f_19853_.f_46443_ && !(blocked = targetHit.m_21254_()) && (entity = this.m_37282_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            if (this.teleport) {
                if (targetHit.m_21187_().nextFloat() <= 0.25f) {
                    targetHit.m_6021_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
                } else {
                    owner.m_6021_(targetHit.m_20185_(), targetHit.m_20186_(), targetHit.m_20189_());
                }
            }
        }
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

