/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.projectile;

import javax.annotation.Nullable;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.foxyas.changedaddon.util.FoxyasUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class LuminarCrystalSpearEntity
extends AbstractArrow
implements ItemSupplier {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(LuminarCrystalSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(LuminarCrystalSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int clientSideReturnSpearTickCount;
    private ItemStack SpearItem = new ItemStack((ItemLike)ChangedAddonItems.LUMINAR_CRYSTAL_SPEAR.get());
    private boolean dealtDamage;

    public LuminarCrystalSpearEntity(PlayMessages.SpawnEntity ignoredPacket, Level world) {
        super((EntityType)ChangedAddonEntities.LUMINAR_CRYSTAL_SPEAR.get(), world);
    }

    public LuminarCrystalSpearEntity(Level p_37569_, LivingEntity p_37570_, ItemStack p_37571_) {
        super((EntityType)ChangedAddonEntities.LUMINAR_CRYSTAL_SPEAR.get(), p_37570_, p_37569_);
        this.SpearItem = p_37571_.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)p_37571_)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)p_37571_.m_41790_());
    }

    public LuminarCrystalSpearEntity(EntityType<? extends LuminarCrystalSpearEntity> type, Level world) {
        super(type, world);
    }

    public LuminarCrystalSpearEntity(EntityType<? extends LuminarCrystalSpearEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public LuminarCrystalSpearEntity(EntityType<? extends LuminarCrystalSpearEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack m_7846_() {
        return this.SpearItem;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.SpearItem;
    }

    protected void m_7761_(@NotNull LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_37282_();
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnSpearTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnSpearTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_37282_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(@NotNull Vec3 p_37575_, @NotNull Vec3 p_37576_) {
        return this.dealtDamage ? null : super.m_6351_(p_37575_, p_37576_);
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        Level level = this.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockState hitState = serverLevel.m_8055_(result.m_82425_());
            if (hitState.m_60713_((Block)ChangedAddonBlocks.LUMINAR_CRYSTAL_BLOCK.get()) || hitState.m_60795_()) {
                return;
            }
            Explosion explosion = new Explosion((Level)serverLevel, (Entity)this, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), 3.0f);
            int radius = 1 + Math.max(0, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)this.SpearItem) / 3);
            for (BlockPos pos : FoxyasUtils.betweenClosedStreamSphere(result.m_82425_(), radius, radius, 1.25f).toList()) {
                BlockState state = serverLevel.m_8055_(pos);
                if (state.m_60713_((Block)ChangedAddonBlocks.LUMINAR_CRYSTAL_BLOCK.get()) || state.m_60795_() || !TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.STONE, (BlockState)state) || !(state.getExplosionResistance((BlockGetter)serverLevel, result.m_82425_(), explosion) < 1.0f)) continue;
                serverLevel.m_46597_(pos, ((Block)ChangedAddonBlocks.LUMINAR_CRYSTAL_BLOCK.get()).m_49966_());
                serverLevel.m_5594_(null, pos, ((Block)ChangedAddonBlocks.LUMINAR_CRYSTAL_BLOCK.get()).m_49966_().m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    protected void m_5790_(EntityHitResult p_37573_) {
        BlockPos blockpos;
        Entity entity1;
        Entity entity = p_37573_.m_82443_();
        float f = 12.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.SpearItem, (MobType)livingentity.m_6336_());
        }
        DamageSource damagesource = DamageSource.m_19337_((Entity)this, (Entity)((entity1 = this.m_37282_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.m_7761_(livingentity1);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        if (this.f_19853_ instanceof ServerLevel && this.f_19853_.m_46470_() && this.isChanneling() && this.f_19853_.m_45527_(blockpos = entity.m_142538_())) {
            LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
            assert (lightningbolt != null);
            lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
            lightningbolt.m_20879_(entity1 instanceof ServerPlayer ? (ServerPlayer)entity1 : null);
            this.f_19853_.m_7967_((Entity)lightningbolt);
            soundevent = SoundEvents.f_12521_;
            f1 = 5.0f;
        }
        this.m_5496_(soundevent, f1, 1.0f);
    }

    public boolean isChanneling() {
        return EnchantmentHelper.m_44936_((ItemStack)this.SpearItem);
    }

    protected boolean m_142470_(@NotNull Player p_150196_) {
        return super.m_142470_(p_150196_) || this.m_36797_() && this.m_150171_((Entity)p_150196_) && p_150196_.m_150109_().m_36054_(this.m_7941_());
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(@NotNull Player p_37580_) {
        if (this.m_150171_((Entity)p_37580_) || this.m_37282_() == null) {
            super.m_6123_(p_37580_);
        }
    }

    public void m_7378_(@NotNull CompoundTag p_37578_) {
        super.m_7378_(p_37578_);
        if (p_37578_.m_128425_("CrystalSpear", 10)) {
            this.SpearItem = ItemStack.m_41712_((CompoundTag)p_37578_.m_128469_("CrystalSpear"));
        }
        this.dealtDamage = p_37578_.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.SpearItem)));
    }

    public void m_7380_(@NotNull CompoundTag p_37582_) {
        super.m_7380_(p_37582_);
        p_37582_.m_128365_("CrystalSpear", (Tag)this.SpearItem.m_41739_(new CompoundTag()));
        p_37582_.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }
}

