/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.event;

import net.foxyas.changedaddon.ChangedAddonMod;
import net.foxyas.changedaddon.event.ProgressTransfurEvents;
import net.foxyas.changedaddon.init.ChangedAddonAttributes;
import net.foxyas.changedaddon.init.ChangedAddonGameRules;
import net.foxyas.changedaddon.init.ChangedAddonMobEffects;
import net.foxyas.changedaddon.item.clothes.AccessoryItemExtension;
import net.foxyas.changedaddon.network.ChangedAddonModVariables;
import net.foxyas.changedaddon.util.TransfurVariantUtils;
import net.ltxprogrammer.changed.data.AccessorySlotType;
import net.ltxprogrammer.changed.data.AccessorySlots;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.TransfurContext;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedItems;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.item.Syringe;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="changed_addon")
public class CommonEvent {
    @SubscribeEvent
    public static void persistAttributes(PlayerEvent.Clone event) {
        Player oldP = event.getOriginal();
        Player newP = (Player)event.getEntity();
        newP.m_21051_((Attribute)ChangedAddonAttributes.LATEX_RESISTANCE.get()).m_22100_(oldP.m_21051_((Attribute)ChangedAddonAttributes.LATEX_RESISTANCE.get()).m_22115_());
        newP.m_21051_((Attribute)ChangedAddonAttributes.LATEX_INFECTION.get()).m_22100_(oldP.m_21051_((Attribute)ChangedAddonAttributes.LATEX_INFECTION.get()).m_22115_());
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!player.f_19853_.m_5776_()) {
            ChangedAddonModVariables.PlayerVariables.ofOrDefault(player).syncPlayerVariables((Entity)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerPickupXp(PlayerXpEvent.PickupXp event) {
        Player player = event.getPlayer();
        ExperienceOrb experienceOrb = event.getOrb();
        AccessorySlots.getForEntity((LivingEntity)player).ifPresent(slots -> slots.forEachSlot((slotType, itemStack) -> {
            AccessoryItemExtension accessoryItemExtension;
            Item patt3080$temp = itemStack.m_41720_();
            if (patt3080$temp instanceof AccessoryItemExtension && (accessoryItemExtension = (AccessoryItemExtension)patt3080$temp).IsAffectedByMending((AccessorySlotType)slotType, (ItemStack)itemStack) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)itemStack) > 0) {
                int i = Math.min((int)((float)experienceOrb.m_20801_() * itemStack.getXpRepairRatio()), itemStack.m_41773_());
                itemStack.m_41721_(itemStack.m_41773_() - i);
            }
        }));
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!player.f_19853_.m_5776_()) {
            ChangedAddonModVariables.PlayerVariables.ofOrDefault(player).syncPlayerVariables((Entity)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        if (!player.f_19853_.m_5776_()) {
            ChangedAddonModVariables.PlayerVariables.ofOrDefault(player).syncPlayerVariables((Entity)player);
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        Player originalPl = event.getOriginal();
        originalPl.reviveCaps();
        ChangedAddonModVariables.PlayerVariables original = ChangedAddonModVariables.PlayerVariables.ofOrDefault(originalPl);
        originalPl.invalidateCaps();
        ChangedAddonModVariables.PlayerVariables clone = ChangedAddonModVariables.PlayerVariables.ofOrDefault(event.getPlayer());
        original.copyTo(clone, event.isWasDeath());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!player.m_6084_()) {
            return;
        }
        CommonEvent.maskTransfur(player, player.f_19853_);
        CommonEvent.tickUntransfur(player);
        CommonEvent.triggerSwimRegret(player);
    }

    @SubscribeEvent
    public static void onPlayerProgressTransfurTick(ProgressTransfurEvents.TickPlayerTransfurProgressEvent tickPlayerTransfurProgressEvent) {
        CommonEvent.tickInfectionAndRes(tickPlayerTransfurProgressEvent);
    }

    private static void maskTransfur(Player player, Level level) {
        TransfurVariantInstance instance;
        int doTransfur = level.m_6106_().m_5470_().m_46215_(ChangedAddonGameRules.DO_DARK_LATEX_MASK_TRANSFUR);
        if (doTransfur <= 0) {
            return;
        }
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        if (!player.getPersistentData().m_128441_("HoldingDarkLatexMask")) {
            player.getPersistentData().m_128405_("HoldingDarkLatexMask", 0);
        }
        int maskHeldTimer = player.getPersistentData().m_128451_("HoldingDarkLatexMask");
        if (ProcessTransfur.isPlayerTransfurred((Player)player)) {
            if (maskHeldTimer > 0) {
                player.getPersistentData().m_128405_("HoldingDarkLatexMask", maskHeldTimer - 1);
            } else {
                player.getPersistentData().m_128473_("HoldingDarkLatexMask");
            }
            return;
        }
        InteractionHand maskHand = null;
        if (player.m_21205_().m_150930_((Item)ChangedItems.DARK_LATEX_MASK.get())) {
            maskHand = InteractionHand.MAIN_HAND;
        }
        if (maskHand == null && player.m_21206_().m_150930_((Item)ChangedItems.DARK_LATEX_MASK.get())) {
            maskHand = InteractionHand.OFF_HAND;
        }
        if (maskHand == null) {
            if (maskHeldTimer > 0) {
                player.getPersistentData().m_128347_("HoldingDarkLatexMask", (double)(maskHeldTimer - 1));
            } else {
                player.getPersistentData().m_128473_("HoldingDarkLatexMask");
            }
            return;
        }
        if (maskHeldTimer < doTransfur) {
            player.getPersistentData().m_128405_("HoldingDarkLatexMask", maskHeldTimer + 1);
            return;
        }
        ItemStack stack = player.m_21120_(maskHand);
        stack.m_41774_(1);
        player.m_150109_().m_6596_();
        if (ProcessTransfur.progressTransfur((LivingEntity)player, (float)((float)ProcessTransfur.getEntityTransfurTolerance((LivingEntity)player) * 2.0f), (TransfurVariant)Syringe.getVariant((ItemStack)stack), (TransfurContext)TransfurContext.hazard((TransfurCause)TransfurCause.GRAB_REPLICATE)) && (instance = ProcessTransfur.getPlayerTransfurVariant((Player)player)) != null) {
            ChangedSounds.broadcastSound((Entity)player, (ResourceLocation)instance.getParent().sound, (float)1.0f, (float)1.0f);
        }
        player.getPersistentData().m_128405_("HoldingDarkLatexMask", 0);
        player.getPersistentData().m_128473_("HoldingDarkLatexMask");
    }

    public static void tickInfectionAndRes(ProgressTransfurEvents.TickPlayerTransfurProgressEvent event) {
        boolean resistanceWins;
        Player player = event.getPlayer();
        if (ProcessTransfur.isPlayerTransfurred((Player)player)) {
            return;
        }
        float progress = ProcessTransfur.getPlayerTransfurProgress((Player)player);
        if (progress < 0.0f) {
            return;
        }
        float newProgress = progress;
        float latexRes = (float)player.m_21133_((Attribute)ChangedAddonAttributes.LATEX_RESISTANCE.get());
        float infection = (float)player.m_21133_((Attribute)ChangedAddonAttributes.LATEX_INFECTION.get());
        float tolerance = (float)ProcessTransfur.getEntityTransfurTolerance((LivingEntity)player);
        boolean infectionWins = infection > latexRes;
        boolean bl = resistanceWins = latexRes >= infection;
        if (resistanceWins) {
            newProgress -= 0.5f * latexRes;
        } else if (infectionWins) {
            newProgress += progress * (infection / 50.0f);
            event.setCanceled(true);
        }
        if (player.f_19797_ % 20 == 0 && !player.m_7500_() && !player.m_5833_() && (newProgress = Mth.m_14036_((float)newProgress, (float)0.0f, (float)(tolerance * 0.998f))) != progress) {
            ProcessTransfur.setPlayerTransfurProgress((Player)player, (float)newProgress);
        }
    }

    private static void tickUntransfur(Player player) {
        ChangedAddonModVariables.PlayerVariables vars = ChangedAddonModVariables.PlayerVariables.of(player);
        if (vars == null) {
            return;
        }
        if (!player.m_21023_((MobEffect)ChangedAddonMobEffects.UNTRANSFUR.get())) {
            if (vars.untransfurProgress > 0.0) {
                vars.untransfurProgress -= (double)0.1f;
                vars.syncPlayerVariables((Entity)player);
            }
            return;
        }
        if (!ProcessTransfur.isPlayerTransfurred((Player)player)) {
            return;
        }
        if (vars.untransfurProgress < 0.0) {
            vars.untransfurProgress = 0.0;
        } else {
            vars.untransfurProgress = vars.untransfurProgress + (ProcessTransfur.isPlayerNotLatex((Player)player) ? 0.1 : 0.2);
            if (player.m_5803_()) {
                vars.untransfurProgress += 0.5;
            }
        }
        vars.syncPlayerVariables((Entity)player);
    }

    private static void triggerSwimRegret(Player player) {
        if (player.f_19853_.f_46443_ || !ProcessTransfur.isPlayerTransfurred((Player)player)) {
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        if (playerData.m_128441_("TransfurData")) {
            int ticks = playerData.m_128469_("TransfurData").m_128451_("SlowSwimInWaterTicks");
            if ((double)TransfurVariantUtils.GetSwimSpeed(ProcessTransfur.getPlayerTransfurVariant((Player)player).getParent(), player) > 0.95) {
                if (ticks != 0) {
                    playerData.m_128469_("TransfurData").m_128405_("SlowSwimInWaterTicks", 0);
                }
                return;
            }
            if (ticks == -1) {
                return;
            }
            if (player.m_6069_() && player.m_20072_()) {
                ++ticks;
            }
            if (ticks >= 600) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                Advancement _adv = sPlayer.f_8924_.m_129889_().m_136041_(ChangedAddonMod.resourceLoc("swim_regret"));
                AdvancementProgress _ap = sPlayer.m_8960_().m_135996_(_adv);
                if (!_ap.m_8193_()) {
                    for (String s : _ap.m_8219_()) {
                        sPlayer.m_8960_().m_135988_(_adv, s);
                    }
                }
                ticks = -1;
            }
            playerData.m_128469_("TransfurData").m_128405_("SlowSwimInWaterTicks", ticks);
        } else if ((double)TransfurVariantUtils.GetSwimSpeed(ProcessTransfur.getPlayerTransfurVariant((Player)player).getParent(), player) > 0.95) {
            if (playerData.m_128441_("TransfurData")) {
                playerData.m_128473_("TransfurData");
            }
        } else if (!playerData.m_128441_("TransfurData")) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("SlowSwimInWaterTicks", 0);
            playerData.m_128365_("TransfurData", (Tag)tag);
        }
    }
}

