/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.extension.jeiSuport;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.foxyas.changedaddon.block.AdvancedCatalyzerBlock;
import net.foxyas.changedaddon.block.AdvancedUnifuserBlock;
import net.foxyas.changedaddon.block.CatalyzerBlock;
import net.foxyas.changedaddon.block.UnifuserBlock;
import net.foxyas.changedaddon.enchantment.TransfurAspectEnchantment;
import net.foxyas.changedaddon.extension.jeiSuport.CatalyzerRecipeCategory;
import net.foxyas.changedaddon.extension.jeiSuport.UnifuserRecipeCategory;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonEnchantments;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.foxyas.changedaddon.recipes.CatalyzerRecipe;
import net.foxyas.changedaddon.recipes.UnifuserRecipe;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.init.ChangedItems;
import net.ltxprogrammer.changed.item.Syringe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ChangedAddonJeiPlugin
implements IModPlugin {
    public static RecipeType<CatalyzerRecipe> JeiCatalyzer_Type = new RecipeType(CatalyzerRecipeCategory.UID, CatalyzerRecipe.class);
    public static RecipeType<UnifuserRecipe> JeiUnifuser_Type = new RecipeType(UnifuserRecipeCategory.UID, UnifuserRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("changed_addon:jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CatalyzerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new UnifuserRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List catalyzerRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)CatalyzerRecipe.Type.INSTANCE);
        registration.addRecipes(JeiCatalyzer_Type, catalyzerRecipes);
        List unifuserRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)UnifuserRecipe.Type.INSTANCE);
        registration.addRecipes(JeiUnifuser_Type, unifuserRecipes);
        ChangedAddonJeiDescriptionHandler.registerDescriptions(registration);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((CatalyzerBlock)((Object)ChangedAddonBlocks.CATALYZER.get())).m_5456_()), new RecipeType[]{JeiCatalyzer_Type});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((AdvancedCatalyzerBlock)((Object)ChangedAddonBlocks.ADVANCED_CATALYZER.get())).m_5456_()), new RecipeType[]{JeiCatalyzer_Type});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((UnifuserBlock)((Object)ChangedAddonBlocks.UNIFUSER.get())).m_5456_()), new RecipeType[]{JeiUnifuser_Type});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((AdvancedUnifuserBlock)((Object)ChangedAddonBlocks.ADVANCED_UNIFUSER.get())).m_5456_()), new RecipeType[]{JeiUnifuser_Type});
    }

    public static class ChangedAddonJeiDescriptionHandler {
        public static void registerDescriptions(IRecipeRegistration registration) {
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)ChangedAddonItems.TRANSFUR_TOTEM.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("changed_addon.jei_descriptions.latex_totem")});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)ChangedAddonItems.EXPERIMENT_009_DNA.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("changed_addon.jei_descriptions.exp9_dna")});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)ChangedAddonItems.SYRINGE_WITH_LITIX_CAMMONIA.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("changed_addon.jei_descriptions.litix_cammonia_syringe")});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)ChangedAddonItems.LAETHIN_SYRINGE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("changed_addon.jei_descriptions.laethin_syringe")});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)ChangedAddonItems.POT_WITH_CAMONIA.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("changed_addon.jei_descriptions.pot_with_cammonia")});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)ChangedAddonItems.DIFFUSION_SYRINGE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("changed_addon.jei_descriptions.diffusion_syringe")});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)ChangedAddonItems.IRIDIUM.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("changed_addon.jei_descriptions.iridium_use")});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)ChangedAddonItems.INFORMANT_BLOCK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("changed_addon.jei_descriptions.informant_block")});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)ChangedAddonItems.LUNAR_ROSE_HELMET.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TextComponent(new TranslatableComponent("changed_addon.jei_descriptions.lunar_rose").getString().replace("#", "\n"))});
            ItemStack stack = new ItemStack((ItemLike)ChangedItems.LATEX_SYRINGE.get());
            Syringe.setVariant((ItemStack)stack, (ResourceLocation)((TransfurVariant)ChangedAddonTransfurVariants.LUMINARA_FLOWER_BEAST.get()).getFormId());
            registration.addIngredientInfo((Object)stack, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("changed_addon.jei_descriptions.luminara.riddle")});
            ChangedAddonJeiDescriptionHandler.addSharedDescriptions(registration, List.of((Item)ChangedAddonItems.BLUE_WOLF_CRYSTAL_FRAGMENT.get(), (Item)ChangedAddonItems.ORANGE_WOLF_CRYSTAL_FRAGMENT.get(), (Item)ChangedAddonItems.YELLOW_WOLF_CRYSTAL_FRAGMENT.get(), (Item)ChangedAddonItems.WHITE_WOLF_CRYSTAL_FRAGMENT.get()), "item.changed_addon.colorful_wolf_crystal_fragment_desc");
            ChangedAddonJeiDescriptionHandler.registerSolventDescriptions(registration);
            ChangedAddonJeiDescriptionHandler.registerChangedLureDescriptions(registration);
            ChangedAddonJeiDescriptionHandler.registerTransfurAspectDescriptions(registration);
        }

        private static void registerSolventDescriptions(IRecipeRegistration registration) {
            ItemStack enchantedBookWithSolvent = new ItemStack((ItemLike)Items.f_42690_);
            for (int i = 1; i < 6; ++i) {
                float math = ChangedAddonJeiDescriptionHandler.SolventMath(i) * 100.0f;
                EnchantmentHelper.m_44865_(Map.of((Enchantment)ChangedAddonEnchantments.SOLVENT.get(), i), (ItemStack)enchantedBookWithSolvent);
                String text = new TranslatableComponent("enchantment.changed_addon.solvent.jei_desc", new Object[]{Math.round(math)}).getString().replace(" T ", "% ");
                registration.addIngredientInfo((Object)enchantedBookWithSolvent, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TextComponent(text)});
            }
        }

        private static void registerTransfurAspectDescriptions(IRecipeRegistration registration) {
            ItemStack enchantedBookWithEnchantment = new ItemStack((ItemLike)Items.f_42690_);
            for (int i = 1; i < 6; ++i) {
                float math = ChangedAddonJeiDescriptionHandler.TransfurAspectMath(i);
                EnchantmentHelper.m_44865_(Map.of((Enchantment)ChangedAddonEnchantments.TRANSFUR_ASPECT.get(), i), (ItemStack)enchantedBookWithEnchantment);
                registration.addIngredientInfo((Object)enchantedBookWithEnchantment, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("enchantment.changed_addon.transfur_aspect.jei_desc", new Object[]{Float.valueOf(math)})});
            }
        }

        private static void registerChangedLureDescriptions(IRecipeRegistration registration) {
            ItemStack enchantedBookWithChangedLure = new ItemStack((ItemLike)Items.f_42690_);
            for (int i = 1; i < 6; ++i) {
                EnchantmentHelper.m_44865_(Map.of((Enchantment)ChangedAddonEnchantments.CHANGED_LURE.get(), i), (ItemStack)enchantedBookWithChangedLure);
                registration.addIngredientInfo((Object)enchantedBookWithChangedLure, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("enchantment.changed_addon.changed_lure.desc")});
            }
        }

        private static float SolventMath(int EnchantLevel) {
            return 1.0f + (float)EnchantLevel * 0.2f;
        }

        private static float TransfurAspectMath(int EnchantLevel) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                return TransfurAspectEnchantment.getTransfurDamage((LivingEntity)player, null, EnchantLevel);
            }
            return 0.0f;
        }

        private static void addSharedDescriptions(IRecipeRegistration registration, List<Item> items, String translationKey) {
            items.forEach(item -> registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent(translationKey)}));
        }
    }
}

