/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Consumer;
import net.foxyas.changedaddon.init.ChangedAddonAttributes;
import net.foxyas.changedaddon.init.ChangedAddonSoundEvents;
import net.foxyas.changedaddon.init.ChangedAddonTabs;
import net.foxyas.changedaddon.item.clothes.AccessoryItemExtension;
import net.ltxprogrammer.changed.data.AccessorySlotContext;
import net.ltxprogrammer.changed.data.AccessorySlotType;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedAccessorySlots;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.init.ChangedDamageSources;
import net.ltxprogrammer.changed.init.ChangedTabs;
import net.ltxprogrammer.changed.item.ClothingItem;
import net.ltxprogrammer.changed.item.ClothingState;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HazardBodySuit
extends ClothingItem
implements AccessoryItemExtension {
    public static final BooleanProperty HELMET = BooleanProperty.m_61465_((String)"helmet");

    public ClothingState defaultClothingState() {
        return (ClothingState)super.defaultClothingState().m_61124_((Property)HELMET, (Comparable)Boolean.valueOf(false));
    }

    public SoundEvent m_142602_() {
        return ChangedAddonSoundEvents.ARMOR_EQUIP;
    }

    public void accessoryInteract(AccessorySlotContext<?> slotContext) {
        super.accessoryInteract(slotContext);
        this.setClothingState(slotContext.stack(), (ClothingState)this.getClothingState(slotContext.stack()).m_61122_((Property)HELMET));
        SoundEvent changeSound = this.m_142602_();
        if (changeSound != null) {
            slotContext.wearer().m_5496_(changeSound, 1.0f, 1.0f);
        }
    }

    protected void createClothingStateDefinition(StateDefinition.Builder<ClothingItem, ClothingState> builder) {
        super.createClothingStateDefinition(builder);
        builder.m_61104_(new Property[]{HELMET});
    }

    protected void addInteractInstructions(Consumer<Component> builder) {
        builder.accept((Component)new TranslatableComponent(INTERACT_INSTRUCTIONS, new Object[]{Minecraft.m_91087_().f_91066_.f_92095_.m_90863_()}).m_130940_(ChatFormatting.GRAY));
    }

    protected boolean m_41389_(@NotNull CreativeModeTab tab) {
        if (tab == ChangedTabs.TAB_CHANGED_ITEMS) {
            return false;
        }
        if (tab == ChangedAddonTabs.TAB_CHANGED_ADDON) {
            return true;
        }
        return super.m_41389_(tab);
    }

    public int getMaxDamage(ItemStack stack) {
        return 525;
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public void accessoryDamaged(AccessorySlotContext<?> slotContext, DamageSource source, float amount) {
        boolean nonHurtFrame;
        LivingEntity wearer = slotContext.wearer();
        boolean bl = nonHurtFrame = wearer.f_20916_ <= 10 && wearer.f_19802_ <= 10;
        if (wearer.f_19864_ || !nonHurtFrame) {
            return;
        }
        if (!source.m_19376_() && !(source instanceof ChangedDamageSources.TransfurDamageSource)) {
            this.applyDamage(source, amount, slotContext);
        } else if (source instanceof ChangedDamageSources.TransfurDamageSource) {
            this.applyDamage(source, amount, slotContext);
        }
    }

    public SoundEvent getBreakSound(ItemStack itemStack) {
        return super.getBreakSound(itemStack);
    }

    @Override
    public boolean IsAffectedByMending(AccessorySlotType slotType, ItemStack itemStack) {
        return true;
    }

    public void applyDamage(DamageSource damageSource, float amount, AccessorySlotContext<?> slotContext) {
        if (!(amount <= 0.0f)) {
            if ((amount /= 4.0f) < 1.0f) {
                amount = 1.0f;
            }
            ItemStack itemStack = slotContext.stack();
            LivingEntity player = slotContext.wearer();
            if (!damageSource.m_19384_() || !itemStack.m_41720_().m_41475_()) {
                itemStack.m_41622_((int)amount, player, livingEntity -> {
                    if (!itemStack.m_41619_()) {
                        if (!livingEntity.m_20067_()) {
                            livingEntity.f_19853_.m_6269_(null, (Entity)livingEntity, this.getBreakSound(itemStack), livingEntity.m_5720_(), 0.8f, 0.8f + livingEntity.f_19853_.f_46441_.nextFloat() * 0.4f);
                        }
                        for (int i = 0; i < 5; ++i) {
                            Vec3 vec3 = new Vec3(((double)livingEntity.m_21187_().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                            vec3 = vec3.m_82496_(-livingEntity.m_146909_() * ((float)Math.PI / 180));
                            vec3 = vec3.m_82524_(-livingEntity.m_146908_() * ((float)Math.PI / 180));
                            double d0 = (double)(-livingEntity.m_21187_().nextFloat()) * 0.6 - 0.3;
                            Vec3 vec31 = new Vec3(((double)livingEntity.m_21187_().nextFloat() - 0.5) * 0.3, d0, 0.6);
                            vec31 = vec31.m_82496_(-livingEntity.m_146909_() * ((float)Math.PI / 180));
                            vec31 = vec31.m_82524_(-livingEntity.m_146908_() * ((float)Math.PI / 180));
                            vec31 = vec31.m_82520_(livingEntity.m_20185_(), livingEntity.m_20188_(), livingEntity.m_20189_());
                            Level patt7899$temp = livingEntity.f_19853_;
                            if (!(patt7899$temp instanceof ServerLevel)) continue;
                            ServerLevel serverLevel = (ServerLevel)patt7899$temp;
                            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.0);
                        }
                    }
                });
            }
        }
    }

    public boolean allowedInSlot(ItemStack itemStack, LivingEntity wearer, AccessorySlotType slot) {
        return slot == ChangedAccessorySlots.FULL_BODY.get();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.CHEST) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            Boolean helmeted = (Boolean)this.getClothingState(stack).m_61143_((Property)HELMET);
            float multiplier = helmeted != false ? 1.0f : 0.75f;
            builder.put((Object)((Attribute)ChangedAttributes.TRANSFUR_TOLERANCE.get()), (Object)new AttributeModifier(UUID.fromString("00000000-0000-0000-0000-000000000000"), "Hazard Transfur Tolerance Buff", (double)multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            builder.put((Object)((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get()), (Object)new AttributeModifier(UUID.fromString("00000000-0000-0000-0000-000000000000"), "Hazard Transfur Tolerance Buff", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            builder.put((Object)((Attribute)ChangedAddonAttributes.LATEX_RESISTANCE.get()), (Object)new AttributeModifier(UUID.fromString("00000000-0000-0000-0000-000000000001"), "Hazard Armor Speed Debuff", 0.05 * (double)multiplier, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(UUID.fromString("00000000-0000-0000-0000-000000000002"), "Hazard Armor Buff", (double)(2.0f * multiplier), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("00000000-0000-0000-0000-000000000003"), "Hazard Armor Speed Debuff", -0.05, AttributeModifier.Operation.MULTIPLY_TOTAL));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("00000000-0000-0000-0000-000000000004"), "Hazard Armor Attack Speed Debuff", -0.09, AttributeModifier.Operation.MULTIPLY_TOTAL));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public String getHelmetState(ItemStack stack) {
        Boolean flag = (Boolean)this.getClothingState(stack).m_61143_((Property)HELMET);
        return flag != false ? "helmeted" : "no_helmet";
    }

    private <T extends Entity> String getPlayerModelStyle(T entity) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            return player.m_108564_();
        }
        return "default";
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        Player player;
        TransfurVariantInstance transfurVariant;
        if (entity instanceof ChangedEntity) {
            ResourceLocation itemId = stack.m_41720_().getRegistryName();
            return String.format("%s:textures/models/hazard_suit/%s_%s_tf.png", itemId.m_135827_(), itemId.m_135815_(), this.getHelmetState(stack));
        }
        if (entity instanceof Player && (transfurVariant = ProcessTransfur.getPlayerTransfurVariant((Player)(player = (Player)entity))) != null && transfurVariant.isTransfurring()) {
            ResourceLocation itemId = stack.m_41720_().getRegistryName();
            return String.format("%s:textures/models/hazard_suit/%s_%s_tf.png", itemId.m_135827_(), itemId.m_135815_(), this.getHelmetState(stack));
        }
        ResourceLocation itemId = stack.m_41720_().getRegistryName();
        return String.format("%s:textures/models/hazard_suit/%s_%s_%s.png", itemId.m_135827_(), itemId.m_135815_(), this.getHelmetState(stack), this.getPlayerModelStyle(entity));
    }
}

