/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.item.armor;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.foxyas.changedaddon.client.model.ModelHazardArmorCustomArms;
import net.foxyas.changedaddon.init.ChangedAddonTabs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class HazardSuitItem
extends ArmorItem {
    public HazardSuitItem(EquipmentSlot slot, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_7366_(@NotNull EquipmentSlot slot) {
                return (new int[]{13, 15, 16, 11})[slot.m_20749_()] * 25;
            }

            public int m_7365_(@NotNull EquipmentSlot slot) {
                return (new int[]{1, 4, 5, 1})[slot.m_20749_()];
            }

            public int m_6646_() {
                return 9;
            }

            @NotNull
            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("changed_addon:armor_equip"));
            }

            @NotNull
            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42454_), new ItemStack((ItemLike)Items.f_42416_)});
            }

            @NotNull
            public String m_6082_() {
                return "hazard_suit";
            }

            public float m_6651_() {
                return 0.0f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, slot, properties);
    }

    public static class Boots
    extends HazardSuitItem {
        public Boots() {
            super(EquipmentSlot.FEET, new Item.Properties().m_41491_(ChangedAddonTabs.TAB_CHANGED_ADDON));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "changed_addon:textures/models/armor/hazard_armor__layer_1.png";
        }
    }

    public static class Leggings
    extends HazardSuitItem {
        public Leggings() {
            super(EquipmentSlot.LEGS, new Item.Properties().m_41491_(ChangedAddonTabs.TAB_CHANGED_ADDON));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "changed_addon:textures/entities/hazardarmor_legs.png";
        }
    }

    public static class Chestplate
    extends HazardSuitItem {
        public Chestplate() {
            super(EquipmentSlot.CHEST, new Item.Properties().m_41491_(ChangedAddonTabs.TAB_CHANGED_ADDON));
        }

        public void initializeClient(Consumer<IItemRenderProperties> consumer) {
            consumer.accept(new IItemRenderProperties(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new ModelHazardArmorCustomArms<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelHazardArmorCustomArms.LAYER_LOCATION)).body, "left_arm", new ModelHazardArmorCustomArms<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelHazardArmorCustomArms.LAYER_LOCATION)).left_arm, "right_arm", new ModelHazardArmorCustomArms<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelHazardArmorCustomArms.LAYER_LOCATION)).right_arm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "changed_addon:textures/models/armor/hazard_armor__layer_1.png";
        }
    }

    public static class Helmet
    extends HazardSuitItem {
        public Helmet() {
            super(EquipmentSlot.HEAD, new Item.Properties().m_41491_(ChangedAddonTabs.TAB_CHANGED_ADDON));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "changed_addon:textures/models/armor/hazard_armor__layer_1.png";
        }
    }
}

