/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.mixins.abilities;

import java.util.List;
import javax.annotation.Nullable;
import net.foxyas.changedaddon.abilities.interfaces.GrabEntityAbilityExtensor;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.GrabEntityAbilityInstance;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.TransfurContext;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GrabEntityAbilityInstance.class}, remap=false)
public class GrabEntityAbilityInstanceMixin
implements GrabEntityAbilityExtensor {
    @Shadow
    public boolean attackDown;
    @Shadow
    public boolean suited;
    @Shadow
    @Nullable
    public LivingEntity grabbedEntity;
    @Shadow
    public boolean useDown;
    @Shadow
    public float suitTransition;
    @Shadow
    public float grabStrength;
    @Shadow
    int instructionTicks;
    @Shadow
    public float suitTransitionO;
    @Unique
    private boolean safeMode = false;
    @Unique
    private int snuggleCooldown = 0;
    @Unique
    private boolean alreadySnuggledTight = false;

    @Inject(method={"saveData"}, at={@At(value="TAIL")}, cancellable=true)
    public void injectCustomData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("safeMode", this.safeMode);
        tag.m_128379_("alreadySnuggledTight", this.alreadySnuggledTight);
    }

    @Inject(method={"readData"}, at={@At(value="TAIL")}, cancellable=true)
    public void readCustomData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("safeMode")) {
            this.safeMode = tag.m_128471_("safeMode");
        }
        if (tag.m_128441_("alreadySnuggledTight")) {
            this.alreadySnuggledTight = tag.m_128471_("alreadySnuggledTight");
        }
    }

    @Override
    public boolean isSafeMode() {
        return this.safeMode;
    }

    @Override
    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    @Unique
    public GrabEntityAbilityInstance getSelf() {
        return (GrabEntityAbilityInstance)this;
    }

    @Override
    public LivingEntity grabber() {
        return this.getSelf().entity.getEntity();
    }

    @Redirect(method={"tickIdle"}, at=@At(value="INVOKE", target="Lnet/ltxprogrammer/changed/entity/ChangedEntity;tryAbsorbTarget(Lnet/minecraft/world/entity/LivingEntity;Lnet/ltxprogrammer/changed/ability/IAbstractChangedEntity;FLjava/util/List;)Z"))
    private boolean changedaddon$customAbsorb(ChangedEntity instance, LivingEntity target, IAbstractChangedEntity loserPlayer, float amount, @Nullable List<TransfurVariant<?>> possibleMobFusions) {
        GrabEntityAbilityInstance selfThis = (GrabEntityAbilityInstance)this;
        AttributeInstance attribute = instance.maybeGetUnderlying().m_21051_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get());
        if (attribute == null) {
            return instance.tryAbsorbTarget(this.grabbedEntity, selfThis.entity, amount, possibleMobFusions);
        }
        double attributeValue = attribute.m_22135_();
        float dmg = Mth.m_14167_((float)((float)attributeValue * 1.33f));
        boolean result = instance.tryAbsorbTarget(this.grabbedEntity, selfThis.entity, dmg, possibleMobFusions);
        return result;
    }

    @Inject(method={"tickIdle"}, at={@At(value="INVOKE", target="Ljava/lang/Math;max(FF)F", remap=true, shift=At.Shift.AFTER)}, cancellable=true)
    public void cancelSuitDmg(CallbackInfo ci) {
        if (this.isSafeMode()) {
            if (this.snuggleCooldown > 0) {
                --this.snuggleCooldown;
            }
            if (this.suitTransition >= 3.0f) {
                ci.cancel();
                LivingEntity livingEntity = this.grabbedEntity;
                if (!(livingEntity instanceof Player)) {
                    this.grabStrength = 1.0f;
                    if (this.getSelf().getController().getHoldTicks() >= 1) {
                        this.suitTransition -= 0.25f;
                    }
                    if (this.grabbedEntity != null && !this.isAlreadySnuggledTight()) {
                        this.runTightHug(this.grabbedEntity);
                    }
                } else {
                    Player player = (Player)livingEntity;
                    if (!this.isAlreadySnuggledTight()) {
                        this.runTightHug((LivingEntity)player);
                    }
                }
            } else {
                this.alreadySnuggledTight = false;
            }
        }
    }

    @Override
    public boolean isAlreadySnuggled() {
        return this.snuggleCooldown > 0;
    }

    @Override
    public void setSnuggled(boolean value) {
        this.snuggleCooldown = value ? 20 : 0;
    }

    @Override
    public boolean isAlreadySnuggledTight() {
        return this.alreadySnuggledTight;
    }

    @Override
    public void setSnuggledTight(boolean value) {
        this.alreadySnuggledTight = value;
    }

    @Inject(method={"handleInstructions"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleSafeModeInstructions(Level level, CallbackInfo ci) {
        if (level.m_5776_() && this.isSafeMode()) {
            ci.cancel();
            if (this.instructionTicks == 180) {
                this.getSelf().entity.displayClientMessage((Component)new TranslatableComponent("ability.changed_addon.grab_entity.extender.how_to_release", new Object[]{AbstractAbilityInstance.KeyReference.ABILITY.getName(level)}), true);
            } else if (this.instructionTicks == 120) {
                this.getSelf().entity.displayClientMessage((Component)new TranslatableComponent("ability.changed_addon.grab_entity.extender.how_to_hug", new Object[]{AbstractAbilityInstance.KeyReference.ATTACK.getName(level)}), true);
            } else if (this.instructionTicks == 60) {
                this.getSelf().entity.displayClientMessage((Component)new TranslatableComponent("ability.changed_addon.grab_entity.extender.how_to_hug.tightly", new Object[]{AbstractAbilityInstance.KeyReference.USE.getName(level)}), true);
            }
            if (this.instructionTicks > 0) {
                --this.instructionTicks;
            }
            if (this.instructionTicks < 0) {
                ++this.instructionTicks;
            }
        }
    }

    @Redirect(method={"tickIdle"}, at=@At(value="INVOKE", target="Lnet/ltxprogrammer/changed/process/ProcessTransfur;progressTransfur(Lnet/minecraft/world/entity/LivingEntity;FLnet/ltxprogrammer/changed/entity/variant/TransfurVariant;Lnet/ltxprogrammer/changed/entity/TransfurContext;)Z"))
    private boolean changedAddon$disableProgressTransfur(LivingEntity grabbedEntity, float damage, TransfurVariant variant, TransfurContext ctx) {
        if (this.safeMode) {
            if (!this.isAlreadySnuggled()) {
                this.runHug(grabbedEntity);
            }
            return false;
        }
        return ProcessTransfur.progressTransfur((LivingEntity)grabbedEntity, (float)damage, (TransfurVariant)variant, (TransfurContext)ctx);
    }
}

