/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.mixins.entity.variant;

import net.foxyas.changedaddon.item.armor.DarkLatexCoatItem;
import net.foxyas.changedaddon.item.armor.HazmatSuitItem;
import net.foxyas.changedaddon.variants.VariantExtraStats;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TransfurVariantInstance.class}, remap=false)
public abstract class TransfurVariantInstanceMixin {
    @Shadow
    @Final
    protected TransfurVariant<ChangedEntity> parent;
    @Shadow
    @Final
    private Player host;
    private boolean appliedFlySpeed;
    @Shadow
    public int ticksFlying;

    @Shadow
    public abstract TransfurVariant<?> getParent();

    @Shadow
    public abstract boolean shouldApplyAbilities();

    @Shadow
    public abstract ChangedEntity getChangedEntity();

    @Inject(method={"canWear"}, at={@At(value="HEAD")}, cancellable=true)
    private void negateArmor(Player player, ItemStack itemStack, EquipmentSlot slot, CallbackInfoReturnable<Boolean> cir) {
        if ((itemStack.m_41720_() instanceof HazmatSuitItem || itemStack.m_41720_() instanceof DarkLatexCoatItem) && slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tickFlying"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;getFoodLevel()I", remap=true, ordinal=0)}, cancellable=true)
    private void negateFly(CallbackInfo cir) {
        VariantExtraStats variantExtraStats;
        ChangedEntity changedEntity;
        if (!this.host.m_7500_() && !this.host.m_5833_() && (changedEntity = this.getChangedEntity()) instanceof VariantExtraStats && !(variantExtraStats = (VariantExtraStats)changedEntity).getFlyType().canFly()) {
            if (this.host.m_150110_().f_35935_ || this.host.m_150110_().f_35936_) {
                this.host.m_150110_().f_35936_ = false;
                this.host.m_150110_().f_35935_ = false;
                this.host.m_6885_();
            }
            this.ticksFlying = 0;
            cir.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void negateFlyInTick(CallbackInfo cir) {
        if (this.parent.canGlide && this.shouldApplyAbilities()) {
            VariantExtraStats variantExtraStats;
            ChangedEntity changedEntity;
            if (!this.host.m_7500_() && !this.host.m_5833_() && (changedEntity = this.getChangedEntity()) instanceof VariantExtraStats && !(variantExtraStats = (VariantExtraStats)changedEntity).getFlyType().canFly() && (this.host.m_150110_().f_35935_ || this.host.m_150110_().f_35936_)) {
                this.host.m_150110_().f_35936_ = false;
                this.host.m_150110_().f_35935_ = false;
                this.host.m_6885_();
            }
            if (!this.host.m_5833_() && (changedEntity = this.getChangedEntity()) instanceof VariantExtraStats && (variantExtraStats = (VariantExtraStats)changedEntity).getFlySpeed() != 0.0f && variantExtraStats.getFlyType().canFly() && !this.appliedFlySpeed) {
                this.appliedFlySpeed = true;
                this.host.m_150110_().m_35943_(variantExtraStats.getFlySpeed());
                this.host.m_6885_();
            }
        }
    }

    @Inject(method={"unhookAll"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectUnHookALl(Player player, CallbackInfo ci) {
        ChangedEntity changedEntity = this.getChangedEntity();
        if (changedEntity instanceof VariantExtraStats) {
            VariantExtraStats stats = (VariantExtraStats)changedEntity;
            if (this.appliedFlySpeed) {
                this.appliedFlySpeed = false;
                this.host.m_150110_().m_35943_(0.05f);
                this.host.m_6885_();
            }
        }
    }

    @Inject(method={"save"}, at={@At(value="RETURN")}, cancellable=true)
    private void InjectData(CallbackInfoReturnable<CompoundTag> cir) {
        ChangedEntity changedEntity = this.getChangedEntity();
        if (changedEntity instanceof VariantExtraStats) {
            VariantExtraStats stats = (VariantExtraStats)changedEntity;
            stats.saveExtraData((CompoundTag)cir.getReturnValue());
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")}, cancellable=true)
    private void readInjectedData(CompoundTag tag, CallbackInfo cir) {
        ChangedEntity changedEntity = this.getChangedEntity();
        if (changedEntity instanceof VariantExtraStats) {
            VariantExtraStats variantExtraStats = (VariantExtraStats)changedEntity;
            variantExtraStats.readExtraData(tag);
        }
    }
}

