/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.network;

import java.util.function.Supplier;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.foxyas.changedaddon.qte.FightToKeepConsciousness;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangedAddonModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_(message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.setPacketHandled(true);
            if (context.getDirection().getReceptionSide().isServer()) {
                return;
            }
            context.enqueueWork(() -> {
                assert (Minecraft.m_91087_().f_91074_ != null);
                PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                variables.showWarns = message.data.showWarns;
                variables.consciousnessFightProgress = message.data.consciousnessFightProgress;
                variables.FTKCminigameType = message.data.FTKCminigameType;
                variables.resetTransfurAdvancements = message.data.resetTransfurAdvancements;
                variables.actCooldown = message.data.actCooldown;
                variables.areDarkLatex = message.data.areDarkLatex;
                variables.LatexInfectionCooldown = message.data.LatexInfectionCooldown;
                variables.untransfurProgress = message.data.untransfurProgress;
                variables.Exp009TransfurAllowed = message.data.Exp009TransfurAllowed;
                variables.Exp10TransfurAllowed = message.data.Exp10TransfurAllowed;
            });
        }
    }

    public static class PlayerVariables {
        @Nullable
        public FightToKeepConsciousness.MinigameType FTKCminigameType = null;
        public float consciousnessFightProgress = 0.0f;
        public double LatexInfectionCooldown = 0.0;
        public double untransfurProgress = 0.0;
        public boolean showWarns = true;
        public boolean resetTransfurAdvancements = false;
        public boolean actCooldown = false;
        public boolean areDarkLatex = false;
        public boolean Exp009TransfurAllowed = false;
        public boolean Exp10TransfurAllowed = false;

        @Nullable
        public static PlayerVariables of(@NotNull Player player) {
            return player.getCapability(PLAYER_VARIABLES_CAPABILITY).resolve().orElse(null);
        }

        @NotNull
        public static PlayerVariables ofOrDefault(@NotNull Player player) {
            return player.getCapability(PLAYER_VARIABLES_CAPABILITY).resolve().orElseGet(PlayerVariables::new);
        }

        @NotNull
        public static PlayerVariables nonNullOf(@NotNull Player player) {
            return (PlayerVariables)player.getCapability(PLAYER_VARIABLES_CAPABILITY).orElseThrow(() -> new IllegalStateException("Player Variables Capability expected but not found!"));
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ChangedAddonMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public void copyTo(PlayerVariables other, boolean wasDeath) {
            other.resetTransfurAdvancements = this.resetTransfurAdvancements;
            other.areDarkLatex = this.areDarkLatex;
            other.untransfurProgress = this.untransfurProgress;
            other.Exp009TransfurAllowed = this.Exp009TransfurAllowed;
            other.Exp10TransfurAllowed = this.Exp10TransfurAllowed;
            if (!wasDeath) {
                other.consciousnessFightProgress = this.consciousnessFightProgress;
                other.FTKCminigameType = this.FTKCminigameType;
                other.actCooldown = this.actCooldown;
                other.LatexInfectionCooldown = this.LatexInfectionCooldown;
            }
        }

        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("showWarns", this.showWarns);
            nbt.m_128350_("consciousnessFightProgress", this.consciousnessFightProgress);
            nbt.m_128344_("FTKCminigameType", this.FTKCminigameType != null ? (byte)this.FTKCminigameType.ordinal() : (byte)-1);
            nbt.m_128379_("resetTransfurAdvancements", this.resetTransfurAdvancements);
            nbt.m_128379_("actCooldown", this.actCooldown);
            nbt.m_128379_("areDarkLatex", this.areDarkLatex);
            nbt.m_128347_("LatexInfectionCooldown", this.LatexInfectionCooldown);
            nbt.m_128347_("UntransfurProgress", this.untransfurProgress);
            nbt.m_128379_("Exp009TransfurAllowed", this.Exp009TransfurAllowed);
            nbt.m_128379_("Exp10TransfurAllowed", this.Exp10TransfurAllowed);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.showWarns = nbt.m_128471_("showWarns");
            this.consciousnessFightProgress = nbt.m_128457_("consciousnessFightProgress");
            this.FTKCminigameType = nbt.m_128441_("FTKCminigameType") ? (nbt.m_128445_("FTKCminigameType") != -1 ? FightToKeepConsciousness.MinigameType.values()[nbt.m_128445_("FTKCminigameType")] : null) : null;
            this.resetTransfurAdvancements = nbt.m_128471_("resetTransfurAdvancements");
            this.actCooldown = nbt.m_128471_("actCooldown");
            this.areDarkLatex = nbt.m_128471_("areDarkLatex");
            this.LatexInfectionCooldown = nbt.m_128459_("LatexInfectionCooldown");
            this.untransfurProgress = nbt.m_128459_("UntransfurProgress");
            this.Exp009TransfurAllowed = nbt.m_128471_("Exp009TransfurAllowed");
            this.Exp10TransfurAllowed = nbt.m_128471_("Exp10TransfurAllowed");
        }
    }

    @Mod.EventBusSubscriber
    public static class PlayerVariablesProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            Player player;
            Object object = event.getObject();
            if (object instanceof Player && !((player = (Player)object) instanceof FakePlayer)) {
                event.addCapability(ChangedAddonMod.resourceLoc("player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.playerVariables.readNBT((Tag)nbt);
        }
    }
}

