/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.network;

import java.util.function.Supplier;
import net.foxyas.changedaddon.entity.mobs.FoxyasEntity;
import net.foxyas.changedaddon.world.inventory.FoxyasGui2Menu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public record FoxyasGuiButtonMessage(int buttonId, int entityId) {
    public FoxyasGuiButtonMessage(FriendlyByteBuf buf) {
        this(buf.m_130242_(), buf.m_130242_());
    }

    public static void buffer(FoxyasGuiButtonMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.buttonId);
        buf.m_130130_(message.entityId);
    }

    public static void handler(FoxyasGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            Entity entity = player.f_19853_.m_6815_(message.entityId);
            if (!(entity instanceof FoxyasEntity)) {
                return;
            }
            FoxyasEntity foxyas = (FoxyasEntity)entity;
            FoxyasGuiButtonMessage.handleButtonAction((Player)player, message.buttonId, foxyas);
        });
        context.setPacketHandled(true);
    }

    static void handleButtonAction(Player player, int buttonID, final FoxyasEntity entity) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        if (!entity.isAddedToWorld()) {
            return;
        }
        if (buttonID == 0) {
            entity.doTrade();
            return;
        }
        if (buttonID == 1) {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sPlayer = (ServerPlayer)player;
            NetworkHooks.openGui((ServerPlayer)sPlayer, (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return new TextComponent("FoxyasGui2");
                }

                public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
                    return new FoxyasGui2Menu(id, inventory, entity);
                }
            }, buf -> buf.m_130130_(entity.m_142049_()));
        }
    }
}

