/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.network.packets;

import java.util.function.Supplier;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.foxyas.changedaddon.entity.interfaces.SyncTrackMotion;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ConfirmMovementPacket {
    public static final ResourceLocation ID = ChangedAddonMod.resourceLoc("confirm_movement");
    private final boolean isMoving;
    private Vec3 motion = null;

    public ConfirmMovementPacket(boolean isMoving) {
        this.isMoving = isMoving;
    }

    public ConfirmMovementPacket(boolean isMoving, Vec3 motion) {
        this.isMoving = isMoving;
        this.motion = motion;
    }

    public static void encode(ConfirmMovementPacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.isMoving);
        if (msg.motion != Vec3.f_82478_ && msg.motion != null) {
            Vec3 motion = msg.motion;
            buf.writeDouble(motion.m_7096_());
            buf.writeDouble(motion.m_7098_());
            buf.writeDouble(motion.m_7094_());
        }
    }

    public static ConfirmMovementPacket decode(FriendlyByteBuf buf) {
        try {
            boolean isMoving = buf.readBoolean();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            Vec3 vec = new Vec3(x, y, z);
            return new ConfirmMovementPacket(isMoving, vec);
        }
        catch (Exception ignored) {
            return new ConfirmMovementPacket(buf.readBoolean());
        }
    }

    public static void handle(ConfirmMovementPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                boolean isMoving = msg.isMoving;
                if (sender instanceof SyncTrackMotion) {
                    SyncTrackMotion syncTrackMotion = (SyncTrackMotion)sender;
                    syncTrackMotion.setIsMoving(isMoving);
                    if (msg.motion != Vec3.f_82478_ && msg.motion != null) {
                        syncTrackMotion.setLastKnownMotion(msg.motion);
                    }
                    if (syncTrackMotion.getLastKnownMotion() != null) {
                        sender.m_6352_((Component)new TextComponent("Client motion is: " + syncTrackMotion.getLastKnownMotion()), sender.m_142081_());
                    }
                    sender.m_6352_((Component)new TextComponent("Client is moving: " + syncTrackMotion.isMoving()), sender.m_142081_());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

