/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.foxyas.changedaddon.process.variantsExtraStats.visions.ClientTransfurVisionRegistry;
import net.foxyas.changedaddon.process.variantsExtraStats.visions.TransfurVariantVision;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class SyncTransfurVisionsPacket {
    private final List<TransfurVariantVision> visions;

    public SyncTransfurVisionsPacket(List<TransfurVariantVision> visions) {
        this.visions = visions;
    }

    public static void encode(SyncTransfurVisionsPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.visions.size());
        for (TransfurVariantVision v : msg.visions) {
            buf.m_130085_(v.form());
            buf.m_130085_(v.visionEffect());
        }
    }

    public static SyncTransfurVisionsPacket decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<TransfurVariantVision> list = new ArrayList<TransfurVariantVision>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation form = buf.m_130281_();
            ResourceLocation effect = buf.m_130281_();
            list.add(new TransfurVariantVision(effect, form));
        }
        return new SyncTransfurVisionsPacket(list);
    }

    public static void handle(SyncTransfurVisionsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientTransfurVisionRegistry.clear();
            for (TransfurVariantVision v : msg.visions) {
                ClientTransfurVisionRegistry.register(v);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

