/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.procedures;

import net.foxyas.changedaddon.entity.advanced.LatexSnepEntity;
import net.foxyas.changedaddon.entity.defaults.AbstractCanTameSnepChangedEntity;
import net.foxyas.changedaddon.item.armor.HazmatSuitItem;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.TamableLatexEntity;
import net.ltxprogrammer.changed.entity.beast.DarkLatexWolfPup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EquipArmorInEntityProcedure {
    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (event.getPlayer().m_6144_() && (entity = event.getTarget()) instanceof ChangedEntity) {
            AbstractCanTameSnepChangedEntity snepChanged;
            ChangedEntity changedEntity = (ChangedEntity)entity;
            ItemStack itemStack = event.getItemStack();
            if (changedEntity instanceof DarkLatexWolfPup || changedEntity instanceof LatexSnepEntity || changedEntity instanceof AbstractCanTameSnepChangedEntity && !(snepChanged = (AbstractCanTameSnepChangedEntity)changedEntity).isBiped()) {
                return;
            }
            if (changedEntity instanceof TamableLatexEntity) {
                TamableLatexEntity tamableLatexEntity = (TamableLatexEntity)changedEntity;
                if (tamableLatexEntity.m_142480_() != event.getPlayer()) {
                    return;
                }
                if (!event.getPlayer().m_6144_()) {
                    return;
                }
                event.setCancellationResult(InteractionResult.PASS);
                Item item = itemStack.m_41720_();
                if (item instanceof ArmorItem) {
                    ArmorItem armorItem = (ArmorItem)item;
                    if (armorItem instanceof HazmatSuitItem) {
                        return;
                    }
                    if (!event.getWorld().m_5776_()) {
                        EquipArmorInEntityProcedure.equipOrSwapArmor(event, changedEntity, itemStack, armorItem, event.getPlayer(), event.getHand());
                    }
                } else if (itemStack.m_41619_() && event.getHand() == InteractionHand.MAIN_HAND && !event.getWorld().m_5776_()) {
                    EquipArmorInEntityProcedure.checkClickLocationAndUnequipArmor(event, changedEntity, event.getPlayer(), event.getHand(), EquipArmorInEntityProcedure.getLocationFromHit(event.getPlayer()));
                }
            }
        }
    }

    public static void equipOrSwapArmor(PlayerInteractEvent.EntityInteract event, ChangedEntity entity, ItemStack itemStack, ArmorItem armorItem, Player player, InteractionHand hand) {
        TamableLatexEntity ChangedEntity2;
        if (entity instanceof TamableLatexEntity && (ChangedEntity2 = (TamableLatexEntity)entity).m_142480_() != null && ChangedEntity2.m_142480_() == player) {
            EquipmentSlot armorSlot = armorItem.m_40402_();
            ItemStack currentArmor = entity.m_6844_(armorSlot);
            if (!currentArmor.m_41619_() && !currentArmor.m_41720_().equals(armorItem)) {
                EquipArmorInEntityProcedure.swapArmor(event, entity, player, hand, armorSlot, currentArmor, itemStack, armorItem);
            } else if (entity.m_6844_(armorSlot).m_41619_() && itemStack.canEquip(armorSlot, (Entity)entity)) {
                EquipArmorInEntityProcedure.equipArmor(event, entity, player, hand, itemStack, armorSlot, armorItem);
            }
        }
    }

    private static void swapArmor(PlayerInteractEvent.EntityInteract event, ChangedEntity entity, Player player, InteractionHand hand, EquipmentSlot armorSlot, ItemStack currentArmor, ItemStack newArmor, ArmorItem armorItemStack) {
        entity.m_8061_(armorSlot, ItemStack.f_41583_);
        EquipArmorInEntityProcedure.equipArmor(event, entity, player, hand, newArmor, armorSlot, armorItemStack);
        if (player.m_21120_(hand).m_41619_()) {
            player.m_6674_(hand);
            player.m_21008_(hand, currentArmor);
            event.setCanceled(true);
        } else {
            if (!player.m_150109_().m_36054_(currentArmor)) {
                player.m_36176_(currentArmor, false);
            }
            event.setCanceled(true);
        }
    }

    private static void equipArmor(PlayerInteractEvent.EntityInteract event, ChangedEntity entity, Player player, InteractionHand hand, ItemStack itemStack, EquipmentSlot armorSlot, ArmorItem armorItemStack) {
        event.setCanceled(true);
        entity.m_8061_(armorSlot, itemStack.m_41620_(1));
        if (armorItemStack.m_142602_() != null) {
            entity.f_19853_.m_5594_(null, entity.m_142538_(), armorItemStack.m_142602_(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            entity.f_19853_.m_5594_(null, entity.m_142538_(), SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (!player.f_19853_.m_5776_()) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                player.m_6674_(hand);
            } else {
                player.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                player.m_6674_(hand);
            }
        }
    }

    private static void checkClickLocationAndUnequipArmor(PlayerInteractEvent.EntityInteract event, ChangedEntity entity, Player player, InteractionHand hand, Vec3 clickPos) {
        ItemStack currentArmor;
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 playerLook = player.m_20252_(1.0f);
        Vec3 entityPosition = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 toEntity = entityPosition.m_82546_(eyePosition);
        Vec3 normalizedPlayerLook = playerLook.m_82541_();
        double dotProduct = toEntity.m_82541_().m_82526_(normalizedPlayerLook);
        double distance = toEntity.m_82553_();
        double yRelative = clickPos.f_82480_;
        EquipmentSlot clickedSlot = EquipArmorInEntityProcedure.determineArmorSlot(yRelative, (Entity)entity, player);
        if (clickedSlot != null && !(currentArmor = entity.m_6844_(clickedSlot)).m_41619_()) {
            entity.m_8061_(clickedSlot, ItemStack.f_41583_);
            entity.f_19853_.m_5594_(null, entity.m_142538_(), SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (player.m_21120_(hand).m_41619_()) {
                player.m_21008_(hand, currentArmor);
                event.setCanceled(true);
            } else {
                if (!player.m_150109_().m_36054_(currentArmor)) {
                    player.m_36176_(currentArmor, false);
                }
                event.setCanceled(true);
            }
        }
    }

    private static Vec3 getLocationFromHit(Player player) {
        HitResult hitResult = player.m_19907_(5.0, 1.0f, false);
        Vec3 hitPosition = hitResult.m_82450_();
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            hitPosition = entityHitResult.m_82450_();
        }
        return hitPosition;
    }

    private static EquipmentSlot determineArmorSlot(double yClick, Entity entity, Player player) {
        double entityHeight = entity.m_20186_();
        Vec3 EntityPos = new Vec3(0.0, entityHeight, 0.0);
        Vec3 ClickPos = new Vec3(0.0, yClick, 0.0);
        double distance = EntityPos.m_82554_(ClickPos);
        double relativeHeight = yClick / entityHeight;
        if (distance >= 2.1) {
            return EquipmentSlot.HEAD;
        }
        if (distance > 1.0) {
            return EquipmentSlot.CHEST;
        }
        if (distance > 0.0) {
            return EquipmentSlot.LEGS;
        }
        return EquipmentSlot.FEET;
    }
}

