/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.procedures;

import com.mojang.blaze3d.shaders.FogShape;
import javax.annotation.Nullable;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class Experiment009FogComputationProcedure {
    @SubscribeEvent
    public static void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.getMode() == FogRenderer.FogMode.FOG_TERRAIN) {
            try {
                ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
                Entity entity = event.getCamera().m_90592_();
                if (entity != null && clientLevel != null) {
                    Experiment009FogComputationProcedure.applyFogEffect((LevelAccessor)clientLevel, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity, (EntityViewRenderEvent)event);
                    event.setCanceled(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void applyFogEffect(LevelAccessor world, double x, double y, double z, Entity entity, EntityViewRenderEvent viewport) {
        Experiment009FogComputationProcedure.applyFogEffect(null, world, x, y, z, entity, viewport);
    }

    private static void applyFogEffect(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity, EntityViewRenderEvent viewport) {
        if (entity == null || !(viewport instanceof EntityViewRenderEvent.RenderFogEvent)) {
            return;
        }
        EntityViewRenderEvent.RenderFogEvent fogEvent = (EntityViewRenderEvent.RenderFogEvent)viewport;
        if (Experiment009FogComputationProcedure.isCreativeOrSpectator(entity)) {
            return;
        }
        if (Experiment009FogComputationProcedure.isHoldingItem(entity, (Item)ChangedAddonItems.EXPERIMENT_009_DNA.get()) || Experiment009FogComputationProcedure.isHoldingItem(entity, (Item)ChangedAddonItems.EXPERIMENT_10_DNA.get())) {
            fogEvent.setFogShape(FogShape.SPHERE);
            fogEvent.setNearPlaneDistance(1.0f);
            fogEvent.setFarPlaneDistance(10.0f);
        }
    }

    private static boolean isCreativeOrSpectator(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            GameType mode = serverPlayer.f_8941_.m_9290_();
            return mode == GameType.CREATIVE || mode == GameType.SPECTATOR;
        }
        if (entity.f_19853_.m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            PlayerInfo info = Minecraft.m_91087_().m_91403_().m_104949_(player.m_36316_().getId());
            if (info != null) {
                GameType mode = info.m_105325_();
                return mode == GameType.CREATIVE || mode == GameType.SPECTATOR;
            }
        }
        return false;
    }

    private static boolean isHoldingItem(Entity entity, Item item) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return livingEntity.m_21205_().m_41720_() == item || livingEntity.m_21206_().m_41720_() == item;
    }
}

