/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.procedures;

import net.foxyas.changedaddon.entity.bosses.Experiment009BossEntity;
import net.foxyas.changedaddon.entity.bosses.Experiment10BossEntity;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class Experiment10FogColorProcessProcedure {
    private static final float[] COLOR_10 = new float[]{0.23921569f, 0.0f, 0.0f};
    private static final float[] COLOR_009 = new float[]{0.0f, 0.7607843f, 0.85882354f};
    private static final float[] COLOR_MIX = new float[]{0.49411765f, 0.0f, 0.8509804f};

    @SubscribeEvent
    public static void computeFogColor(EntityViewRenderEvent.FogColors event) {
        try {
            ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
            Entity entity = event.getCamera().m_90592_();
            if (entity != null) {
                Experiment10FogColorProcessProcedure.applyFogColor((LevelAccessor)clientLevel, entity.m_20182_(), entity, event);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyFogColor(LevelAccessor world, Vec3 pos, Entity entity, EntityViewRenderEvent.FogColors viewport) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (Experiment10FogColorProcessProcedure.isInCreativeOrSpectator(entity)) {
            return;
        }
        boolean has10DNA = Experiment10FogColorProcessProcedure.hasItem(living, (Item)ChangedAddonItems.EXPERIMENT_10_DNA.get());
        boolean has009DNA = Experiment10FogColorProcessProcedure.hasItem(living, (Item)ChangedAddonItems.EXPERIMENT_009_DNA.get());
        if (has10DNA && !has009DNA) {
            Experiment10FogColorProcessProcedure.setFogColor(viewport, COLOR_10);
        } else if (has009DNA && !has10DNA) {
            Experiment10FogColorProcessProcedure.setFogColor(viewport, COLOR_009);
        } else if (has10DNA && has009DNA) {
            Experiment10FogColorProcessProcedure.setFogColor(viewport, COLOR_MIX);
        }
        if (!entity.getPersistentData().m_128471_("NoAI")) {
            if (Experiment10FogColorProcessProcedure.isEntityNearby(world, pos, Experiment10BossEntity.class, 50.0)) {
                Experiment10FogColorProcessProcedure.setFogColor(viewport, COLOR_10);
            }
            if (Experiment10FogColorProcessProcedure.isEntityNearby(world, pos, Experiment009BossEntity.class, 50.0)) {
                Experiment10FogColorProcessProcedure.setFogColor(viewport, COLOR_009);
            }
        }
    }

    private static boolean hasItem(LivingEntity entity, Item item) {
        return entity.m_21205_().m_150930_(item) || entity.m_21206_().m_150930_(item);
    }

    private static boolean isEntityNearby(LevelAccessor world, Vec3 pos, Class<? extends Entity> clazz, double range) {
        AABB box = AABB.m_165882_((Vec3)pos, (double)range, (double)range, (double)range);
        return world.m_6443_(clazz, box, e -> true).stream().findAny().isPresent();
    }

    private static void setFogColor(EntityViewRenderEvent.FogColors fog, float[] rgb) {
        fog.setRed(rgb[0]);
        fog.setGreen(rgb[1]);
        fog.setBlue(rgb[2]);
    }

    private static boolean isInCreativeOrSpectator(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            GameType type = serverPlayer.f_8941_.m_9290_();
            return type == GameType.CREATIVE || type == GameType.SPECTATOR;
        }
        if (entity.f_19853_.m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            PlayerInfo info = Minecraft.m_91087_().m_91403_().m_104949_(player.m_36316_().getId());
            if (info != null) {
                GameType type = info.m_105325_();
                return type == GameType.CREATIVE || type == GameType.SPECTATOR;
            }
        }
        return false;
    }
}

