/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.procedures;

import net.foxyas.changedaddon.init.ChangedAddonEnchantments;
import net.foxyas.changedaddon.init.ChangedAddonParticleTypes;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.init.ChangedTags;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TickentitySolventEnchantmenthitProcedure {
    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        Entity target = event.getEntity();
        Entity directEntity = event.getSource().m_7640_();
        if (target == null || directEntity == null) {
            return;
        }
        int enchantLevel = TickentitySolventEnchantmenthitProcedure.getSolventEnchantmentLevel(directEntity);
        if (enchantLevel == 0) {
            return;
        }
        if (TickentitySolventEnchantmenthitProcedure.shouldAffectEntity(target) && TickentitySolventEnchantmenthitProcedure.isValidWeapon(directEntity)) {
            TickentitySolventEnchantmenthitProcedure.applyEffects(event, target, enchantLevel);
        }
    }

    private static int getSolventEnchantmentLevel(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack mainHandItem = livingEntity.m_21205_();
            return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ChangedAddonEnchantments.SOLVENT.get()), (ItemStack)mainHandItem);
        }
        if (entity instanceof ThrownTrident) {
            ThrownTrident trident = (ThrownTrident)entity;
            CompoundTag tag = new CompoundTag();
            trident.m_20223_(tag);
            ItemStack tridentItem = tag.m_128441_("Trident") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Trident")) : new ItemStack((ItemLike)Items.f_42713_);
            return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ChangedAddonEnchantments.SOLVENT.get()), (ItemStack)tridentItem);
        }
        return 0;
    }

    private static boolean shouldAffectEntity(Entity entity) {
        Player player;
        return entity instanceof Player && ProcessTransfur.isPlayerLatex((Player)(player = (Player)entity)) || entity.m_6095_().m_204039_(ChangedTags.EntityTypes.LATEX) && entity instanceof ChangedEntity;
    }

    private static boolean isValidWeapon(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack mainHandItem = livingEntity.m_21205_();
            return !(mainHandItem.m_41720_() instanceof BowItem) && !(mainHandItem.m_41720_() instanceof CrossbowItem);
        }
        return entity instanceof ThrownTrident || !(entity instanceof Projectile);
    }

    private static void applyEffects(LivingHurtEvent event, Entity target, int enchantLevel) {
        double multiplier = (double)event.getAmount() * TickentitySolventEnchantmenthitProcedure.calculateDamageMultiplier(enchantLevel);
        event.setAmount((float)multiplier);
        TickentitySolventEnchantmenthitProcedure.playSoundAndParticles(target);
    }

    private static double calculateDamageMultiplier(float enchantLevel) {
        return 1.0 + (double)enchantLevel * 0.2;
    }

    private static void playSoundAndParticles(Entity entity) {
        Level level = entity.f_19853_;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            TickentitySolventEnchantmenthitProcedure.playSound(level, player.m_20185_(), player.m_20186_(), player.m_20189_());
        } else {
            entity.m_5496_(SoundEvents.f_11937_, 2.5f, 0.0f);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ChangedAddonParticleTypes.SOLVENT_PARTICLE.get()), entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 10, 0.2, 0.3, 0.2, 0.1);
        }
    }

    private static void playSound(Level level, double x, double y, double z) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6263_(null, x, y, z, SoundEvents.f_11937_, SoundSource.MASTER, 2.5f, 0.0f);
        } else {
            level.m_7785_(x, y, z, SoundEvents.f_11937_, SoundSource.MASTER, 2.5f, 0.0f, true);
        }
    }
}

