/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.util;

import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.List;
import net.foxyas.changedaddon.init.ChangedAddonDamageSources;
import net.foxyas.changedaddon.util.FoxyasUtils;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.ltxprogrammer.changed.block.AbstractLatexBlock;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.LatexType;
import net.ltxprogrammer.changed.init.ChangedTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChangedAddonLaethinminatorUtil {
    public static void shootDynamicLaser(Level world, Player player, int maxRange, int horizontalRadius, int verticalRadius) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            ChangedAddonLaethinminatorUtil.shootDynamicLaser(serverLevel, player, maxRange, horizontalRadius, verticalRadius);
        }
    }

    public static void spawnDirectionalParticle(ServerLevel level, Player player, ParticleOptions particleType, float speed) {
        if (level == null || player == null) {
            return;
        }
        Vec3 eyePos = player.m_146892_();
        Vec3 frontVector = player.m_20252_(0.5f);
        Vec3 rightVector = frontVector.m_82537_(player.m_20289_(0.5f));
        float dir = (player.m_7655_() == InteractionHand.MAIN_HAND == (player.m_5737_() == HumanoidArm.RIGHT) ? 1.0f : -1.0f) * 0.33f;
        Vec3 particlePos = eyePos.m_82549_(frontVector.m_82490_(0.75)).m_82549_(rightVector.m_82490_((double)dir)).m_82520_(0.0, -0.5, 0.0);
        float pitch = player.m_146909_() * ((float)Math.PI / 180);
        float yaw = player.m_146908_() * ((float)Math.PI / 180);
        Vec3 shootDirection = new Vec3(-Math.sin(yaw) * Math.cos(pitch), -Math.sin(pitch), Math.cos(yaw) * Math.cos(pitch)).m_82490_((double)speed);
        ParticlesUtil.sendParticles((Level)level, particleType, particlePos, 0.15f, 0.15f, 0.15f, 2, 0.0f);
    }

    public static void shootDynamicLaser(ServerLevel world, Player player, int maxRange, int horizontalRadius, int verticalRadius) {
        Vec3 eyePosition = player.m_20299_(1.0f);
        Color StartColor = new Color(255, 255, 255, 255);
        Color EndColor = new Color(255, 179, 179, 255);
        ParticleOptions particleOptions = ChangedAddonLaethinminatorUtil.getParticleOptions(StartColor, EndColor);
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookDir = player.m_20154_().m_82541_();
        for (int i = 1; i <= maxRange; ++i) {
            Vec3 targetVec = eyePosition.m_82549_(FoxyasUtils.getRelativePosition((Entity)player, 0.0, 0.0, i, true));
            BlockPos targetPos = new BlockPos(targetVec);
            Vec3 particlePos = eyePos.m_82549_(lookDir.m_82490_((double)i * 0.5));
            ParticlesUtil.sendParticles((Level)world, particleOptions, particlePos, 0.25f, 0.25f, 0.25f, 2, 0.0f);
            if (world.m_8055_(targetPos).m_60795_()) {
                ChangedAddonLaethinminatorUtil.affectSurroundingEntities(world, player, targetVec, 4.0 * ((double)i / (double)maxRange));
                continue;
            }
            ChangedAddonLaethinminatorUtil.affectSurroundingEntities(world, player, targetVec, 4.0 * ((double)i / (double)maxRange));
            ChangedAddonLaethinminatorUtil.affectSurroundingBlocks((Level)world, targetPos, horizontalRadius, verticalRadius);
        }
    }

    public static void affectSurroundingEntities(ServerLevel world, Player player, Vec3 targetPos, double area) {
        List entityList = world.m_6443_(ChangedEntity.class, new AABB(targetPos, targetPos).m_82400_(area), changedEntity -> changedEntity.m_6095_().m_204039_(ChangedTags.EntityTypes.LATEX));
        for (ChangedEntity en : entityList) {
            boolean isAllied = player.m_7307_((Entity)en);
            if (!player.m_6779_((LivingEntity)en) || !player.canHit((Entity)en, 0.0) || isAllied) continue;
            en.m_6469_(ChangedAddonDamageSources.mobAttack((LivingEntity)player).m_19366_(), 6.0f);
        }
    }

    private static void affectSurroundingBlocks(Level world, BlockPos center, int horizontalRadius, int verticalRadius) {
        int horizontalRadiusSphere = horizontalRadius - 1;
        int verticalRadiusSphere = verticalRadius - 1;
        for (int y = -verticalRadiusSphere; y <= verticalRadiusSphere; ++y) {
            block1: for (int x = -horizontalRadiusSphere; x <= horizontalRadiusSphere; ++x) {
                for (int z = -horizontalRadiusSphere; z <= horizontalRadiusSphere; ++z) {
                    double distanceSq = (double)(x * x) / (double)(horizontalRadiusSphere * horizontalRadiusSphere) + (double)(y * y) / (double)(verticalRadiusSphere * verticalRadiusSphere) + (double)(z * z) / (double)(horizontalRadiusSphere * horizontalRadiusSphere);
                    if (!(distanceSq <= 1.0)) continue;
                    BlockPos affectedPos = center.m_142082_(x, y, z);
                    if (world.m_8055_(affectedPos).m_60795_()) continue block1;
                    ChangedAddonLaethinminatorUtil.affectBlock(world, affectedPos);
                }
            }
        }
    }

    private static void affectBlock(Level world, BlockPos pos) {
        if (!world.m_8055_(pos).m_60795_()) {
            BlockState stage = world.m_8055_(pos);
            if (!stage.m_61138_((Property)AbstractLatexBlock.COVERED)) {
                return;
            }
            if (stage.m_61143_((Property)AbstractLatexBlock.COVERED) != LatexType.NEUTRAL) {
                BlockState NewStage = (BlockState)world.m_8055_(pos).m_61124_((Property)AbstractLatexBlock.COVERED, (Comparable)LatexType.NEUTRAL);
                world.m_7731_(pos, NewStage, 3);
                Color StartColor = new Color(255, 255, 255, 255);
                Color EndColor = new Color(93, 93, 93, 255);
                ParticleOptions particleOptions = ChangedAddonLaethinminatorUtil.getParticleOptions(StartColor, EndColor);
                ParticlesUtil.sendParticles(world, particleOptions, pos, 0.25f, 0.25f, 0.25f, 1, 0.0f);
            }
        }
    }

    @NotNull
    private static ParticleOptions getParticleOptions(Color StartColor, Color EndColor) {
        Vector3f startColor = new Vector3f((float)StartColor.getRed() / 255.0f, (float)StartColor.getGreen() / 255.0f, (float)StartColor.getBlue() / 255.0f);
        Vector3f endColor = new Vector3f((float)EndColor.getRed() / 255.0f, (float)EndColor.getGreen() / 255.0f, (float)EndColor.getBlue() / 255.0f);
        return new DustColorTransitionOptions(startColor, endColor, 1.0f);
    }
}

