/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DelayedTask {
    private static final Int2ObjectOpenHashMap<DelayedTask> activeTasks = new Int2ObjectOpenHashMap();
    private static int nextId = 0;
    private final int id;
    private final int delayTicks;
    private final Runnable task;
    private int currentTick = 0;
    private boolean paused = false;
    private boolean cancelled = false;

    public DelayedTask(int delayTicks, Runnable task) {
        this.delayTicks = delayTicks;
        this.task = task;
        this.id = nextId++;
        activeTasks.put(this.id, (Object)this);
    }

    @CanIgnoreReturnValue
    public static DelayedTask schedule(int delayTicks, Runnable task) {
        return new DelayedTask(delayTicks, task);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            activeTasks.values().forEach(DelayedTask::tick);
        }
    }

    public static DelayedTask getTask(int id) {
        return (DelayedTask)activeTasks.get(id);
    }

    public static void cancelTask(int id) {
        DelayedTask task = (DelayedTask)activeTasks.get(id);
        if (task != null) {
            task.cancel();
        }
    }

    public static void pauseTask(int id) {
        DelayedTask task = (DelayedTask)activeTasks.get(id);
        if (task != null) {
            task.pause();
        }
    }

    public static void resumeTask(int id) {
        DelayedTask task = (DelayedTask)activeTasks.get(id);
        if (task != null) {
            task.resume();
        }
    }

    public static boolean isTaskPaused(int id) {
        DelayedTask task = (DelayedTask)activeTasks.get(id);
        return task != null && task.isPaused();
    }

    public void tick() {
        if (this.paused) {
            return;
        }
        if (this.isCancelled()) {
            this.destroy();
            return;
        }
        ++this.currentTick;
        if (this.currentTick < this.delayTicks) {
            return;
        }
        try {
            this.task.run();
        }
        catch (Exception e) {
            System.err.println("Error during the execution of the DelayedTask with ID: " + this.id + "\n " + e.getMessage());
        }
        finally {
            this.cancel();
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    private void destroy() {
        activeTasks.remove(this.id);
    }

    public void pause() {
        this.paused = true;
        ChangedAddonMod.LOGGER.info("DelayedTask with ID: {} was paused by an external code", (Object)this.id);
    }

    public void resume() {
        this.paused = false;
        ChangedAddonMod.LOGGER.info("DelayedTask with ID: {} was resumed by an external code", (Object)this.id);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getId() {
        return this.id;
    }

    static {
        MinecraftForge.EVENT_BUS.register(DelayedTask.class);
    }
}

