/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.foxyas.changedaddon.util.DynamicClipContext;
import net.ltxprogrammer.changed.block.AbstractLatexBlock;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.LatexType;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FoxyasUtils {
    public static String SpawnEggIdFromTransfurVariant(TransfurVariant<?> latexVariant) {
        String Util2 = latexVariant.getFormId().toString().replace("changed_addon:form_", "");
        return Util2 + "_spawn_egg";
    }

    public static Stream<BlockPos> getBlockPositionsInSphere(BlockPos center, int radius) {
        return BlockPos.m_121990_((BlockPos)center.m_142082_(-radius, -radius, -radius), (BlockPos)center.m_142082_(radius, radius, radius)).filter(pos -> pos.m_123331_((Vec3i)center) <= (double)(radius * radius));
    }

    public static Stream<BlockPos> betweenClosedStreamSphere(BlockPos center, int horizontalRadiusSphere, int verticalRadiusSphere) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        for (int i = -verticalRadiusSphere; i <= verticalRadiusSphere; ++i) {
            for (int xi = -horizontalRadiusSphere; xi <= horizontalRadiusSphere; ++xi) {
                for (int zi = -horizontalRadiusSphere; zi <= horizontalRadiusSphere; ++zi) {
                    double distanceSq = (double)(xi * xi) / (double)(horizontalRadiusSphere * horizontalRadiusSphere) + (double)(i * i) / (double)(verticalRadiusSphere * verticalRadiusSphere) + (double)(zi * zi) / (double)(horizontalRadiusSphere * horizontalRadiusSphere);
                    if (!(distanceSq <= 1.0)) continue;
                    BlockPos pos = center.m_142082_(xi, i, zi);
                    blockPosList.add(pos);
                }
            }
        }
        return blockPosList.stream();
    }

    public static Stream<BlockPos> betweenClosedStreamSphere(BlockPos center, int horizontalRadiusSphere, int verticalRadiusSphere, float troubleshot) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        for (int i = -verticalRadiusSphere; i <= verticalRadiusSphere; ++i) {
            for (int xi = -horizontalRadiusSphere; xi <= horizontalRadiusSphere; ++xi) {
                for (int zi = -horizontalRadiusSphere; zi <= horizontalRadiusSphere; ++zi) {
                    double distanceSq = (double)(xi * xi) / (double)(horizontalRadiusSphere * horizontalRadiusSphere) + (double)(i * i) / (double)(verticalRadiusSphere * verticalRadiusSphere) + (double)(zi * zi) / (double)(horizontalRadiusSphere * horizontalRadiusSphere);
                    if (!(distanceSq <= (double)troubleshot)) continue;
                    BlockPos pos = center.m_142082_(xi, i, zi);
                    blockPosList.add(pos);
                }
            }
        }
        return blockPosList.stream();
    }

    public static List<BlockPos> getOutlineBlocks(BoundingBox box) {
        ArrayList<BlockPos> outline = new ArrayList<BlockPos>();
        for (int x = box.m_162395_(); x <= box.m_162399_(); ++x) {
            for (int y = box.m_162396_(); y <= box.m_162400_(); ++y) {
                for (int z = box.m_162398_(); z <= box.m_162401_(); ++z) {
                    boolean onZFace;
                    boolean onXFace = x == box.m_162395_() || x == box.m_162399_();
                    boolean onYFace = y == box.m_162396_() || y == box.m_162400_();
                    boolean bl = onZFace = z == box.m_162398_() || z == box.m_162401_();
                    if (!onXFace && !onYFace && !onZFace) continue;
                    outline.add(new BlockPos(x, y, z));
                }
            }
        }
        return outline;
    }

    public static Stream<BlockPos> betweenClosedStreamSphereOutline(BlockPos center, int horizontalRadius, int verticalRadius) {
        ArrayList<BlockPos> outline = new ArrayList<BlockPos>();
        double tolerance = 0.25;
        for (int y = -verticalRadius; y <= verticalRadius; ++y) {
            for (int x = -horizontalRadius; x <= horizontalRadius; ++x) {
                for (int z = -horizontalRadius; z <= horizontalRadius; ++z) {
                    double dx = (double)x / (double)horizontalRadius;
                    double dy = (double)y / (double)verticalRadius;
                    double dz = (double)z / (double)horizontalRadius;
                    double distanceSq = dx * dx + dy * dy + dz * dz;
                    if (!(distanceSq >= 1.0 - tolerance) || !(distanceSq <= 1.0)) continue;
                    outline.add(center.m_142082_(x, y, z));
                }
            }
        }
        return outline.stream();
    }

    public static Stream<BlockPos> betweenClosedStreamSphereOutline(BlockPos center, int horizontalRadius, int verticalRadius, double borderDistance) {
        ArrayList<BlockPos> outline = new ArrayList<BlockPos>();
        double tolerance = 0.25;
        for (int y = -verticalRadius; y <= verticalRadius; ++y) {
            for (int x = -horizontalRadius; x <= horizontalRadius; ++x) {
                for (int z = -horizontalRadius; z <= horizontalRadius; ++z) {
                    double dx = (double)x / (double)horizontalRadius;
                    double dy = (double)y / (double)verticalRadius;
                    double dz = (double)z / (double)horizontalRadius;
                    double distanceSq = dx * dx + dy * dy + dz * dz;
                    if (!(distanceSq >= borderDistance - tolerance) || !(distanceSq <= borderDistance)) continue;
                    outline.add(center.m_142082_(x, y, z));
                }
            }
        }
        return outline.stream();
    }

    public static boolean canEntitySeeOther(LivingEntity eyeEntity, LivingEntity targetToSee, double fovDegrees) {
        double requiredDot;
        Vec3 directionToTarget;
        Level level = eyeEntity.f_19853_;
        if (level != targetToSee.f_19853_) {
            return false;
        }
        Vec3 from = eyeEntity.m_20299_(1.0f);
        Vec3 to = targetToSee.m_20299_(1.0f);
        Vec3 lookVec = eyeEntity.m_20154_().m_82541_();
        double dot = lookVec.m_82526_(directionToTarget = to.m_82546_(from).m_82541_());
        if (dot < (requiredDot = Math.cos(Math.toRadians(fovDegrees / 2.0)))) {
            return false;
        }
        BlockHitResult result = level.m_45547_(new ClipContext(from, to, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)eyeEntity));
        return result.m_6662_() == HitResult.Type.MISS || result.m_82450_().m_82557_(to) < 1.0;
    }

    public static boolean canEntitySeePos(LivingEntity eyeEntity, Vec3 to, double fovDegrees) {
        double requiredDot;
        Vec3 directionToTarget;
        Level level = eyeEntity.f_19853_;
        Vec3 from = eyeEntity.m_20299_(1.0f);
        Vec3 lookVec = eyeEntity.m_20154_().m_82541_();
        double dot = lookVec.m_82526_(directionToTarget = to.m_82546_(from).m_82541_());
        if (dot < (requiredDot = Math.cos(Math.toRadians(fovDegrees / 2.0)))) {
            return false;
        }
        BlockHitResult result = level.m_45547_(new ClipContext(from, to, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)eyeEntity));
        return result.m_6662_() == HitResult.Type.MISS || result.m_82450_().m_82557_(to) < 1.0;
    }

    public static boolean canEntitySeePosIgnoreGlass(LivingEntity eyeEntity, Vec3 to, double fovDegrees) {
        double requiredDot;
        Vec3 directionToTarget;
        Level level = eyeEntity.f_19853_;
        Vec3 from = eyeEntity.m_20299_(1.0f);
        Vec3 lookVec = eyeEntity.m_20154_().m_82541_();
        double dot = lookVec.m_82526_(directionToTarget = to.m_82546_(from).m_82541_());
        if (dot < (requiredDot = Math.cos(Math.toRadians(fovDegrees / 2.0)))) {
            return false;
        }
        BlockHitResult result = level.m_45547_((ClipContext)new DynamicClipContext(from, to, DynamicClipContext.IGNORE_TRANSLUCENT, arg_0 -> ((ClipContext.Fluid)ClipContext.Fluid.NONE).m_45731_(arg_0), CollisionContext.m_82750_((Entity)eyeEntity)));
        return result.m_6662_() == HitResult.Type.MISS || result.m_82450_().m_82557_(to) < 1.0;
    }

    public static boolean canEntitySeeOther(LivingEntity eyeEntity, LivingEntity targetToSee) {
        Vec3 to;
        Level level = eyeEntity.f_19853_;
        if (level != targetToSee.f_19853_) {
            return false;
        }
        Vec3 from = eyeEntity.m_20299_(1.0f);
        BlockHitResult result = level.m_45547_(new ClipContext(from, to = targetToSee.m_20299_(1.0f), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)eyeEntity));
        return result.m_6662_() == HitResult.Type.MISS || result.m_82450_().m_82557_(to) < 1.0;
    }

    public static boolean canEntitySeeOtherIgnoreGlass(LivingEntity eyeEntity, LivingEntity targetToSee) {
        Level level = eyeEntity.f_19853_;
        if (level != targetToSee.f_19853_) {
            return false;
        }
        Vec3 from = eyeEntity.m_20299_(1.0f);
        Vec3 to = targetToSee.m_20299_(1.0f);
        BlockHitResult result = level.m_45547_((ClipContext)new DynamicClipContext(from, to, DynamicClipContext.IGNORE_TRANSLUCENT, arg_0 -> ((ClipContext.Fluid)ClipContext.Fluid.NONE).m_45731_(arg_0), CollisionContext.m_82750_((Entity)eyeEntity)));
        return result.m_6662_() == HitResult.Type.MISS || result.m_82450_().m_82557_(to) < 1.0;
    }

    public static boolean canEntitySeeOtherIgnoreGlass(LivingEntity eyeEntity, LivingEntity targetToSee, double fovDegrees) {
        double requiredDot;
        Vec3 directionToTarget;
        Level level = eyeEntity.f_19853_;
        if (level != targetToSee.f_19853_) {
            return false;
        }
        Vec3 from = eyeEntity.m_20299_(1.0f);
        Vec3 to = targetToSee.m_20299_(1.0f);
        Vec3 lookVec = eyeEntity.m_20154_().m_82541_();
        double dot = lookVec.m_82526_(directionToTarget = to.m_82546_(from).m_82541_());
        if (dot < (requiredDot = Math.cos(Math.toRadians(fovDegrees / 2.0)))) {
            return false;
        }
        BlockHitResult result = level.m_45547_((ClipContext)new DynamicClipContext(from, to, DynamicClipContext.IGNORE_TRANSLUCENT, arg_0 -> ((ClipContext.Fluid)ClipContext.Fluid.NONE).m_45731_(arg_0), CollisionContext.m_82750_((Entity)eyeEntity)));
        return result.m_6662_() == HitResult.Type.MISS || result.m_82450_().m_82557_(to) < 1.0;
    }

    public static boolean canEntitySeePosIgnoreGlass(LivingEntity eyeEntity, Vec3 to) {
        Level level = eyeEntity.f_19853_;
        Vec3 from = eyeEntity.m_20299_(1.0f);
        BlockHitResult result = level.m_45547_((ClipContext)new DynamicClipContext(from, to, DynamicClipContext.IGNORE_TRANSLUCENT, arg_0 -> ((ClipContext.Fluid)ClipContext.Fluid.NONE).m_45731_(arg_0), CollisionContext.m_82750_((Entity)eyeEntity)));
        return result.m_6662_() == HitResult.Type.MISS || result.m_82450_().m_82557_(to) < 1.0;
    }

    public static void renderTextInWorld(PoseStack poseStack, MultiBufferSource bufferSource, String text, double x, double y, double z) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, z);
        poseStack.m_85845_(mc.m_91290_().m_114470_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        float backgroundOpacity = mc.f_91066_.m_92141_(0.25f);
        int backgroundColor = (int)(backgroundOpacity * 255.0f) << 24;
        font.m_92811_(text, (float)(-font.m_92895_(text)) / 2.0f, 0.0f, 0xFFFFFF, false, matrix, bufferSource, false, backgroundColor, 0xF000F0);
        poseStack.m_85849_();
    }

    public static boolean isConnectedToSourceNoLimit(ServerLevel level, BlockPos start, LatexType latexType, Block targetBlock) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toVisit = new ArrayDeque<BlockPos>();
        toVisit.add(start);
        while (!toVisit.isEmpty()) {
            BlockPos current = (BlockPos)toVisit.poll();
            if (!visited.add(current)) continue;
            BlockState state = level.m_8055_(current);
            if (state.m_60713_(targetBlock)) {
                return true;
            }
            if (!AbstractLatexBlock.isLatexed((BlockState)state) || AbstractLatexBlock.getLatexed((BlockState)state) != latexType) continue;
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = current.m_142300_(dir);
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return false;
    }

    public static boolean isConnectedToSource(ServerLevel level, BlockPos start, LatexType latexType, Block targetBlock, int maxDepth) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<Pair> toVisit = new ArrayDeque<Pair>();
        toVisit.add(Pair.of((Object)start, (Object)0));
        while (!toVisit.isEmpty()) {
            Pair entry = (Pair)toVisit.poll();
            BlockPos current = (BlockPos)entry.getFirst();
            int depth = (Integer)entry.getSecond();
            if (depth > maxDepth || !visited.add(current)) continue;
            BlockState state = level.m_8055_(current);
            if (state.m_60713_(targetBlock)) {
                return true;
            }
            if (!AbstractLatexBlock.isLatexed((BlockState)state) || AbstractLatexBlock.getLatexed((BlockState)state) != latexType) continue;
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = current.m_142300_(dir);
                toVisit.add(Pair.of((Object)neighbor, (Object)(depth + 1)));
            }
        }
        return false;
    }

    public static boolean isConnectedToSource(ServerLevel level, BlockPos start, Block targetBlock, int maxDepth) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<Pair> toVisit = new ArrayDeque<Pair>();
        toVisit.add(Pair.of((Object)start, (Object)0));
        while (!toVisit.isEmpty()) {
            Pair entry = (Pair)toVisit.poll();
            BlockPos current = (BlockPos)entry.getFirst();
            int depth = (Integer)entry.getSecond();
            if (depth > maxDepth || !visited.add(current)) continue;
            BlockState state = level.m_8055_(current);
            if (state.m_60713_(targetBlock)) {
                return true;
            }
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = current.m_142300_(dir);
                toVisit.add(Pair.of((Object)neighbor, (Object)(depth + 1)));
            }
        }
        return false;
    }

    public static void spreadFromSource(ServerLevel level, BlockPos source, int maxDepth) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        queue.add(Pair.of((Object)source, (Object)0));
        visited.add(source);
        while (!queue.isEmpty()) {
            BlockState state;
            Pair current = (Pair)queue.poll();
            BlockPos pos = (BlockPos)current.getFirst();
            int depth = (Integer)current.getSecond();
            if (depth > maxDepth || !AbstractLatexBlock.isLatexed((BlockState)(state = level.m_8055_(pos)))) continue;
            state.m_60735_(level, pos, level.m_5822_());
            level.m_46796_(1505, pos, 1);
            if (depth >= maxDepth) continue;
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = pos.m_142300_(dir);
                if (visited.contains(neighbor)) continue;
                visited.add(neighbor);
                queue.add(Pair.of((Object)neighbor, (Object)(depth + 1)));
            }
        }
    }

    public static void repairArmor(LivingEntity entity, int amountPerPiece) {
        for (ItemStack armorPiece : entity.m_6168_()) {
            int damage;
            if (armorPiece.m_41619_() || !armorPiece.m_41763_() || (damage = armorPiece.m_41773_()) <= 0) continue;
            int repaired = Math.min(damage, amountPerPiece);
            armorPiece.m_41721_(damage - repaired);
        }
    }

    public static ClipContext createClipContext(Player player, double distance, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(player.m_20252_(1.0f).m_82490_(distance));
        return new ClipContext(start, end, blockMode, fluidMode, (Entity)player);
    }

    public static BlockHitResult rayTraceBlocks(Level world, ClipContext context, Predicate<BlockState> ignorePredicate) {
        return FoxyasUtils.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.m_8055_(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            FluidState fluidState = world.m_6425_(blockPos);
            Vec3 startVec = rayTraceContext.m_45702_();
            Vec3 endVec = rayTraceContext.m_45693_();
            VoxelShape blockShape = rayTraceContext.m_45694_(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockResult = world.m_45558_(startVec, endVec, blockPos, blockShape, blockState);
            VoxelShape fluidShape = rayTraceContext.m_45698_(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidResult = fluidShape.m_83220_(startVec, endVec, blockPos);
            double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(blockResult.m_82450_());
            double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(fluidResult.m_82450_());
            return blockDistance <= fluidDistance ? blockResult : fluidResult;
        }, rayTraceContext -> {
            Vec3 Vector3d = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)Vector3d.f_82479_, (double)Vector3d.f_82480_, (double)Vector3d.f_82481_), (BlockPos)new BlockPos(rayTraceContext.m_45693_()));
        });
    }

    public static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> missFactory) {
        int blockZ;
        int blockY;
        Vec3 endVec;
        Vec3 startVec = context.m_45702_();
        if (startVec.equals((Object)(endVec = context.m_45693_()))) {
            return missFactory.apply(context);
        }
        double startX = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82479_, (double)startVec.f_82479_);
        double startY = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82480_, (double)startVec.f_82480_);
        double startZ = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82481_, (double)startVec.f_82481_);
        double endX = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82479_, (double)endVec.f_82479_);
        double endY = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82480_, (double)endVec.f_82480_);
        double endZ = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82481_, (double)endVec.f_82481_);
        int blockX = Mth.m_14107_((double)endX);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.m_14107_((double)endY), blockZ = Mth.m_14107_((double)endZ));
        T t = hitFunction.apply(context, (BlockPos)mutablePos);
        if (t != null) {
            return t;
        }
        double deltaX = startX - endX;
        double deltaY = startY - endY;
        double deltaZ = startZ - endZ;
        int signX = Mth.m_14205_((double)deltaX);
        int signY = Mth.m_14205_((double)deltaY);
        int signZ = Mth.m_14205_((double)deltaZ);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
        double d12 = d9 * (signX > 0 ? 1.0 - Mth.m_14185_((double)endX) : Mth.m_14185_((double)endX));
        double d13 = d10 * (signY > 0 ? 1.0 - Mth.m_14185_((double)endY) : Mth.m_14185_((double)endY));
        double d14 = d11 * (signZ > 0 ? 1.0 - Mth.m_14185_((double)endZ) : Mth.m_14185_((double)endZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    blockX += signX;
                    d12 += d9;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                blockY += signY;
                d13 += d10;
            } else {
                blockZ += signZ;
                d14 += d11;
            }
            if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.m_122178_(blockX, blockY, blockZ))) == null) continue;
            return t1;
        }
        return missFactory.apply(context);
    }

    public static BlockHitResult manualRaycastIgnoringBlocks(Level level, Entity entity, double maxDistance, Set<Block> ignoredBlocks) {
        Vec3 start = entity.m_20299_(1.0f);
        Vec3 lookVec = entity.m_20252_(1.0f);
        Vec3 end = start.m_82549_(lookVec.m_82490_(maxDistance));
        double stepSize = 0.1;
        Vec3 currentPos = start;
        int steps = (int)(maxDistance / stepSize);
        for (int i = 0; i < steps; ++i) {
            BlockPos blockPos = new BlockPos(currentPos);
            BlockState state = level.m_8055_(blockPos);
            if (!ignoredBlocks.contains(state.m_60734_()) && state.m_60804_((BlockGetter)level, blockPos)) {
                Direction direction = Direction.m_122366_((double)lookVec.f_82479_, (double)lookVec.f_82480_, (double)lookVec.f_82481_);
                currentPos = FoxyasUtils.applyOffset(currentPos, direction, 0.05);
                return new BlockHitResult(currentPos, direction, blockPos, true);
            }
            currentPos = currentPos.m_82549_(lookVec.m_82490_(stepSize));
        }
        Direction missDirection = Direction.m_122366_((double)lookVec.f_82479_, (double)lookVec.f_82480_, (double)lookVec.f_82481_);
        Vec3 missPos = FoxyasUtils.applyOffset(end, missDirection, -0.05);
        return BlockHitResult.m_82426_((Vec3)missPos, (Direction)missDirection, (BlockPos)new BlockPos(end));
    }

    public static Vec3 applyOffset(Vec3 hitPos, Direction face, double offset) {
        return hitPos.m_82492_((double)face.m_122429_() * offset, (double)face.m_122430_() * offset, (double)face.m_122431_() * offset);
    }

    public static Vec3 getRelativePositionEyes(Entity entity, float deltaX, float deltaY, float deltaZ) {
        Vec3 forward = entity.m_20252_(1.0f);
        Vec3 up = entity.m_20289_(1.0f);
        Vec3 right = forward.m_82537_(up).m_82541_();
        Vec3 offset = right.m_82490_((double)(-deltaX)).m_82549_(up.m_82490_((double)deltaY)).m_82549_(forward.m_82490_((double)deltaZ));
        return entity.m_146892_().m_82549_(offset);
    }

    public static Vec3 getRelativePositionEyes(Entity entity, double deltaX, double deltaY, double deltaZ) {
        Vec3 forward = entity.m_20252_(1.0f);
        Vec3 up = entity.m_20289_(1.0f);
        Vec3 right = forward.m_82537_(up).m_82541_();
        Vec3 offset = right.m_82490_(-deltaX).m_82549_(up.m_82490_(deltaY)).m_82549_(forward.m_82490_(deltaZ));
        return entity.m_146892_().m_82549_(offset);
    }

    public static Vec3 getRelativePositionEyes(Entity entity, Vec3 vec3) {
        double deltaX = vec3.f_82479_;
        double deltaY = vec3.f_82480_;
        double deltaZ = vec3.f_82481_;
        Vec3 forward = entity.m_20252_(1.0f);
        Vec3 up = entity.m_20289_(1.0f);
        Vec3 right = forward.m_82537_(up).m_82541_();
        Vec3 offset = right.m_82490_(-deltaX).m_82549_(up.m_82490_(deltaY)).m_82549_(forward.m_82490_(deltaZ));
        return entity.m_146892_().m_82549_(offset);
    }

    public static Vec3 getRelativePositionCommandStyle(Entity entity, double deltaX, double deltaY, double deltaZ) {
        Vec2 rotation = entity.m_20155_();
        Vec3 position = entity.m_20182_();
        float yawRad = (rotation.f_82471_ + 90.0f) * ((float)Math.PI / 180);
        float pitchRad = -rotation.f_82470_ * ((float)Math.PI / 180);
        float pitchRad90 = (-rotation.f_82470_ + 90.0f) * ((float)Math.PI / 180);
        float cosYaw = Mth.m_14089_((float)yawRad);
        float sinYaw = Mth.m_14031_((float)yawRad);
        float cosPitch = Mth.m_14089_((float)pitchRad);
        float sinPitch = Mth.m_14031_((float)pitchRad);
        float cosPitch90 = Mth.m_14089_((float)pitchRad90);
        float sinPitch90 = Mth.m_14031_((float)pitchRad90);
        Vec3 forward = new Vec3((double)(cosYaw * cosPitch), (double)sinPitch, (double)(sinYaw * cosPitch));
        Vec3 up = new Vec3((double)(cosYaw * cosPitch90), (double)sinPitch90, (double)(sinYaw * cosPitch90));
        Vec3 right = forward.m_82537_(up).m_82490_(-1.0);
        double newX = forward.f_82479_ * deltaZ + up.f_82479_ * deltaY + right.f_82479_ * deltaX;
        double newY = forward.f_82480_ * deltaZ + up.f_82480_ * deltaY + right.f_82480_ * deltaX;
        double newZ = forward.f_82481_ * deltaZ + up.f_82481_ * deltaY + right.f_82481_ * deltaX;
        return new Vec3(position.f_82479_ + newX, position.f_82480_ + newY, position.f_82481_ + newZ);
    }

    public static Vec3 getRelativePosition(Entity entity, double deltaX, double deltaY, double deltaZ, boolean onlyOffset) {
        if (entity == null) {
            return Vec3.f_82478_;
        }
        Vec3 forward = entity.m_20252_(1.0f);
        Vec3 up = entity.m_20289_(1.0f);
        Vec3 right = forward.m_82537_(up).m_82541_();
        Vec3 offset = right.m_82490_(deltaX).m_82549_(up.m_82490_(deltaY)).m_82549_(forward.m_82490_(deltaZ));
        if (onlyOffset) {
            return offset;
        }
        return entity.m_20182_().m_82549_(offset);
    }

    public static double getTorsoYOffset(ChangedEntity self) {
        float ageAdjusted = (float)self.f_19797_ * 0.33333334f * 0.25f * 0.15f;
        float ageSin = Mth.m_14031_((float)(ageAdjusted * (float)Math.PI * 0.5f));
        float ageCos = Mth.m_14089_((float)(ageAdjusted * (float)Math.PI * 0.5f));
        float bpiSize = (self.getBasicPlayerInfo().getSize() - 1.0f) * 2.0f;
        return Mth.m_14179_((float)Mth.m_14179_((float)(1.0f - Mth.m_14154_((float)(Mth.m_14091_((float)ageAdjusted, (float)2.0f) - 1.0f))), (float)(ageSin * ageSin * ageSin * ageSin), (float)(1.0f - ageCos * ageCos * ageCos * ageCos)), (float)0.95f, (float)0.87f) + bpiSize;
    }

    public static double getTorsoYOffset(ChangedEntity self, float scale) {
        float ageAdjusted = (float)self.f_19797_ * 0.33333334f * 0.25f * 0.15f;
        float ageSin = Mth.m_14031_((float)(ageAdjusted * (float)Math.PI * 0.5f));
        float ageCos = Mth.m_14089_((float)(ageAdjusted * (float)Math.PI * 0.5f));
        float bpiSize = (self.getBasicPlayerInfo().getSize() - 1.0f) * 2.0f;
        float baseOscillation = Mth.m_14179_((float)Mth.m_14179_((float)(1.0f - Mth.m_14154_((float)(Mth.m_14091_((float)ageAdjusted, (float)2.0f) - 1.0f))), (float)(ageSin * ageSin * ageSin * ageSin), (float)(1.0f - ageCos * ageCos * ageCos * ageCos)), (float)0.95f, (float)0.87f);
        return baseOscillation * scale + bpiSize;
    }
}

