/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.util;

import java.util.List;
import net.foxyas.changedaddon.item.LaserPointer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemUtils {
    public static ItemStack dyeArmor(ItemStack input, List<DyeItem> dyes) {
        Item item = input.m_41720_();
        if (!(item instanceof DyeableLeatherItem)) {
            return ItemStack.f_41583_;
        }
        DyeableLeatherItem dyeable = (DyeableLeatherItem)item;
        ItemStack result = input.m_41777_();
        result.m_41764_(1);
        int[] colorComponents = new int[3];
        int totalMaxComponent = 0;
        int colorCount = 0;
        if (dyeable.m_41113_(input)) {
            int color = dyeable.m_41121_(input);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            totalMaxComponent += (int)(Math.max(r, Math.max(g, b)) * 255.0f);
            colorComponents[0] = colorComponents[0] + (int)(r * 255.0f);
            colorComponents[1] = colorComponents[1] + (int)(g * 255.0f);
            colorComponents[2] = colorComponents[2] + (int)(b * 255.0f);
            ++colorCount;
        }
        for (DyeItem dye : dyes) {
            float[] rgb = dye.m_41089_().m_41068_();
            int r = (int)(rgb[0] * 255.0f);
            int g = (int)(rgb[1] * 255.0f);
            int b = (int)(rgb[2] * 255.0f);
            totalMaxComponent += Math.max(r, Math.max(g, b));
            colorComponents[0] = colorComponents[0] + r;
            colorComponents[1] = colorComponents[1] + g;
            colorComponents[2] = colorComponents[2] + b;
            ++colorCount;
        }
        if (colorCount == 0) {
            return ItemStack.f_41583_;
        }
        int r = colorComponents[0] / colorCount;
        int g = colorComponents[1] / colorCount;
        int b = colorComponents[2] / colorCount;
        float avgMax = (float)totalMaxComponent / (float)colorCount;
        float maxComponent = Math.max(r, Math.max(g, b));
        r = (int)((float)r * avgMax / maxComponent);
        g = (int)((float)g * avgMax / maxComponent);
        b = (int)((float)b * avgMax / maxComponent);
        int finalColor = r << 16 | g << 8 | b;
        dyeable.m_41115_(result, finalColor);
        return result;
    }

    public static ItemStack dyeLaser(ItemStack input, List<DyeItem> dyes) {
        Item item = input.m_41720_();
        if (!(item instanceof LaserPointer)) {
            return ItemStack.f_41583_;
        }
        LaserPointer dyeable = (LaserPointer)item;
        ItemStack result = input.m_41777_();
        result.m_41764_(1);
        int[] colorComponents = new int[3];
        int totalMaxComponent = 0;
        int colorCount = 0;
        int color = LaserPointer.getColor(input);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        totalMaxComponent += (int)(Math.max(r, Math.max(g, b)) * 255.0f);
        colorComponents[0] = colorComponents[0] + (int)(r * 255.0f);
        colorComponents[1] = colorComponents[1] + (int)(g * 255.0f);
        colorComponents[2] = colorComponents[2] + (int)(b * 255.0f);
        ++colorCount;
        for (DyeItem dye : dyes) {
            float[] rgb = dye.m_41089_().m_41068_();
            int r2 = (int)(rgb[0] * 255.0f);
            int g2 = (int)(rgb[1] * 255.0f);
            int b2 = (int)(rgb[2] * 255.0f);
            totalMaxComponent += Math.max(r2, Math.max(g2, b2));
            colorComponents[0] = colorComponents[0] + r2;
            colorComponents[1] = colorComponents[1] + g2;
            colorComponents[2] = colorComponents[2] + b2;
            ++colorCount;
        }
        if (colorCount == 0) {
            return ItemStack.f_41583_;
        }
        int r3 = colorComponents[0] / colorCount;
        int g3 = colorComponents[1] / colorCount;
        int b3 = colorComponents[2] / colorCount;
        float avgMax = (float)totalMaxComponent / (float)colorCount;
        float maxComponent = Math.max(r3, Math.max(g3, b3));
        r3 = (int)((float)r3 * avgMax / maxComponent);
        g3 = (int)((float)g3 * avgMax / maxComponent);
        b3 = (int)((float)b3 * avgMax / maxComponent);
        int finalColor = r3 << 16 | g3 << 8 | b3;
        LaserPointer.setLaserColor(result, finalColor);
        return result;
    }
}

