/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.ltxprogrammer.changed.client.renderer.AdvancedHumanoidRenderer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.client.renderer.model.armor.LatexHumanoidArmorModel;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ModelUtils {
    public static Vec3 getWorldPositionFromModelPart(ModelPart part, Vector3f Offset, @NotNull Entity entity, @Nullable Vec3 entityPosOffset, @Nullable Vec3 Rotation2, boolean affectEntityViewXrot) {
        float f;
        Player player;
        if (Rotation2 == null) {
            Rotation2 = new Vec3(180.0, 0.0, 0.0);
        }
        if (entityPosOffset == null) {
            entityPosOffset = new Vec3(0.0, 0.2, 0.0);
        }
        PoseStack stack = new PoseStack();
        stack.m_85837_(entity.m_20185_() + entityPosOffset.m_7096_(), entity.m_20188_() + entityPosOffset.m_7098_() + (entity instanceof Player && (player = (Player)entity).m_6144_() ? 0.225 : 0.0), entity.m_20189_() + entityPosOffset.m_7094_());
        if (entity instanceof Player) {
            player = (Player)entity;
            f = -player.f_20884_;
        } else {
            f = -entity.f_19859_;
        }
        stack.m_85845_(Vector3f.f_122225_.m_122240_(f));
        if (affectEntityViewXrot) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(entity.m_146909_()));
        }
        part.f_104203_ *= 1.0f;
        part.f_104204_ *= 1.0f;
        part.f_104205_ *= 1.0f;
        stack.m_85845_(Vector3f.f_122225_.m_122240_((float)Rotation2.m_7098_()));
        stack.m_85845_(Vector3f.f_122223_.m_122240_((float)Rotation2.m_7096_()));
        stack.m_85845_(Vector3f.f_122227_.m_122240_((float)Rotation2.m_7094_()));
        part.m_104299_(stack);
        Matrix4f matrix = stack.m_85850_().m_85861_();
        Vector4f pos = new Vector4f(Offset.m_122239_(), Offset.m_122260_(), Offset.m_122269_(), 1.0f);
        pos.m_123607_(matrix);
        return new Vec3((double)pos.m_123601_(), (double)pos.m_123615_(), (double)pos.m_123616_());
    }

    public static List<ModelPart> getTailFromModelIfAny(AdvancedHumanoidModel<?> model) {
        ArrayList<ModelPart> tailParts = new ArrayList<ModelPart>();
        try {
            ModelPart tail = model.getTorso().m_171324_("Tail");
            tailParts.add(tail);
            ModelPart primary = tail.m_171324_("TailPrimary");
            tailParts.add(primary);
            ModelPart secondary = primary.m_171324_("TailSecondary");
            tailParts.add(secondary);
            ModelPart tertiary = secondary.m_171324_("TailTertiary");
            tailParts.add(tertiary);
            ModelPart quaternary = tertiary.m_171324_("TailQuaternary");
            tailParts.add(quaternary);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tailParts;
    }

    public static Vec3 getWorldSpaceFromModelPart(ModelPart part, Vector3f Offset, Vector3f vec3, @NotNull Entity entity, @Nullable Vec3 entityPosOffset, @Nullable Vec3 Rotation2, @Nullable PoseStack ModelPoseStack, boolean affectEntityViewXrot) {
        float f;
        Player player;
        if (Rotation2 == null) {
            Rotation2 = new Vec3(180.0, 0.0, 0.0);
        }
        if (entityPosOffset == null) {
            entityPosOffset = new Vec3(0.0, -0.3, 0.0);
        }
        PoseStack stack = new PoseStack();
        stack.m_85837_(entity.m_20185_() + entityPosOffset.m_7096_(), entity.m_20188_() + entityPosOffset.m_7098_() + (entity instanceof Player && (player = (Player)entity).m_6144_() ? 0.225 : 0.0), entity.m_20189_() + entityPosOffset.m_7094_());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            f = -livingEntity.f_20884_;
        } else {
            f = -entity.f_19859_;
        }
        stack.m_85845_(Vector3f.f_122225_.m_122240_(f));
        if (affectEntityViewXrot) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(entity.m_146909_()));
        }
        stack.m_85845_(Vector3f.f_122225_.m_122240_((float)Rotation2.m_7098_()));
        stack.m_85845_(Vector3f.f_122223_.m_122240_((float)Rotation2.m_7096_()));
        stack.m_85845_(Vector3f.f_122227_.m_122240_((float)Rotation2.m_7094_()));
        part.m_104299_(stack);
        stack.m_85837_((double)Offset.m_122239_(), (double)Offset.m_122260_(), (double)Offset.m_122269_());
        if (ModelPoseStack != null) {
            stack.m_166854_(ModelPoseStack.m_85850_().m_85861_());
        }
        Matrix4f matrix = stack.m_85850_().m_85861_();
        Vector4f pos = new Vector4f(vec3.m_122239_(), vec3.m_122260_(), vec3.m_122269_(), 1.0f);
        pos.m_123607_(matrix);
        return new Vec3((double)pos.m_123601_(), (double)pos.m_123615_(), (double)pos.m_123616_());
    }

    public static Vec3 getWorldSpaceFromModelPart(ModelPart part, Vector3f Offset, Vector3f vec3, @NotNull Entity entity, @Nullable Vec3 entityPosOffset, @Nullable Vec3 Rotation2, boolean affectEntityViewXrot) {
        return ModelUtils.getWorldSpaceFromModelPart(part, Offset, vec3, entity, entityPosOffset, Rotation2, null, affectEntityViewXrot);
    }

    public static AABB getModelPartBounds(ModelPart part) {
        ModelPart.Cube partCube = part.m_104328_(new Random());
        return new AABB((double)partCube.f_104335_, (double)partCube.f_104336_, (double)partCube.f_104337_, (double)partCube.f_104338_, (double)partCube.f_104339_, (double)partCube.f_104340_);
    }

    public static AABB getModelPartBounds(ModelPart part, ModelPart.Cube partCube) {
        return new AABB((double)partCube.f_104335_, (double)partCube.f_104336_, (double)partCube.f_104337_, (double)partCube.f_104338_, (double)partCube.f_104339_, (double)partCube.f_104340_);
    }

    public static Vec3 getPartWorldPosForParticles(Entity entity, ModelPart part, float partialTicks) {
        double x = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20188_());
        double z = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
        float bodyYawRad = (float)Math.toRadians(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_()));
        Vec3 local = new Vec3((double)part.f_104200_, (double)part.f_104201_, (double)part.f_104202_).m_82490_(0.0625);
        local = local.m_82535_(part.f_104205_);
        local = local.m_82524_(part.f_104204_);
        local = local.m_82496_(part.f_104203_);
        local = local.m_82496_((float)Math.toRadians(0.0));
        local = local.m_82524_(-bodyYawRad);
        return new Vec3(x + local.f_82479_, y + local.f_82480_, z + local.f_82481_);
    }

    public static void applyMirroredRotation(ModelPart part, PoseStack stack) {
        stack.m_85845_(Vector3f.f_122227_.m_122270_(-part.f_104205_));
        stack.m_85845_(Vector3f.f_122225_.m_122270_(-part.f_104204_));
        stack.m_85845_(Vector3f.f_122223_.m_122270_(-part.f_104203_));
    }

    private static Vec3 applyRotation(Vec3 localPos, float rotation) {
        double rad = Math.toRadians(rotation);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double x = localPos.f_82479_ * cos - localPos.f_82481_ * sin;
        double z = localPos.f_82479_ * sin + localPos.f_82481_ * cos;
        return new Vec3(x, localPos.f_82480_, z);
    }

    public static Vec3 applyRotationToVec3(Vec3 local, float xRot, float yRot, float zRot) {
        if (xRot == 0.0f && yRot == 0.0f && zRot == 0.0f) {
            return local;
        }
        Quaternion q = Quaternion.f_80118_.m_80161_();
        if (zRot != 0.0f) {
            q.m_80148_(Vector3f.f_122227_.m_122240_(zRot));
        }
        if (yRot != 0.0f) {
            q.m_80148_(Vector3f.f_122225_.m_122240_(yRot));
        }
        if (xRot != 0.0f) {
            q.m_80148_(Vector3f.f_122223_.m_122240_(xRot));
        }
        Vector3f localVector = new Vector3f((float)local.f_82479_, (float)local.f_82480_, (float)local.f_82481_);
        localVector.m_122251_(q);
        return new Vec3((double)localVector.m_122239_(), (double)localVector.m_122260_(), (double)localVector.m_122269_());
    }

    @Nullable
    public static EntityModel<?> getModelOf(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity living = (LivingEntity)entity;
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityRenderer = dispatcher.m_114382_((Entity)living);
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return null;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        return livingRenderer.m_7200_();
    }

    public static EntityModel<?> getModelOfEntity(Entity entity) {
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_(entity);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            return livingRenderer.m_7200_();
        }
        return null;
    }

    public static AdvancedHumanoidModel<?> getChangedEntityModel(ChangedEntity entity) {
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        if (renderer instanceof AdvancedHumanoidRenderer) {
            AdvancedHumanoidRenderer advRenderer = (AdvancedHumanoidRenderer)renderer;
            return (AdvancedHumanoidModel)advRenderer.m_7200_();
        }
        return null;
    }

    @Nullable
    public static AdvancedHumanoidRenderer getChangedEntityRender(ChangedEntity entity) {
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        if (renderer instanceof AdvancedHumanoidRenderer) {
            AdvancedHumanoidRenderer advRenderer = (AdvancedHumanoidRenderer)renderer;
            return advRenderer;
        }
        return null;
    }

    @Nullable
    public static AdvancedHumanoidRenderer<ChangedEntity, AdvancedHumanoidModel<ChangedEntity>, LatexHumanoidArmorModel<ChangedEntity, ?>> getChangedEntityRenderNonRaw(ChangedEntity entity) {
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        if (renderer instanceof AdvancedHumanoidRenderer) {
            AdvancedHumanoidRenderer advRenderer = (AdvancedHumanoidRenderer)renderer;
            return advRenderer;
        }
        return null;
    }
}

