/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.util;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.foxyas.changedaddon.init.ChangedAddonSoundEvents;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.TransfurContext;
import net.ltxprogrammer.changed.entity.beast.AbstractLatexWolf;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedRegistry;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PlayerUtil {
    public static void TransfurPlayer(Entity entity, TransfurVariant<?> latexVariant) {
        LivingEntity livingEntity = (LivingEntity)entity;
        ProcessTransfur.transfur((LivingEntity)livingEntity, (Level)entity.m_183503_(), latexVariant, (boolean)true);
    }

    public static void TransfurPlayer(Player player, String id, float progress) {
        TransfurVariant latexVariant;
        ResourceLocation form = ResourceLocation.m_135820_((String)id);
        TransfurVariant transfurVariant = latexVariant = form == null ? null : (TransfurVariant)ChangedRegistry.TRANSFUR_VARIANT.get().getValue(form);
        if (latexVariant == null) {
            return;
        }
        ProcessTransfur.setPlayerTransfurVariant((Player)player, (TransfurVariant)latexVariant, (TransfurContext)TransfurContext.hazard((TransfurCause)TransfurCause.GRAB_REPLICATE), (float)progress);
    }

    public static void TransfurPlayerAndLoadData(Player player, String id, CompoundTag data, float progress) {
        TransfurVariant latexVariant;
        ResourceLocation form = ResourceLocation.m_135820_((String)id);
        TransfurVariant transfurVariant = latexVariant = form == null ? null : (TransfurVariant)ChangedRegistry.TRANSFUR_VARIANT.get().getValue(form);
        if (latexVariant == null) {
            return;
        }
        TransfurVariantInstance tf = ProcessTransfur.setPlayerTransfurVariant((Player)player, (TransfurVariant)latexVariant, (TransfurContext)TransfurContext.hazard((TransfurCause)TransfurCause.GRAB_REPLICATE), (float)progress);
        if (tf != null) {
            CompoundTag save = tf.save();
            save.m_128391_(data);
            tf.load(save);
        }
    }

    public static void UnTransfurPlayer(Player player) {
        ProcessTransfur.ifPlayerTransfurred((Player)player, variant -> {
            variant.unhookAll(player);
            ProcessTransfur.removePlayerTransfurVariant((Player)player);
            ProcessTransfur.setPlayerTransfurProgress((Player)player, (float)0.0f);
        });
    }

    public static void UnTransfurPlayer(Player player, boolean shouldApplyEffects) {
        ProcessTransfur.ifPlayerTransfurred((Player)player, variant -> {
            variant.unhookAll(player);
            ProcessTransfur.removePlayerTransfurVariant((Player)player);
            ProcessTransfur.setPlayerTransfurProgress((Player)player, (float)0.0f);
            if (shouldApplyEffects && !player.m_183503_().m_5776_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 0, false, false));
            }
        });
    }

    public static void UnTransfurPlayerAndPlaySound(Player player, boolean shouldApplyEffects) {
        ProcessTransfur.ifPlayerTransfurred((Player)player, variant -> {
            variant.unhookAll(player);
            ProcessTransfur.removePlayerTransfurVariant((Player)player);
            ProcessTransfur.setPlayerTransfurProgress((Player)player, (float)0.0f);
            if (shouldApplyEffects && !player.m_183503_().m_5776_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 0, false, false));
                Level patt4681$temp = player.m_183503_();
                if (patt4681$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt4681$temp;
                    serverLevel.m_6263_(null, player.m_20185_(), player.m_20188_(), player.m_20189_(), ChangedAddonSoundEvents.UNTRANSFUR, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        });
    }

    public static boolean isCatTransfur(Player player) {
        TransfurVariant variant = ProcessTransfur.getPlayerTransfurVariant((Player)player).getParent();
        return variant.is(ChangedAddonTags.TransfurTypes.CAT_LIKE) || variant.is(ChangedAddonTags.TransfurTypes.LEOPARD_LIKE);
    }

    public static boolean isWolfTransfur(Player player) {
        TransfurVariant variant = Objects.requireNonNull(ProcessTransfur.getPlayerTransfurVariant((Player)player)).getParent();
        if (variant.is(ChangedAddonTags.TransfurTypes.WOLF_LIKE)) {
            return true;
        }
        ChangedEntity entity = Objects.requireNonNull(ProcessTransfur.getPlayerTransfurVariant((Player)player)).getChangedEntity();
        return Objects.requireNonNull(entity.m_6095_().getRegistryName()).toString().contains("dog") || entity.m_6095_().getRegistryName().toString().contains("wolf") || entity instanceof AbstractLatexWolf;
    }

    @Nullable
    public static Entity getEntityPlayerLookingAt(Player player, double range) {
        Level world = player.f_19853_;
        Vec3 startVec = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20154_();
        Vec3 endVec = startVec.m_82549_(lookVec.m_82490_(range));
        Entity closestEntity = null;
        double closestDistance = range;
        for (Entity entity : world.m_45933_((Entity)player, player.m_142469_().m_82369_(lookVec.m_82490_(range)).m_82400_(1.0))) {
            double distanceToEntity;
            AABB entityBoundingBox;
            if (entity.m_5833_() || !(entityBoundingBox = entity.m_142469_().m_82400_((double)entity.m_6143_())).m_82390_(startVec) && !entityBoundingBox.m_82371_(startVec, endVec).isPresent() || !((distanceToEntity = startVec.m_82554_(entity.m_20182_())) < closestDistance)) continue;
            closestEntity = entity;
            closestDistance = distanceToEntity;
        }
        return closestEntity;
    }

    @Nullable
    public static Entity getEntityPlayerLookingAt(Entity player, double range) {
        Level world = player.f_19853_;
        Vec3 startVec = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20154_();
        Vec3 endVec = startVec.m_82549_(lookVec.m_82490_(range));
        Entity closestEntity = null;
        double closestDistance = range;
        for (Entity entity : world.m_45933_(player, player.m_142469_().m_82369_(lookVec.m_82490_(range)).m_82400_(1.0))) {
            double distanceToEntity;
            AABB entityBoundingBox;
            if (entity.m_5833_() || !(entityBoundingBox = entity.m_142469_().m_82400_((double)entity.m_6143_())).m_82390_(startVec) && !entityBoundingBox.m_82371_(startVec, endVec).isPresent() || !((distanceToEntity = startVec.m_82554_(entity.m_20182_())) < closestDistance)) continue;
            closestEntity = entity;
            closestDistance = distanceToEntity;
        }
        return closestEntity;
    }

    @Nullable
    public static Entity getEntityLookingAt(Entity entity, double reach) {
        AABB aabb;
        double distance = reach * reach;
        Vec3 eyePos = entity.m_20299_(1.0f);
        HitResult hitResult = entity.m_19907_(reach, 1.0f, false);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            distance = hitResult.m_82450_().m_82557_(eyePos);
        }
        Vec3 viewVec = entity.m_20252_(1.0f);
        Vec3 toVec = eyePos.m_82520_(viewVec.f_82479_ * reach, viewVec.f_82480_ * reach, viewVec.f_82481_ * reach);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)eyePos, (Vec3)toVec, (AABB)(aabb = entity.m_142469_().m_82369_(viewVec.m_82490_(reach)).m_82377_(1.0, 1.0, 1.0)), e -> !e.m_5833_(), (double)distance);
        if (entityHitResult != null) {
            Entity hitEntity = entityHitResult.m_82443_();
            if (eyePos.m_82557_(entityHitResult.m_82450_()) <= reach * reach) {
                return hitEntity;
            }
        }
        return null;
    }

    @Nullable
    public static EntityHitResult getEntityHitLookingAt(Entity entity, float reach, boolean testLineOfSight) {
        return PlayerUtil.getEntityHitLookingAt(entity, reach, testLineOfSight, e -> !e.m_5833_());
    }

    @Nullable
    public static EntityHitResult getEntityHitLookingAt(Entity entity, float reach, boolean testLineOfSight, Predicate<Entity> targetPredicate) {
        HitResult hitResult;
        double reachSqr = reach * reach;
        Vec3 eyePos = entity.m_146892_();
        if (testLineOfSight && (hitResult = entity.m_19907_((double)reach, 1.0f, false)).m_6662_() != HitResult.Type.MISS) {
            reachSqr = hitResult.m_82450_().m_82557_(eyePos);
            reach = (float)Math.sqrt(reachSqr);
        }
        Vec3 viewVec = entity.m_20154_();
        Vec3 toVec = eyePos.m_82520_(viewVec.f_82479_ * (double)reach, viewVec.f_82480_ * (double)reach, viewVec.f_82481_ * (double)reach);
        return ProjectileUtil.m_37287_((Entity)entity, (Vec3)eyePos, (Vec3)toVec, (AABB)new AABB(eyePos, toVec), targetPredicate, (double)reachSqr);
    }

    public static HitResult getEntityBlockHitLookingAt(Entity entity, double reach, float deltaTicks, boolean affectByFluids) {
        return entity.m_19907_(reach, deltaTicks, affectByFluids);
    }

    @Nullable
    public static Vec3 getRelativeHitPosition(LivingEntity entity, float distance) {
        EntityHitResult hitResult = PlayerUtil.getEntityHitLookingAt((Entity)entity, distance, true);
        if (hitResult != null) {
            Vec3 hitLocation = hitResult.m_82450_();
            Vec3 entityPosition = hitResult.m_82443_().m_20318_(1.0f);
            return hitLocation.m_82546_(entityPosition);
        }
        return null;
    }

    public static boolean isLineOfSightClear(Player player, Entity entity) {
        Vec3 entityEyePos;
        Vec3 playerEyePos;
        Level level = player.m_183503_();
        BlockHitResult result = level.m_45547_(new ClipContext(playerEyePos = player.m_20299_(1.0f), entityEyePos = entity.m_142469_().m_82399_(), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
        return result.m_6662_() == HitResult.Type.MISS;
    }

    @Nullable
    public static Entity getEntityPlayerLookingAtType2(Entity entity, Entity player, double entityReach) {
        AABB aabb;
        double blockReach;
        double distance = entityReach * entityReach;
        Vec3 eyePos = player.m_20299_(1.0f);
        HitResult hitResult = entity.m_19907_(entityReach, 1.0f, false);
        if (hitResult.m_6662_() != HitResult.Type.MISS && (distance = hitResult.m_82450_().m_82557_(eyePos)) > (blockReach = 5.0) * blockReach) {
            Vec3 pos = hitResult.m_82450_();
            hitResult = BlockHitResult.m_82426_((Vec3)pos, (Direction)Direction.m_122366_((double)eyePos.f_82479_, (double)eyePos.f_82480_, (double)eyePos.f_82481_), (BlockPos)new BlockPos(pos));
        }
        Vec3 viewVec = player.m_20252_(1.0f);
        Vec3 toVec = eyePos.m_82520_(viewVec.f_82479_ * entityReach, viewVec.f_82480_ * entityReach, viewVec.f_82481_ * entityReach);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyePos, (Vec3)toVec, (AABB)(aabb = entity.m_142469_().m_82369_(viewVec.m_82490_(entityReach)).m_82377_(1.0, 1.0, 1.0)), p_234237_ -> !p_234237_.m_5833_(), (double)distance);
        if (entityHitResult != null) {
            Entity targetEntity = entityHitResult.m_82443_();
            Vec3 targetPos = entityHitResult.m_82450_();
            double distanceToTarget = eyePos.m_82557_(targetPos);
            if (distanceToTarget > distance || distanceToTarget > entityReach * entityReach) {
                hitResult = BlockHitResult.m_82426_((Vec3)targetPos, (Direction)Direction.m_122366_((double)viewVec.f_82479_, (double)viewVec.f_82480_, (double)viewVec.f_82481_), (BlockPos)new BlockPos(targetPos));
            } else if (distanceToTarget < distance) {
                hitResult = entityHitResult;
            }
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).m_82443_();
        }
        return null;
    }

    public static boolean isProjectileMovingTowardsPlayer(Player player, Entity projectile) {
        Vec3 projectilePosition = projectile.m_20182_();
        Vec3 projectileMotion = projectile.m_20184_();
        Vec3 directionToPlayer = player.m_20182_().m_82546_(projectilePosition).m_82541_();
        return projectileMotion.m_82541_().m_82526_(directionToPlayer) > 0.0;
    }

    public static void shootDynamicLaser(ServerLevel world, Player player, int maxRange, int horizontalRadius, int verticalRadius) {
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 lookDirection = player.m_20154_();
        for (int i = 0; i <= maxRange; ++i) {
            Vec3 targetVec = eyePosition.m_82549_(lookDirection.m_82490_((double)i));
            BlockPos targetPos = new BlockPos(targetVec);
            if (world.m_8055_(targetPos).m_60795_()) continue;
            PlayerUtil.affectSurroundingBlocks((Level)world, targetPos, horizontalRadius, verticalRadius);
        }
    }

    private static void affectSurroundingBlocks(Level world, BlockPos center, int horizontalRadius, int verticalRadius) {
        int horizontalRadiusSphere = horizontalRadius - 1;
        int verticalRadiusSphere = verticalRadius - 1;
        for (int y = -verticalRadiusSphere; y <= verticalRadiusSphere; ++y) {
            block1: for (int x = -horizontalRadiusSphere; x <= horizontalRadiusSphere; ++x) {
                for (int z = -horizontalRadiusSphere; z <= horizontalRadiusSphere; ++z) {
                    double distanceSq = (double)(x * x) / (double)(horizontalRadiusSphere * horizontalRadiusSphere) + (double)(y * y) / (double)(verticalRadiusSphere * verticalRadiusSphere) + (double)(z * z) / (double)(horizontalRadiusSphere * horizontalRadiusSphere);
                    if (!(distanceSq <= 1.0)) continue;
                    BlockPos affectedPos = center.m_142082_(x, y, z);
                    if (world.m_8055_(affectedPos).m_60795_()) continue block1;
                    PlayerUtil.affectBlock(world, affectedPos);
                }
            }
        }
    }

    private static void affectBlock(Level world, BlockPos pos) {
        if (!world.m_8055_(pos).m_60795_()) {
            world.m_7731_(pos, Blocks.f_50058_.m_49966_(), 3);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.1, 0.0);
        }
    }

    public static class GlobalEntityUtil {
        @Nullable
        public static Entity getEntityByUUID(LevelAccessor world, String uuid) {
            try {
                Stream<Entity> entities;
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    entities = StreamSupport.stream(serverLevel.m_8583_().spliterator(), false);
                } else if (world instanceof ClientLevel) {
                    ClientLevel clientLevel = (ClientLevel)world;
                    entities = StreamSupport.stream(clientLevel.m_104735_().spliterator(), false);
                } else {
                    return null;
                }
                return entities.filter(entity -> entity.m_20149_().equals(uuid)).findFirst().orElse(null);
            }
            catch (Exception e) {
                ChangedAddonMod.LOGGER.error(e.getMessage());
                return null;
            }
        }

        @Nullable
        public static Entity getEntityByUUID(ServerLevel serverLevel, String uuid) {
            try {
                Stream<Entity> entities = StreamSupport.stream(serverLevel.m_8583_().spliterator(), false);
                return entities.filter(entity -> entity.m_20149_().equals(uuid)).findFirst().orElse(null);
            }
            catch (Exception e) {
                ChangedAddonMod.LOGGER.error(e.getMessage());
                return null;
            }
        }

        @Nullable
        public static Entity getEntityByName(LevelAccessor world, String name) {
            try {
                Stream<Entity> entities;
                if (world instanceof ClientLevel) {
                    ClientLevel clientLevel = (ClientLevel)world;
                    entities = StreamSupport.stream(clientLevel.m_104735_().spliterator(), false);
                } else if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    entities = StreamSupport.stream(serverLevel.m_8583_().spliterator(), false);
                } else {
                    return null;
                }
                return entities.filter(entity -> {
                    String entityName = entity.m_7755_().getString();
                    return entityName.equalsIgnoreCase(name);
                }).findFirst().orElse(null);
            }
            catch (Exception e) {
                ChangedAddonMod.LOGGER.error("Error getting entity by name: " + e.getMessage());
                return null;
            }
        }
    }
}

