/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.foxyas.changedaddon.util.PlayerUtil;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.GrabEntityAbility;
import net.ltxprogrammer.changed.ability.GrabEntityAbilityInstance;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.beast.WhiteLatexCentaur;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedAbilities;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.init.ChangedTags;
import net.ltxprogrammer.changed.init.ChangedTransfurVariants;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class CarryAbilityInstance
extends AbstractAbilityInstance {
    @Nullable
    public Entity carriedEntity;

    public CarryAbilityInstance(AbstractAbility<CarryAbilityInstance> carryAbilityInstanceAbstractAbility, IAbstractChangedEntity entity) {
        super(carryAbilityInstanceAbstractAbility, entity);
    }

    public boolean canUse() {
        return this.ability.canUse(this.entity);
    }

    public boolean canKeepUsing() {
        return this.ability.canKeepUsing(this.entity);
    }

    public void startUsing() {
        this.Run((Entity)this.entity.getEntity());
    }

    public void tick() {
    }

    public void stopUsing() {
    }

    public void onRemove() {
        super.onRemove();
        this.Run((Entity)this.entity.getEntity());
    }

    public void tickIdle() {
        LocalPlayer player;
        super.tickIdle();
        LivingEntity e = this.entity.getEntity();
        if (!e.m_183503_().m_5776_() || !(e instanceof LocalPlayer) || (player = (LocalPlayer)e).m_146895_() != null) {
            // empty if block
        }
        if (this.carriedEntity == null) {
            return;
        }
        if (!e.m_20160_() || this.carriedEntity.m_20202_() != e) {
            this.onPassengerLost(e, this.carriedEntity);
            this.carriedEntity = null;
            CarryAbilityInstance.broadcastPassengers((Entity)e);
            return;
        }
        Level level = e.f_19853_;
        if (e.m_204029_(FluidTags.f_13131_) && !level.m_8055_(new BlockPos(e.m_20185_(), e.m_20188_(), e.m_20189_())).m_60713_(Blocks.f_50628_)) {
            this.dropPassenger(e);
        }
        if (this.carriedEntity.f_19864_) {
            this.dropPassenger(e);
        }
    }

    private void dropPassenger(LivingEntity e) {
        assert (this.carriedEntity != null);
        this.carriedEntity.m_8127_();
        this.onPassengerLost(e, this.carriedEntity);
        this.carriedEntity = null;
        CarryAbilityInstance.broadcastPassengers((Entity)e);
    }

    private void onPassengerLost(LivingEntity carrier, Entity passenger) {
    }

    @Nullable
    public static Entity carryTarget(Player player) {
        EntityHitResult hitResult = PlayerUtil.getEntityHitLookingAt((Entity)player, (float)player.getAttackRange(), true);
        if (hitResult == null) {
            return null;
        }
        return hitResult.m_82443_();
    }

    public boolean isPossibleToCarry(LivingEntity entity) {
        GrabEntityAbilityInstance ability;
        Player player;
        TransfurVariantInstance variant;
        if (entity instanceof Player && (variant = ProcessTransfur.getPlayerTransfurVariant((Player)(player = (Player)entity))) != null && (ability = (GrabEntityAbilityInstance)variant.getAbilityInstance((AbstractAbility)ChangedAbilities.GRAB_ENTITY_ABILITY.get())) != null && ability.suited && ability.grabbedHasControl) {
            return false;
        }
        return GrabEntityAbility.getGrabber((LivingEntity)entity) == null;
    }

    private static void broadcastPassengers(Entity vehicle) {
        if (!vehicle.f_19853_.f_46443_) {
            ServerLevel sl = (ServerLevel)vehicle.f_19853_;
            sl.m_7726_().m_8394_(vehicle, (Packet)new ClientboundSetPassengersPacket(vehicle));
        }
    }

    private static void broadcastMotion(Entity entity) {
        if (!entity.f_19853_.f_46443_) {
            ServerLevel sl = (ServerLevel)entity.f_19853_;
            sl.m_7726_().m_8394_(entity, (Packet)new ClientboundSetEntityMotionPacket(entity));
        }
    }

    private static void launchForward(Entity launcher, Entity target, double speed) {
        target.m_20256_(launcher.m_20154_().m_82541_().m_82490_(speed));
        target.f_19812_ = true;
        CarryAbilityInstance.broadcastMotion(target);
    }

    private static void soundPlay(Player player) {
        player.f_19853_.m_5594_(null, player.m_142538_(), ChangedSounds.BOW2, SoundSource.PLAYERS, 2.5f, 1.0f);
    }

    private void Run(Entity mainEntity) {
        Player carryPlayer;
        Player p;
        LivingEntity le;
        Player player;
        block12: {
            block11: {
                if (!(mainEntity instanceof Player)) break block11;
                player = (Player)mainEntity;
                if (!player.f_19853_.f_46443_) break block12;
            }
            return;
        }
        Entity carried = player.m_146895_();
        this.setCarriedEntity(carried);
        if (carried != null) {
            boolean toss = !player.m_6144_();
            carried.m_8127_();
            CarryAbilityInstance.broadcastPassengers((Entity)player);
            CarryAbilityInstance.soundPlay(player);
            if (toss) {
                CarryAbilityInstance.launchForward((Entity)player, carried, 1.05);
            }
            this.setCarriedEntity(player.m_146895_());
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        Entity target = CarryAbilityInstance.carryTarget(player);
        this.setCarriedEntity(target);
        if (target == null) {
            return;
        }
        if (target instanceof LivingEntity && !this.isPossibleToCarry(le = (LivingEntity)target)) {
            return;
        }
        if (target instanceof WhiteLatexCentaur || target instanceof Player && ProcessTransfur.getPlayerTransfurVariant((Player)(p = (Player)target)) != null && ProcessTransfur.getPlayerTransfurVariant((Player)p).is((TransfurVariant)ChangedTransfurVariants.WHITE_LATEX_CENTAUR.get())) {
            player.m_5661_((Component)new TranslatableComponent("changedaddon.warn.cant_carry", new Object[]{target.m_5446_()}), true);
            return;
        }
        if (target instanceof Player && (carryPlayer = (Player)target).m_7500_() && !player.m_7500_()) {
            return;
        }
        if ((target.m_6095_().m_204039_(ChangedTags.EntityTypes.HUMANOIDS) || target.m_6095_().m_204039_(ChangedAddonTags.EntityTypes.CAN_CARRY)) && target.m_7998_((Entity)player, true)) {
            CarryAbilityInstance.broadcastPassengers((Entity)player);
            CarryAbilityInstance.soundPlay(player);
        }
    }

    protected void setCarriedEntity(@Nullable Entity carriedEntity) {
        this.carriedEntity = carriedEntity;
    }

    @Nullable
    public Entity getCarriedEntity() {
        return this.carriedEntity;
    }
}

