/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.foxyas.changedaddon.entity.interfaces.IDynamicPawColor;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.ability.SimpleAbility;
import net.ltxprogrammer.changed.client.AbilityColors;
import net.ltxprogrammer.changed.client.gui.AbstractRadialScreen;
import net.ltxprogrammer.changed.data.AccessorySlotType;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.init.ChangedAccessorySlots;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class ClawsAbility
extends SimpleAbility {
    public boolean isActive = false;

    public void saveData(CompoundTag tag, IAbstractChangedEntity entity) {
        super.saveData(tag, entity);
        tag.m_128379_("isActive", this.isActive);
    }

    public void readData(CompoundTag tag, IAbstractChangedEntity entity) {
        super.readData(tag, entity);
        if (tag.m_128441_("isActive")) {
            this.isActive = tag.m_128471_("isActive");
        }
    }

    public ResourceLocation getTexture(IAbstractChangedEntity entity) {
        return new ResourceLocation("changed_addon:textures/screens/paw_with_claws.png");
    }

    public Component getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.claws");
    }

    public static Optional<Integer> getColor(AbstractAbilityInstance abilityInstance, int layer) {
        AbstractRadialScreen.ColorScheme scheme = AbilityColors.getAbilityColors((AbstractAbilityInstance)abilityInstance);
        if (abilityInstance.ability instanceof ClawsAbility) {
            if (abilityInstance.entity.getAccessorySlots().stream().anyMatch(accessorySlots -> accessorySlots.hasSlot((AccessorySlotType)ChangedAccessorySlots.BODY.get()))) {
                if (layer == 0) {
                    return Optional.of(scheme.foreground().toInt());
                }
            } else if (abilityInstance.entity.getAccessorySlots().stream().noneMatch(accessorySlots -> accessorySlots.hasSlot((AccessorySlotType)ChangedAccessorySlots.BODY.get()))) {
                ChangedEntity changedEntity;
                if (layer == 1) {
                    ChangedEntity changedEntity2 = abilityInstance.entity.getChangedEntity();
                    if (changedEntity2 instanceof IDynamicPawColor) {
                        IDynamicPawColor dynamicPawColor = (IDynamicPawColor)changedEntity2;
                        return Optional.of(dynamicPawColor.getPawColor().getRGB());
                    }
                    return Optional.of(scheme.foreground().toInt());
                }
                if (layer == 2 && (changedEntity = abilityInstance.entity.getChangedEntity()) instanceof IDynamicPawColor) {
                    IDynamicPawColor dynamicPawColor = (IDynamicPawColor)changedEntity;
                    return Optional.of(dynamicPawColor.getPawBeansColor().getRGB());
                }
            }
        }
        return Optional.empty();
    }

    public Collection<Component> getAbilityDescription(IAbstractChangedEntity entity) {
        ArrayList<Component> description = new ArrayList<Component>(super.getAbilityDescription(entity));
        description.add((Component)new TranslatableComponent("changed_addon.ability.claws.desc"));
        return description;
    }

    public AbstractAbility.UseType getUseType(IAbstractChangedEntity entity) {
        return AbstractAbility.UseType.INSTANT;
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        return 2;
    }

    public boolean canUse(IAbstractChangedEntity entity) {
        if (entity.getTransfurVariantInstance() == null) {
            return false;
        }
        return entity.getTransfurVariantInstance().getParent().is(ChangedAddonTags.TransfurTypes.HAS_CLAWS) || entity.getTransfurVariantInstance().getParent().is(ChangedAddonTags.TransfurTypes.CAT_LIKE) || entity.getTransfurVariantInstance().getParent().is(ChangedAddonTags.TransfurTypes.LEOPARD_LIKE);
    }

    public boolean canKeepUsing(IAbstractChangedEntity entity) {
        if (entity.getTransfurVariantInstance() == null) {
            return false;
        }
        return entity.getTransfurVariantInstance().getParent().is(ChangedAddonTags.TransfurTypes.HAS_CLAWS) || entity.getTransfurVariantInstance().getParent().is(ChangedAddonTags.TransfurTypes.CAT_LIKE) || entity.getTransfurVariantInstance().getParent().is(ChangedAddonTags.TransfurTypes.LEOPARD_LIKE);
    }

    public void startUsing(IAbstractChangedEntity entity) {
        if (!entity.getLevel().m_5776_()) {
            this.TurnOnClaws();
            this.setDirty(entity);
        }
    }

    public void TurnOnClaws() {
        this.isActive = !this.isActive;
    }
}

