/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.util.ArrayList;
import java.util.Collection;
import net.foxyas.changedaddon.abilities.CustomInteractionInstance;
import net.foxyas.changedaddon.entity.advanced.AvaliEntity;
import net.foxyas.changedaddon.entity.advanced.LatexSnepEntity;
import net.foxyas.changedaddon.entity.advanced.LuminaraFlowerBeastEntity;
import net.foxyas.changedaddon.entity.defaults.AbstractLuminarcticLeopard;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CustomInteraction
extends AbstractAbility<CustomInteractionInstance> {
    public CustomInteraction() {
        super(CustomInteractionInstance::new);
    }

    public TranslatableComponent getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.custom_interaction");
    }

    public ResourceLocation getTexture(IAbstractChangedEntity entity) {
        return new ResourceLocation("changed_addon:textures/screens/normal_paw.png");
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        if (entity.getChangedEntity() instanceof AvaliEntity) {
            return 160;
        }
        return super.getCoolDown(entity);
    }

    public Collection<Component> getAbilityDescription(IAbstractChangedEntity entity) {
        ArrayList<Component> description = new ArrayList<Component>(super.getAbilityDescription(entity));
        if (entity.getChangedEntity() instanceof LatexSnepEntity) {
            description.add((Component)new TranslatableComponent("changed_addon.ability.custom_interaction.have_interaction.latex_snep"));
        } else {
            ChangedEntity changedEntity = entity.getChangedEntity();
            if (changedEntity instanceof AvaliEntity) {
                AvaliEntity avaliEntity = (AvaliEntity)changedEntity;
                description.add((Component)new TranslatableComponent("changed_addon.ability.custom_interaction.have_interaction.avali"));
                description.add((Component)new TranslatableComponent("changed_addon.ability.custom_interaction.have_interaction.avali.extra", new Object[]{Float.valueOf(avaliEntity.getDimensionScale())}));
            } else {
                changedEntity = entity.getChangedEntity();
                if (changedEntity instanceof LuminaraFlowerBeastEntity) {
                    LuminaraFlowerBeastEntity luminaraFlowerBeast = (LuminaraFlowerBeastEntity)changedEntity;
                    TranslatableComponent luminaraBeastDescription = new TranslatableComponent("changed_addon.ability.custom_interaction.have_interaction.luminara_beast");
                    String string = luminaraBeastDescription.getString();
                    description.add((Component)new TextComponent(string).m_130938_(style -> style.m_178524_(Boolean.valueOf(!luminaraFlowerBeast.isHyperAwakened()))));
                    if (luminaraFlowerBeast.isHyperAwakened()) {
                        TranslatableComponent luminaraBeastDescriptionExtra = new TranslatableComponent("changed_addon.ability.custom_interaction.have_interaction.luminara_beast.extra", new Object[]{luminaraFlowerBeast.spawnParticles});
                        description.add((Component)luminaraBeastDescriptionExtra);
                    }
                } else if (entity.getChangedEntity() instanceof AbstractLuminarcticLeopard) {
                    description.add((Component)new TranslatableComponent("changed_addon.ability.custom_interaction.have_interaction.luminarctic_leopards"));
                }
            }
        }
        return description;
    }

    @Nullable
    public Component getSelectedDisplayText(IAbstractChangedEntity entity) {
        if (entity.getChangedEntity() instanceof LatexSnepEntity || entity.getChangedEntity() instanceof AbstractLuminarcticLeopard) {
            return new TranslatableComponent("changed_addon.ability.custom_interaction.have_interaction");
        }
        if (entity.getChangedEntity() instanceof AvaliEntity) {
            return new TranslatableComponent("changed_addon.ability.custom_interaction.have_interaction.avali");
        }
        return super.getSelectedDisplayText(entity);
    }
}

