/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import net.foxyas.changedaddon.entity.advanced.LatexSnepEntity;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.ability.SimpleAbility;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class LeapAbility
extends SimpleAbility {
    private static void leapAbility(Entity entity, IAbstractChangedEntity iAbstractChangedEntity) {
        Player player;
        if (!(entity instanceof Player) || (player = (Player)entity).m_36324_().m_38702_() <= 6) {
            return;
        }
        if (!player.m_20096_() || player.m_20069_() || player.m_5833_()) {
            return;
        }
        double speed = 0.6;
        if (!player.m_6144_()) {
            player.m_20256_(player.m_20184_().m_82549_(player.m_20252_(1.0f).m_82542_(speed, speed, speed)));
            LeapAbility.playSound(player);
            LeapAbility.exhaustPlayer(player, 0.5f);
        } else {
            double targetY = player.m_20252_((float)1.0f).f_82480_;
            double motionX = -Math.sin(Math.toRadians(player.m_146908_())) * 0.15;
            double motionY = targetY * (double)0.8f;
            double motionZ = Math.cos(Math.toRadians(player.m_146908_())) * 0.15;
            float multiplier = iAbstractChangedEntity.getSelfVariant() == ChangedAddonTransfurVariants.LATEX_SNEP.get() || iAbstractChangedEntity.getSelfVariant() == ChangedAddonTransfurVariants.LATEX_SNEP_FERAL_FORM.get() ? 1.3f : 1.0f;
            player.m_20256_(player.m_20184_().m_82520_(motionX, motionY * (double)multiplier, motionZ));
            LeapAbility.playSound(player);
            LeapAbility.applyFatigue(player, motionY);
            if (motionY * (double)multiplier >= 0.75) {
                LeapAbility.grantAdvancement(player, "changed_addon:leaper");
            }
        }
    }

    private static void playSound(Player player) {
        if (!player.f_19853_.m_5776_()) {
            player.f_19853_.m_5594_(null, player.m_142538_(), ChangedSounds.BOW2, player.m_5720_(), 2.5f, 1.0f);
        }
    }

    private static void exhaustPlayer(Player player, float exhaustion) {
        if (!player.m_7500_()) {
            player.m_36399_(exhaustion);
        }
    }

    private static void applyFatigue(Player player, double motionY) {
        if (!player.m_7500_()) {
            player.m_36399_((float)(motionY * 0.25));
        }
    }

    private static void grantAdvancement(Player player, String advancementId) {
        ServerPlayer serverPlayer;
        block7: {
            block6: {
                if (!(player instanceof ServerPlayer)) break block6;
                serverPlayer = (ServerPlayer)player;
                if (serverPlayer.f_19853_ instanceof ServerLevel) break block7;
            }
            return;
        }
        Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(new ResourceLocation(advancementId));
        if (advancement == null) {
            return;
        }
        AdvancementProgress progress = serverPlayer.m_8960_().m_135996_(advancement);
        if (!progress.m_8193_()) {
            for (String criterion : progress.m_8219_()) {
                serverPlayer.m_8960_().m_135988_(advancement, criterion);
            }
        }
    }

    public TranslatableComponent getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.leap");
    }

    public ResourceLocation getTexture(IAbstractChangedEntity entity) {
        return new ResourceLocation("changed_addon:textures/screens/leap_ability.png");
    }

    public boolean canUse(IAbstractChangedEntity entity) {
        TransfurVariant variant = entity.getChangedEntity().getSelfVariant();
        return variant.is(ChangedAddonTags.TransfurTypes.CAT_LIKE) || variant.is(ChangedAddonTags.TransfurTypes.LEOPARD_LIKE);
    }

    public AbstractAbility.UseType getUseType(IAbstractChangedEntity entity) {
        if (entity.getChangedEntity() instanceof LatexSnepEntity) {
            return AbstractAbility.UseType.INSTANT;
        }
        return AbstractAbility.UseType.CHARGE_RELEASE;
    }

    public int getChargeTime(IAbstractChangedEntity entity) {
        return 2;
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        return 15;
    }

    public void startUsing(IAbstractChangedEntity entity) {
        super.startUsing(entity);
        if (entity.getEntity() != null) {
            LeapAbility.leapAbility((Entity)entity.getEntity(), entity);
        }
    }
}

