/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.foxyas.changedaddon.entity.advanced.LuminaraFlowerBeastEntity;
import net.foxyas.changedaddon.network.PacketUtil;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.ability.SimpleAbility;
import net.ltxprogrammer.changed.client.AbilityColors;
import net.ltxprogrammer.changed.client.gui.AbstractRadialScreen;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LuminaraFireballAbility
extends SimpleAbility {
    public TranslatableComponent getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.fireball");
    }

    public Collection<Component> getAbilityDescription(IAbstractChangedEntity entity) {
        ArrayList<Component> description = new ArrayList<Component>(super.getAbilityDescription(entity));
        description.add((Component)new TranslatableComponent("changed_addon.ability.fireball.desc"));
        return description;
    }

    public boolean canUse(IAbstractChangedEntity entity) {
        return entity.getChangedEntity() instanceof LuminaraFlowerBeastEntity;
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        return 80;
    }

    public void startUsing(IAbstractChangedEntity entity) {
        ChangedEntity changedEntity = entity.getChangedEntity();
        if (!(changedEntity instanceof LuminaraFlowerBeastEntity)) {
            return;
        }
        LuminaraFlowerBeastEntity holder = (LuminaraFlowerBeastEntity)changedEntity;
        Level level = entity.getLevel();
        Vec3 view = holder.m_20154_();
        Object fireball = holder.isAwakened() ? (holder.m_6144_() ? new LargeFireball(level, (LivingEntity)holder, view.f_82479_, view.f_82480_, view.f_82481_, 1) : new DragonFireball(level, (LivingEntity)holder, view.f_82479_, view.f_82480_, view.f_82481_)) : new SmallFireball(level, entity.getEntity(), view.f_82479_, view.f_82480_, view.f_82481_);
        Vec3 eyesPosition = holder.m_146892_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketUtil.playSound(serverLevel, serverPlayer -> true, eyesPosition, SoundEvents.f_11923_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else {
            level.m_6263_(null, eyesPosition.f_82479_, eyesPosition.f_82480_, eyesPosition.f_82481_, SoundEvents.f_11923_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        fireball.m_20219_(holder.getMouthPosition().m_82549_(view.m_82490_(0.25)));
        level.m_7967_((Entity)fireball);
    }

    public static Optional<Integer> getColor(AbstractAbilityInstance abilityInstance, int layer) {
        AbstractRadialScreen.ColorScheme scheme = AbilityColors.getAbilityColors((AbstractAbilityInstance)abilityInstance);
        IAbstractChangedEntity entity = abilityInstance.entity;
        ChangedEntity changedEntity = entity.getChangedEntity();
        if (!(changedEntity instanceof LuminaraFlowerBeastEntity)) {
            return Optional.of(scheme.foreground().toInt());
        }
        LuminaraFlowerBeastEntity holder = (LuminaraFlowerBeastEntity)changedEntity;
        if (holder.isAwakened()) {
            if (holder.m_6144_() && layer == 0) {
                return Optional.of(scheme.foreground().toInt());
            }
            if (layer == 1 && !holder.m_6144_()) {
                return Optional.of(scheme.foreground().toInt());
            }
        } else if (layer == 0) {
            return Optional.of(scheme.foreground().toInt());
        }
        return Optional.empty();
    }
}

