/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import net.foxyas.changedaddon.util.ParticlesUtil;
import net.foxyas.changedaddon.util.PlayerUtil;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class PollenCarryAbilityInstance
extends AbstractAbilityInstance {
    private int withPollenTicks;

    public PollenCarryAbilityInstance(AbstractAbility<PollenCarryAbilityInstance> ability, IAbstractChangedEntity entity) {
        super(ability, entity);
    }

    public boolean canUse() {
        return this.ability.canUse(this.entity);
    }

    public boolean canKeepUsing() {
        return this.ability.canKeepUsing(this.entity);
    }

    public void startUsing() {
        double d;
        LivingEntity livingEntity = this.entity.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            d = player.getReachDistance();
        } else {
            d = 4.0;
        }
        HitResult entityBlockHitLookingAt = PlayerUtil.getEntityBlockHitLookingAt((Entity)livingEntity, d, 1.0f, false);
        if (entityBlockHitLookingAt.m_6662_() != HitResult.Type.MISS && entityBlockHitLookingAt instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)entityBlockHitLookingAt;
            Level level = livingEntity.m_183503_();
            BlockState blockState = level.m_8055_(blockHitResult.m_82425_());
            Item item = blockState.m_60734_().m_5456_();
            ItemStack itemStack = new ItemStack((ItemLike)item);
            if (itemStack.m_204117_(ItemTags.f_13149_) || blockState.m_204336_(BlockTags.f_13045_)) {
                this.withPollenTicks = 120;
                livingEntity.m_6674_(InteractionHand.MAIN_HAND);
                this.entity.displayClientMessage((Component)new TranslatableComponent("changed_addon.ability.pollen_carry.display.can"), true);
            } else {
                this.entity.displayClientMessage((Component)new TranslatableComponent("changed_addon.ability.pollen_carry.display.cant"), true);
            }
        }
    }

    public void tickIdle() {
        if (this.withPollenTicks <= 0) {
            return;
        }
        LivingEntity livingEntity = this.entity.getEntity();
        Level level = livingEntity.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (livingEntity.f_19797_ % 10 == 0) {
                ParticlesUtil.sendParticles((Level)serverLevel, (ParticleOptions)ParticleTypes.f_123782_, livingEntity.m_20182_().m_82520_(0.0, 1.0, 0.0), 0.3f, 0.3f, 0.3f, 5, 1.0f);
                this.growNearbyCrops(serverLevel, livingEntity);
                --this.withPollenTicks;
            }
        }
    }

    private void growNearbyCrops(ServerLevel serverLevel, LivingEntity entity) {
        BlockPos basePos = entity.m_142538_();
        for (int i = -1; i <= 2; ++i) {
            boolean grown;
            BlockPos pos = basePos.m_6625_(i);
            BlockState state = serverLevel.m_8055_(pos);
            if (!state.m_204336_(BlockTags.f_13074_)) continue;
            boolean bl = grown = this.tryGrowCrop(serverLevel, pos, state) || this.tryGrowStem(serverLevel, pos, state) || this.tryGrowBerryBush(serverLevel, pos, state) || this.tryGrowCaveVine(serverLevel, pos, state);
            if (!grown) continue;
            serverLevel.m_46796_(2005, pos, 0);
        }
    }

    private boolean tryGrowCrop(ServerLevel level, BlockPos pos, BlockState state) {
        CropBlock crop;
        Block block = state.m_60734_();
        if (block instanceof CropBlock && !(crop = (CropBlock)block).m_52307_(state)) {
            IntegerProperty age = crop.m_7959_();
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)age, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)age) + 1)));
            return true;
        }
        return false;
    }

    private boolean tryGrowStem(ServerLevel level, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof StemBlock) {
            StemBlock stem = (StemBlock)block;
            int age = (Integer)state.m_61143_((Property)StemBlock.f_57013_);
            if (age < 7) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(age + 1)));
                return true;
            }
        }
        return false;
    }

    private boolean tryGrowBerryBush(ServerLevel level, BlockPos pos, BlockState state) {
        int age;
        if (state.m_60713_(Blocks.f_50685_) && (age = ((Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_)).intValue()) < 3) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(age + 1)));
            return true;
        }
        return false;
    }

    private boolean tryGrowCaveVine(ServerLevel level, BlockPos pos, BlockState state) {
        if (state.m_60713_(Blocks.f_152538_) || state.m_60713_(Blocks.f_152539_)) {
            ((BonemealableBlock)state.m_60734_()).m_7719_(level, level.m_5822_(), pos, state);
            return true;
        }
        return false;
    }

    public void tick() {
        this.ability.tick(this.entity);
    }

    public void stopUsing() {
        this.ability.stopUsing(this.entity);
    }

    public void onRemove() {
        this.ability.onRemove(this.entity);
    }

    public void saveData(CompoundTag tag) {
        tag.m_128405_("withPollenTicks", this.withPollenTicks);
    }

    public void readData(CompoundTag tag) {
        this.withPollenTicks = tag.m_128451_("withPollenTicks");
    }
}

