/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import net.foxyas.changedaddon.mixins.entity.projectiles.AbstractArrowAccessor;
import net.foxyas.changedaddon.util.FoxyasUtils;
import net.foxyas.changedaddon.util.PlayerUtil;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.GrabEntityAbility;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.ability.SimpleAbility;
import net.ltxprogrammer.changed.ability.SimpleAbilityInstance;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PsychicGrab
extends SimpleAbility {
    public static final Set<Integer> Keys = Set.of(Integer.valueOf(265), Integer.valueOf(264), Integer.valueOf(263), Integer.valueOf(262));
    public Vec3 offset = Vec3.f_82478_;
    public Vec3 look = Vec3.f_82478_;
    public UUID TargetID = UUID.fromString("0-0-0-0-0");
    private AbstractAbilityInstance abilityInstance;
    private AbstractAbility.Controller controller;

    public static boolean isSpectator(Entity entity) {
        Player player;
        return entity instanceof Player && (player = (Player)entity).m_5833_();
    }

    public SimpleAbilityInstance makeInstance(IAbstractChangedEntity entity) {
        this.offset = new Vec3(0.0, 0.0, 3.0);
        LivingEntity livingEntity = entity.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.look = FoxyasUtils.getRelativePositionEyes((Entity)player, this.offset.m_82490_(0.1));
        }
        SimpleAbilityInstance simpleAbilityInstance = (SimpleAbilityInstance)super.makeInstance(entity);
        this.abilityInstance = simpleAbilityInstance;
        return simpleAbilityInstance;
    }

    @Nullable
    public Component getSelectedDisplayText(IAbstractChangedEntity entity) {
        return super.getSelectedDisplayText(entity);
    }

    public TranslatableComponent getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.psychic_grab");
    }

    public ResourceLocation getTexture(IAbstractChangedEntity entity) {
        return new ResourceLocation("changed_addon:textures/screens/psychic_hold.png");
    }

    public Collection<Component> getAbilityDescription(IAbstractChangedEntity entity) {
        ArrayList<Component> descriptions = new ArrayList<Component>(super.getAbilityDescription(entity));
        descriptions.add((Component)new TranslatableComponent("changed_addon.ability.psychic_grab.description"));
        return descriptions;
    }

    @Nullable
    public Entity getTargetByID(Level level, UUID uuid) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return PlayerUtil.GlobalEntityUtil.getEntityByUUID(serverLevel, uuid.toString());
        }
        return null;
    }

    @Nullable
    public Entity getTargetByIDInClientSide(Level level, UUID uuid) {
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            return PlayerUtil.GlobalEntityUtil.getEntityByUUID((LevelAccessor)clientLevel, uuid.toString());
        }
        return null;
    }

    @Nullable
    public Entity getTarget(Level level, UUID uuid) {
        return PlayerUtil.GlobalEntityUtil.getEntityByUUID((LevelAccessor)level, uuid.toString());
    }

    public AbstractAbility.UseType getUseType(IAbstractChangedEntity entity) {
        Entity target = this.getTarget(entity.getEntity().m_183503_(), this.TargetID);
        return target != null ? AbstractAbility.UseType.HOLD : AbstractAbility.UseType.INSTANT;
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        Entity target = this.getTarget(entity.getLevel(), this.TargetID);
        return target == null ? 15 : 0;
    }

    public boolean canUse(IAbstractChangedEntity entity) {
        Entity target = this.getTarget(entity.getLevel(), this.TargetID);
        LivingEntity self = entity.getEntity();
        if (target != null) {
            Player player;
            LivingEntity livingTarget;
            IAbstractChangedEntity grabberOfTarget;
            if (target instanceof LivingEntity && (grabberOfTarget = GrabEntityAbility.getGrabber((LivingEntity)(livingTarget = (LivingEntity)target))) != null) {
                if (grabberOfTarget.getEntity().m_7306_((Entity)self)) {
                    return false;
                }
                return false;
            }
            if (entity.getEntity().m_20270_(target) > 10.0f) {
                return self.m_6144_();
            }
            if (target instanceof Player && PsychicGrab.isSpectator((Entity)(player = (Player)target))) {
                return false;
            }
            if (self.f_20916_ > 0 && self.m_142581_() == target) {
                return false;
            }
        }
        return !PsychicGrab.isSpectator((Entity)entity.getEntity());
    }

    public boolean canKeepUsing(IAbstractChangedEntity entity) {
        Entity target = this.getTarget(entity.getLevel(), this.TargetID);
        LivingEntity self = entity.getEntity();
        if (target != null) {
            Player player;
            if (entity.getEntity().m_20270_(target) > 10.0f) {
                return false;
            }
            if (target instanceof Player && PsychicGrab.isSpectator((Entity)(player = (Player)target))) {
                return false;
            }
            if (self.f_20916_ > 0 && self.m_142581_() == target) {
                return false;
            }
        }
        return !PsychicGrab.isSpectator((Entity)entity.getEntity());
    }

    public void startUsing(IAbstractChangedEntity entity) {
        AbstractArrowAccessor arrowAccessor;
        AbstractArrow arrow;
        Projectile projectile;
        if (entity.getLevel().m_5776_()) {
            return;
        }
        Entity target = this.getTarget(entity.getLevel(), this.TargetID);
        Entity lookingAt = PlayerUtil.getEntityLookingAt((Entity)entity.getEntity(), 6.0);
        if (entity.getEntity().m_6144_() || this.getTargetByID(entity.getLevel(), this.TargetID) == null) {
            if (lookingAt == null) {
                return;
            }
            this.TargetID = lookingAt.m_142081_();
            super.startUsing(entity);
            return;
        }
        if (!target.m_6084_()) {
            if (lookingAt == null) {
                return;
            }
            this.TargetID = lookingAt.m_142081_();
        }
        if (target instanceof Projectile && (projectile = (Projectile)target) instanceof AbstractArrow && (arrow = (AbstractArrow)projectile) instanceof AbstractArrowAccessor && (arrowAccessor = (AbstractArrowAccessor)arrow).inGround()) {
            arrowAccessor.setInGround(false);
            arrow.m_20256_(this.look.m_82546_(target.m_20182_()));
        }
        super.startUsing(entity);
    }

    public void tick(IAbstractChangedEntity entity) {
        super.tick(entity);
        Entity target = this.getTarget(entity.getLevel(), this.TargetID);
        if (target != null) {
            if (entity.getEntity().m_6144_() && entity.getAbilityInstance((AbstractAbility)this) != null && ((SimpleAbilityInstance)entity.getAbilityInstance((AbstractAbility)this)).getController().getHoldTicks() <= 3) {
                Entity lookingAt = PlayerUtil.getEntityLookingAt((Entity)entity.getEntity(), 6.0);
                if (lookingAt != null && lookingAt != this.getTargetByID(entity.getLevel(), this.TargetID)) {
                    this.TargetID = lookingAt.m_142081_();
                }
                return;
            }
            this.look = FoxyasUtils.getRelativePositionEyes((Entity)entity.getEntity(), this.offset.m_82520_(0.0, 0.0, 2.0));
            target.m_20256_(this.look.m_82546_(target.m_20182_()).m_82490_(0.1));
        }
    }

    public void saveData(CompoundTag tag, IAbstractChangedEntity entity) {
        ListTag offsetList = new ListTag();
        offsetList.add((Object)DoubleTag.m_128500_((double)this.offset.m_7096_()));
        offsetList.add((Object)DoubleTag.m_128500_((double)this.offset.m_7098_()));
        offsetList.add((Object)DoubleTag.m_128500_((double)this.offset.m_7094_()));
        tag.m_128365_("Offset", (Tag)offsetList);
        tag.m_128362_("TargetUUID", this.TargetID);
        super.saveData(tag, entity);
    }

    public void readData(CompoundTag tag, IAbstractChangedEntity entity) {
        ListTag list;
        if (tag.m_128425_("Offset", 9) && (list = tag.m_128437_("Offset", 6)).size() == 3) {
            this.offset = new Vec3(list.m_128772_(0), list.m_128772_(1), list.m_128772_(2));
        }
        if (tag.m_128403_("TargetUUID")) {
            this.TargetID = tag.m_128342_("TargetUUID");
        }
        super.readData(tag, entity);
    }

    public void setOffset(Vec3 offset) {
        this.offset = offset;
    }

    public void addOffset(int keyCode, Player player) {
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        boolean shift = player.m_6144_();
        switch (keyCode) {
            case 265: {
                dz = shift ? 0.5 : 0.0;
                dy = shift ? 0.0 : 0.5;
                break;
            }
            case 264: {
                dz = shift ? -0.5 : 0.0;
                dy = shift ? 0.0 : -0.5;
                break;
            }
            case 263: {
                dx = 0.5;
                break;
            }
            case 262: {
                dx = -0.5;
                break;
            }
            default: {
                return;
            }
        }
        Vec3 newOffset = this.offset.m_82520_(dx, dy, dz);
        this.offset = new Vec3(Mth.m_14008_((double)newOffset.f_82479_, (double)-3.0, (double)3.0), Mth.m_14008_((double)newOffset.f_82480_, (double)-3.0, (double)3.0), Mth.m_14008_((double)newOffset.f_82481_, (double)0.0, (double)4.0));
    }
}

