/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.util.List;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.ability.SimpleAbility;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PsychicHoldAbility
extends SimpleAbility {
    public TranslatableComponent getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.psychic_hold");
    }

    public ResourceLocation getTexture(IAbstractChangedEntity entity) {
        return new ResourceLocation("changed_addon:textures/screens/psychic_hold.png");
    }

    public boolean canUse(IAbstractChangedEntity entity) {
        return !entity.getEntity().m_5833_();
    }

    public AbstractAbility.UseType getUseType(IAbstractChangedEntity entity) {
        return AbstractAbility.UseType.HOLD;
    }

    public void startUsing(IAbstractChangedEntity entity) {
        super.startUsing(entity);
    }

    public void tick(IAbstractChangedEntity entity_) {
        LivingEntity livingEntity = entity_.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Vec3 playerPos = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
        double maxRange = 16.0;
        double repelRange = 2.5;
        double stopSpeedThreshold = 0.5;
        List nearbyEntities = player.f_19853_.m_6443_(Entity.class, new AABB(playerPos, playerPos).m_82400_(8.0), e -> e instanceof FallingBlockEntity || e.m_6095_().m_204039_(EntityTypeTags.f_13124_) && !e.m_20096_());
        if (!player.m_5833_() && !nearbyEntities.isEmpty()) {
            player.m_36399_(0.025f);
        }
        for (Entity projectile : nearbyEntities) {
            Vec3 projectilePos = projectile.m_20182_();
            Vec3 toPlayer = playerPos.m_82546_(projectilePos).m_82541_();
            double distance = projectilePos.m_82554_(playerPos);
            if (projectile.m_20096_()) {
                return;
            }
            Vec3 currentMotion = projectile.m_20184_();
            if (distance > 2.5 && currentMotion.m_82556_() <= 0.25) {
                projectile.m_20256_(Vec3.f_82478_);
                continue;
            }
            if (distance <= 2.5) {
                Vec3 repelForce = toPlayer.m_82490_(-1.0 * ((2.5 - distance) * 1.5));
                projectile.m_20256_(currentMotion.m_82549_(repelForce));
                continue;
            }
            double slowFactor = Math.max(0.1, 1.0 - distance / 8.0);
            Vec3 reducedMotion = currentMotion.m_82490_(slowFactor);
            double dotProduct = currentMotion.m_82541_().m_82526_(toPlayer);
            if (!(dotProduct > 0.0)) continue;
            projectile.m_20256_(reducedMotion);
        }
    }
}

