/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.util.ArrayList;
import java.util.Collection;
import net.foxyas.changedaddon.client.renderer.layers.features.RenderMode;
import net.foxyas.changedaddon.network.PacketUtil;
import net.foxyas.changedaddon.network.packets.ClientboundSonarUpdatePacket;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.ability.SimpleAbility;
import net.ltxprogrammer.changed.entity.VisionType;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SonarAbility
extends SimpleAbility {
    public TranslatableComponent getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.sonar");
    }

    public Collection<Component> getAbilityDescription(IAbstractChangedEntity entity) {
        ArrayList<Component> description = new ArrayList<Component>(super.getAbilityDescription(entity));
        description.add((Component)new TranslatableComponent("changed_addon.ability.sonar.desc"));
        return description;
    }

    public boolean canUse(IAbstractChangedEntity entity) {
        return true;
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        return 600;
    }

    public void startUsing(IAbstractChangedEntity entity) {
        super.startUsing(entity);
        LivingEntity livingEntity = entity.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            RenderMode mode;
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            TransfurVariant transfurVariant = entity.getTransfurVariant();
            if (transfurVariant == null) {
                return;
            }
            RenderMode renderMode = mode = transfurVariant.visionType == VisionType.BLIND ? RenderMode.ECHO_LOCATION : RenderMode.SONAR;
            if (mode == RenderMode.ECHO_LOCATION || transfurVariant.is((TransfurVariant)ChangedAddonTransfurVariants.VOID_FOX.get())) {
                PacketUtil.playSound(serverPlayer.m_183503_(), sPlayer -> sPlayer.m_7306_((Entity)serverPlayer), serverPlayer.m_20182_(), SoundEvents.f_144243_, SoundSource.PLAYERS, 4.0f, 1.0f);
            }
            ClientboundSonarUpdatePacket.update(serverPlayer, 400, 10, 50, 32.0f, mode);
        }
    }
}

