/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.awt.Color;
import java.util.Random;
import net.foxyas.changedaddon.entity.advanced.AbstractKitsuneEntity;
import net.foxyas.changedaddon.util.FoxyasUtils;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.ability.SimpleAbility;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TeleportAbility
extends SimpleAbility {
    public static boolean Spectator(Entity entity) {
        Player player;
        return entity instanceof Player && (player = (Player)entity).m_5833_();
    }

    public TranslatableComponent getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.teleport");
    }

    public ResourceLocation getTexture(IAbstractChangedEntity entity) {
        return new ResourceLocation("changed_addon:textures/screens/dodge_ability.png");
    }

    public AbstractAbility.UseType getUseType(IAbstractChangedEntity entity) {
        return AbstractAbility.UseType.CHARGE_TIME;
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        return 30;
    }

    public int getChargeTime(IAbstractChangedEntity entity) {
        return 15;
    }

    public boolean canUse(IAbstractChangedEntity entity) {
        return !TeleportAbility.Spectator((Entity)entity.getEntity());
    }

    public void startUsing(IAbstractChangedEntity entity) {
        super.startUsing(entity);
        LivingEntity living = entity.getEntity();
        if (living instanceof Player) {
            Player player = (Player)living;
            Vec3 eyeLocation = FoxyasUtils.getRelativePositionEyes((Entity)player, 0.0f, 0.0f, 16.0f);
            BlockHitResult blockHitResult = player.m_183503_().m_45547_(new ClipContext(player.m_146892_(), eyeLocation, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            Vec3 location = blockHitResult.m_82450_();
            player.m_20324_(location.f_82479_, location.f_82480_, location.f_82481_);
            player.m_36399_(4.0f);
            if (entity.getChangedEntity() instanceof AbstractKitsuneEntity) {
                this.applyKitsuneTeleportEffects(entity, player);
            } else {
                Level levelAccessor = player.m_183503_();
                levelAccessor.m_5594_(null, player.m_142538_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (levelAccessor instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)levelAccessor;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), 20, 0.5, 1.0, 0.5, 0.1);
                }
            }
        }
    }

    private void applyKitsuneTeleportEffects(IAbstractChangedEntity entity, Player player) {
        Color startColor = new Color(0xFFEEEE);
        Color endColor = new Color(0xFFCECE);
        ParticlesUtil.sendColorTransitionParticles(player.m_183503_(), player, startColor, endColor, 1.0f, 0.25f, 0.25f, 0.25f, 10, 0.25f);
        Random random = entity.getLevel().m_5822_();
        float pitch = random.nextFloat() + 1.0f;
        float volume = 0.5f;
        player.m_183503_().m_6269_(null, (Entity)player, SoundEvents.f_11953_, SoundSource.MASTER, volume, pitch);
    }

    public void onRemove(IAbstractChangedEntity entity) {
        super.onRemove(entity);
    }
}

