/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.ability.SimpleAbility;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WindControlAbility
extends SimpleAbility {
    public void saveData(CompoundTag tag, IAbstractChangedEntity entity) {
        super.saveData(tag, entity);
    }

    public void readData(CompoundTag tag, IAbstractChangedEntity entity) {
        super.readData(tag, entity);
    }

    public Component getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.wind_control");
    }

    public Collection<Component> getAbilityDescription(IAbstractChangedEntity entity) {
        ArrayList<Component> list = new ArrayList<Component>(super.getAbilityDescription(entity));
        list.add((Component)new TranslatableComponent("changed_addon.ability.wind_control.desc"));
        list.add((Component)new TranslatableComponent("changed_addon.ability.wind_control.desc2"));
        return list;
    }

    public AbstractAbility.UseType getUseType(IAbstractChangedEntity entity) {
        return AbstractAbility.UseType.INSTANT;
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        return entity.isCrouching() ? 40 : 20;
    }

    public boolean canUse(IAbstractChangedEntity entity) {
        return entity.getTransfurVariantInstance() != null;
    }

    public boolean canKeepUsing(IAbstractChangedEntity entity) {
        return entity.getTransfurVariantInstance() != null;
    }

    public void startUsing(IAbstractChangedEntity entity) {
        if (!entity.getLevel().m_5776_()) {
            this.runAbility(entity.getEntity());
            this.setDirty(entity);
        }
    }

    public void runAbility(LivingEntity living) {
        if (living.m_6144_()) {
            this.runAbilityShift(living);
        } else {
            this.runDash(living);
        }
    }

    public void runDash(LivingEntity living) {
        if (living.m_183503_().m_5776_()) {
            return;
        }
        double dashStrength = 2.0;
        Vec3 look = living.m_20154_().m_82541_();
        living.m_5997_(look.f_82479_ * dashStrength, 0.1, look.f_82481_ * dashStrength);
        living.f_19864_ = true;
        living.m_183503_().m_5594_(null, living.m_142538_(), ChangedSounds.BOW2, SoundSource.PLAYERS, 1.0f, 1.0f);
        Level level = living.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, living.m_20185_(), living.m_20186_(), living.m_20189_(), 10, 0.3, 0.2, 0.3, 0.05);
        }
    }

    public void runAbilityShift(LivingEntity living) {
        Level level = living.m_183503_();
        if (level.m_5776_()) {
            return;
        }
        double radius = 5.0;
        double strength = 1.5;
        List nearby = level.m_6443_(LivingEntity.class, living.m_142469_().m_82400_(radius), e -> e != living);
        for (LivingEntity target : nearby) {
            double dx = target.m_20185_() - living.m_20185_();
            double dz = target.m_20189_() - living.m_20189_();
            double dist = Math.max(0.1, Math.sqrt(dx * dx + dz * dz));
            target.m_5997_(dx / dist * strength, 0.5, dz / dist * strength);
            target.f_19864_ = true;
        }
        living.m_21011_(InteractionHand.MAIN_HAND, true);
        level.m_5594_(null, living.m_142538_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        Level level2 = living.m_183503_();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, living.m_20185_(), living.m_20186_(), living.m_20189_(), 10, 0.3, 0.2, 0.3, 0.05);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, living.m_20185_(), living.m_20186_(), living.m_20189_(), 10, 1.0, 0.5, 1.0, 0.1);
        }
    }
}

